/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Digest;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.Util;

public class DigestTest
extends TestCase {
    Digest d;
    Digest d2;
    MutableDigest md;
    IpAddress a1;
    IpAddress a2;
    IpAddress a3;

    public DigestTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        HashMap<Address, Digest.Entry> map = new HashMap<Address, Digest.Entry>();
        this.a1 = new IpAddress(5555);
        this.a2 = new IpAddress(6666);
        this.a3 = new IpAddress(7777);
        map.put(this.a1, new Digest.Entry(4L, 500L, 501L));
        map.put(this.a2, new Digest.Entry(25L, 26L, 26L));
        map.put(this.a3, new Digest.Entry(20L, 25L, 33L));
        this.d = new Digest(map);
        this.md = new MutableDigest(map);
    }

    public void testSize() {
        this.d2 = new Digest(3);
        DigestTest.assertEquals((int)0, (int)this.d2.size());
    }

    public void testEquals() {
        this.d2 = this.d.copy();
        System.out.println("d: " + this.d + "\nd2= " + this.d2);
        DigestTest.assertEquals((Object)this.d, (Object)this.d);
        DigestTest.assertEquals((Object)this.d, (Object)this.d2);
    }

    public void testDifference() {
        HashMap<Address, Digest.Entry> map = new HashMap<Address, Digest.Entry>();
        this.a1 = new IpAddress(5555);
        this.a2 = new IpAddress(6666);
        this.a3 = new IpAddress(7777);
        map.put(this.a1, new Digest.Entry(4L, 500L, 501L));
        map.put(this.a2, new Digest.Entry(25L, 26L, 26L));
        map.put(this.a3, new Digest.Entry(20L, 25L, 33L));
        Digest digest = new Digest(map);
        HashMap<Address, Digest.Entry> map2 = new HashMap<Address, Digest.Entry>();
        map2.put(this.a1, new Digest.Entry(4L, 500L, 501L));
        map2.put(this.a2, new Digest.Entry(25L, 26L, 26L));
        map2.put(this.a3, new Digest.Entry(20L, 37L, 33L));
        Digest digest2 = new Digest(map2);
        DigestTest.assertNotSame((Object)digest, (Object)digest2);
        Digest diff = digest2.difference(digest);
        System.out.println(diff);
        DigestTest.assertTrue((boolean)diff.contains(this.a3));
        DigestTest.assertEquals((int)1, (int)diff.size());
        HashMap<Address, Digest.Entry> map3 = new HashMap<Address, Digest.Entry>();
        map3.put(this.a1, new Digest.Entry(4L, 500L, 501L));
        map3.put(this.a2, new Digest.Entry(25L, 26L, 26L));
        map3.put(this.a3, new Digest.Entry(20L, 37L, 33L));
        map3.put(new IpAddress(8888), new Digest.Entry(1L, 2L, 3L));
        Digest digest3 = new Digest(map3);
        diff = digest3.difference(digest);
        System.out.println(diff);
        DigestTest.assertEquals((int)2, (int)diff.size());
        diff = digest3.difference(digest2);
        System.out.println(diff);
        DigestTest.assertEquals((int)1, (int)diff.size());
        Digest diff2 = digest2.difference(digest3);
        System.out.println(diff2);
        DigestTest.assertEquals((int)1, (int)diff2.size());
        DigestTest.assertEquals((Object)diff, (Object)diff2);
    }

    public void testIsGreaterThanOrEqual() {
        HashMap<Address, Digest.Entry> map = new HashMap<Address, Digest.Entry>();
        map.put(this.a1, new Digest.Entry(4L, 500L, 501L));
        map.put(this.a2, new Digest.Entry(25L, 26L, 26L));
        map.put(this.a3, new Digest.Entry(20L, 25L, 33L));
        Digest my = new Digest(map);
        System.out.println("\nd: " + this.d + "\nmy: " + my);
        DigestTest.assertTrue((boolean)my.isGreaterThanOrEqual(this.d));
        map.remove(this.a3);
        map.put(this.a3, new Digest.Entry(20L, 26L, 33L));
        my = new Digest(map);
        System.out.println("\nd: " + this.d + "\nmy: " + my);
        DigestTest.assertTrue((boolean)my.isGreaterThanOrEqual(this.d));
        map.remove(this.a3);
        map.put(this.a3, new Digest.Entry(20L, 22L, 32L));
        my = new Digest(map);
        System.out.println("\nd: " + this.d + "\nmy: " + my);
        DigestTest.assertFalse((boolean)my.isGreaterThanOrEqual(this.d));
    }

    public void testEquals2() {
        this.md = new MutableDigest(this.d);
        System.out.println("d: " + this.d + "\nmd= " + this.md);
        DigestTest.assertEquals((Object)this.d, (Object)this.d);
        DigestTest.assertEquals((Object)this.d, (Object)this.md);
        this.md.incrementHighestDeliveredSeqno(this.a1);
        System.out.println("d: " + this.d + "\nmd= " + this.md);
        DigestTest.assertFalse((boolean)this.d.equals(this.md));
    }

    public void testMutability() {
        MutableDigest md2 = this.md;
        DigestTest.assertEquals((Object)this.md, (Object)md2);
        this.md.incrementHighestDeliveredSeqno(this.a2);
        DigestTest.assertEquals((Object)this.md, (Object)md2);
    }

    public void testImmutability() {
        MutableDigest tmp = new MutableDigest(this.d);
        DigestTest.assertEquals((Object)this.d, (Object)tmp);
        tmp.incrementHighestDeliveredSeqno(this.a2);
        DigestTest.assertFalse((boolean)this.d.equals(tmp));
    }

    public void testImmutability2() {
        Digest tmp = this.d.copy();
        DigestTest.assertEquals((Object)this.d, (Object)tmp);
    }

    public void testImmutability3() {
        Digest tmp = new Digest(this.d);
        DigestTest.assertEquals((Object)tmp, (Object)this.d);
    }

    public void testImmutability4() {
        Digest copy = this.md.copy();
        DigestTest.assertEquals((Object)copy, (Object)this.md);
        this.md.incrementHighestDeliveredSeqno(this.a1);
        DigestTest.assertFalse((boolean)copy.equals(this.md));
    }

    public void testSeal() {
        MutableDigest tmp = new MutableDigest(3);
        tmp.add(this.a2, 1L, 2L, 3L);
        DigestTest.assertEquals((int)1, (int)tmp.size());
        tmp.seal();
        try {
            tmp.add(this.a2, 4L, 5L, 6L);
            DigestTest.fail((String)"should run into an exception");
        }
        catch (IllegalAccessError e) {
            System.out.println("received exception \"" + e.toString() + "\" - as expected");
        }
        DigestTest.assertEquals((int)1, (int)tmp.size());
    }

    public void testSeal2() {
        this.md.incrementHighestDeliveredSeqno(this.a1);
        this.md.seal();
        try {
            this.md.incrementHighestDeliveredSeqno(this.a3);
            DigestTest.fail((String)"should run into an exception");
        }
        catch (IllegalAccessError e) {
            System.out.println("received exception \"" + e.toString() + "\" - as expected");
        }
        MutableDigest tmp = new MutableDigest(this.md);
        tmp.incrementHighestDeliveredSeqno(this.a3);
    }

    public void testAdd() {
        DigestTest.assertEquals((int)3, (int)this.md.size());
        this.md.add(this.a1, 100L, 200L, 201L);
        DigestTest.assertEquals((int)3, (int)this.md.size());
        this.md.add(new IpAddress(14526), 1L, 2L, 3L);
        DigestTest.assertEquals((int)4, (int)this.md.size());
    }

    public void testAddDigest() {
        Digest tmp = this.md.copy();
        this.md.add(tmp);
        DigestTest.assertEquals((int)3, (int)this.md.size());
    }

    public void testAddDigest2() {
        MutableDigest tmp = new MutableDigest(4);
        tmp.add(new IpAddress(1111), 1L, 2L, 3L);
        tmp.add(new IpAddress(2222), 1L, 2L, 3L);
        tmp.add(new IpAddress(5555), 1L, 2L, 3L);
        tmp.add(new IpAddress(6666), 1L, 2L, 3L);
        this.md.add(tmp);
        DigestTest.assertEquals((int)5, (int)this.md.size());
    }

    public void testGet() {
        Digest.Entry entry = this.d.get(this.a1);
        DigestTest.assertEquals((Object)entry, (Object)new Digest.Entry(4L, 500L, 501L));
        entry = this.d.get(this.a2);
        DigestTest.assertEquals((Object)entry, (Object)new Digest.Entry(25L, 26L, 26L));
        entry = this.d.get(this.a3);
        DigestTest.assertEquals((Object)entry, (Object)new Digest.Entry(20L, 25L, 33L));
    }

    public void testIncrementHighSeqno() {
        this.md = new MutableDigest(3);
        this.md.add(this.a1, 1L, 100L);
        this.md.add(this.a2, 3L, 300L);
        this.md.add(this.a3, 7L, 700L);
        long tmp = this.md.highestDeliveredSeqnoAt(this.a1);
        this.md.incrementHighestDeliveredSeqno(this.a1);
        DigestTest.assertEquals((long)this.md.highestDeliveredSeqnoAt(this.a1), (long)(tmp + 1L));
        tmp = this.md.highestDeliveredSeqnoAt(this.a2);
        this.md.incrementHighestDeliveredSeqno(this.a2);
        DigestTest.assertEquals((long)this.md.highestDeliveredSeqnoAt(this.a2), (long)(tmp + 1L));
        tmp = this.md.highestDeliveredSeqnoAt(this.a3);
        this.md.incrementHighestDeliveredSeqno(this.a3);
        DigestTest.assertEquals((long)this.md.highestDeliveredSeqnoAt(this.a3), (long)(tmp + 1L));
    }

    public void testConstructor() {
        DigestTest.assertEquals((int)3, (int)this.md.size());
        this.md.clear();
        DigestTest.assertEquals((int)0, (int)this.md.size());
        this.md.clear();
        DigestTest.assertEquals((int)0, (int)this.md.size());
    }

    public void testConstructor2() {
        Digest dd = new Digest(3);
        DigestTest.assertEquals((int)0, (int)dd.size());
    }

    public void testConstructor3() {
        MutableDigest dd = new MutableDigest(3);
        DigestTest.assertEquals((int)0, (int)dd.size());
    }

    public void testContains() {
        DigestTest.assertTrue((boolean)this.d.contains(this.a1));
        DigestTest.assertTrue((boolean)this.d.contains(this.a2));
        DigestTest.assertTrue((boolean)this.d.contains(this.a3));
    }

    public void testResetAt() {
        this.md.resetAt(this.a1);
        DigestTest.assertEquals((long)0L, (long)this.md.lowSeqnoAt(this.a1));
        DigestTest.assertEquals((long)0L, (long)this.md.highestDeliveredSeqnoAt(this.a1));
        DigestTest.assertEquals((long)0L, (long)this.md.highestReceivedSeqnoAt(this.a1));
    }

    public void testLowSeqnoAt() {
        DigestTest.assertEquals((long)4L, (long)this.d.lowSeqnoAt(this.a1));
        DigestTest.assertEquals((long)25L, (long)this.d.lowSeqnoAt(this.a2));
        DigestTest.assertEquals((long)20L, (long)this.d.lowSeqnoAt(this.a3));
    }

    public void testHighSeqnoAt() {
        DigestTest.assertEquals((long)500L, (long)this.d.highestDeliveredSeqnoAt(this.a1));
        DigestTest.assertEquals((long)26L, (long)this.d.highestDeliveredSeqnoAt(this.a2));
        DigestTest.assertEquals((long)25L, (long)this.d.highestDeliveredSeqnoAt(this.a3));
    }

    public void testHighSeqnoSeenAt() {
        DigestTest.assertEquals((long)501L, (long)this.d.highestReceivedSeqnoAt(this.a1));
        DigestTest.assertEquals((long)26L, (long)this.d.highestReceivedSeqnoAt(this.a2));
        DigestTest.assertEquals((long)33L, (long)this.d.highestReceivedSeqnoAt(this.a3));
    }

    public void testSetHighestDeliveredAndSeenSeqnoAt() {
        DigestTest.assertEquals((long)4L, (long)this.d.lowSeqnoAt(this.a1));
        DigestTest.assertEquals((long)500L, (long)this.d.highestDeliveredSeqnoAt(this.a1));
        DigestTest.assertEquals((long)501L, (long)this.md.highestReceivedSeqnoAt(this.a1));
        this.md.setHighestDeliveredAndSeenSeqnos(this.a1, 2L, 10L, 20L);
        DigestTest.assertEquals((long)2L, (long)this.md.lowSeqnoAt(this.a1));
        DigestTest.assertEquals((long)10L, (long)this.md.highestDeliveredSeqnoAt(this.a1));
        DigestTest.assertEquals((long)20L, (long)this.md.highestReceivedSeqnoAt(this.a1));
    }

    public void testCopy() {
        this.d = this.d.copy();
        this.testLowSeqnoAt();
        this.testHighSeqnoAt();
        this.testHighSeqnoSeenAt();
        this.testContains();
        this.testResetAt();
    }

    public void testCopy2() {
        Digest tmp = this.d.copy();
        DigestTest.assertEquals((Object)tmp, (Object)this.d);
    }

    public void testMutableCopy() {
        Digest copy = this.md.copy();
        System.out.println("md=" + this.md + "\ncopy=" + copy);
        DigestTest.assertEquals((Object)this.md, (Object)copy);
        this.md.add(this.a1, 4L, 500L, 1000L);
        System.out.println("md=" + this.md + "\ncopy=" + copy);
        DigestTest.assertFalse((boolean)this.md.equals(copy));
    }

    public void testMerge() {
        HashMap<Address, Digest.Entry> map = new HashMap<Address, Digest.Entry>();
        map.put(this.a1, new Digest.Entry(3L, 499L, 502L));
        map.put(this.a2, new Digest.Entry(20L, 26L, 27L));
        map.put(this.a3, new Digest.Entry(21L, 26L, 35L));
        MutableDigest digest = new MutableDigest(map);
        System.out.println("d: " + this.d);
        System.out.println("digest: " + digest);
        digest.merge(this.d);
        System.out.println("merged digest: " + digest);
        DigestTest.assertEquals((int)3, (int)this.d.size());
        DigestTest.assertEquals((int)3, (int)digest.size());
        DigestTest.assertEquals((long)3L, (long)digest.lowSeqnoAt(this.a1));
        DigestTest.assertEquals((long)500L, (long)digest.highestDeliveredSeqnoAt(this.a1));
        DigestTest.assertEquals((long)502L, (long)digest.highestReceivedSeqnoAt(this.a1));
        DigestTest.assertEquals((long)20L, (long)digest.lowSeqnoAt(this.a2));
        DigestTest.assertEquals((long)26L, (long)digest.highestDeliveredSeqnoAt(this.a2));
        DigestTest.assertEquals((long)27L, (long)digest.highestReceivedSeqnoAt(this.a2));
        DigestTest.assertEquals((long)20L, (long)digest.lowSeqnoAt(this.a3));
        DigestTest.assertEquals((long)26L, (long)digest.highestDeliveredSeqnoAt(this.a3));
        DigestTest.assertEquals((long)35L, (long)digest.highestReceivedSeqnoAt(this.a3));
    }

    public void testNonConflictingMerge() {
        MutableDigest cons_d = new MutableDigest(5);
        IpAddress ip1 = new IpAddress(1111);
        IpAddress ip2 = new IpAddress(2222);
        cons_d.add(ip1, 1L, 10L, 10L);
        cons_d.add(ip2, 2L, 20L, 20L);
        cons_d.merge(this.d);
        DigestTest.assertEquals((int)5, (int)cons_d.size());
        DigestTest.assertEquals((long)1L, (long)cons_d.lowSeqnoAt(ip1));
        DigestTest.assertEquals((long)2L, (long)cons_d.lowSeqnoAt(ip2));
        DigestTest.assertEquals((long)4L, (long)cons_d.lowSeqnoAt(this.a1));
        DigestTest.assertEquals((long)25L, (long)cons_d.lowSeqnoAt(this.a2));
        DigestTest.assertEquals((long)20L, (long)cons_d.lowSeqnoAt(this.a3));
        DigestTest.assertEquals((long)10L, (long)cons_d.highestDeliveredSeqnoAt(ip1));
        DigestTest.assertEquals((long)20L, (long)cons_d.highestDeliveredSeqnoAt(ip2));
        DigestTest.assertEquals((long)500L, (long)cons_d.highestDeliveredSeqnoAt(this.a1));
        DigestTest.assertEquals((long)26L, (long)cons_d.highestDeliveredSeqnoAt(this.a2));
        DigestTest.assertEquals((long)25L, (long)cons_d.highestDeliveredSeqnoAt(this.a3));
        DigestTest.assertEquals((long)10L, (long)cons_d.highestReceivedSeqnoAt(ip1));
        DigestTest.assertEquals((long)20L, (long)cons_d.highestReceivedSeqnoAt(ip2));
        DigestTest.assertEquals((long)501L, (long)cons_d.highestReceivedSeqnoAt(this.a1));
        DigestTest.assertEquals((long)26L, (long)cons_d.highestReceivedSeqnoAt(this.a2));
        DigestTest.assertEquals((long)33L, (long)cons_d.highestReceivedSeqnoAt(this.a3));
    }

    public void testConflictingMerge() {
        MutableDigest new_d = new MutableDigest(2);
        new_d.add(this.a1, 5L, 450L, 501L);
        new_d.add(this.a3, 18L, 28L, 35L);
        this.md.merge(new_d);
        DigestTest.assertEquals((int)3, (int)this.md.size());
        DigestTest.assertEquals((long)4L, (long)this.md.lowSeqnoAt(this.a1));
        DigestTest.assertEquals((long)500L, (long)this.md.highestDeliveredSeqnoAt(this.a1));
        DigestTest.assertEquals((long)501L, (long)this.md.highestReceivedSeqnoAt(this.a1));
        DigestTest.assertEquals((long)25L, (long)this.md.lowSeqnoAt(this.a2));
        DigestTest.assertEquals((long)26L, (long)this.md.highestDeliveredSeqnoAt(this.a2));
        DigestTest.assertEquals((long)26L, (long)this.md.highestReceivedSeqnoAt(this.a2));
        DigestTest.assertEquals((long)18L, (long)this.md.lowSeqnoAt(this.a3));
        DigestTest.assertEquals((long)28L, (long)this.md.highestDeliveredSeqnoAt(this.a3));
        DigestTest.assertEquals((long)35L, (long)this.md.highestReceivedSeqnoAt(this.a3));
    }

    public void testSameSendersOtherIsNull() {
        DigestTest.assertFalse((boolean)this.d.sameSenders(null));
    }

    public void testSameSenders1MNullDifferentLenth() {
        this.d2 = new Digest(1);
        DigestTest.assertFalse((boolean)this.d2.sameSenders(this.d));
    }

    public void testSameSenders1MNullSameLength() {
        this.d2 = new Digest(3);
        DigestTest.assertFalse((boolean)this.d2.sameSenders(this.d));
    }

    public void testSameSendersIdentical() {
        this.d2 = this.d.copy();
        DigestTest.assertTrue((boolean)this.d.sameSenders(this.d2));
    }

    public void testSameSendersNotIdentical() {
        MutableDigest tmp = new MutableDigest(3);
        tmp.add(this.a1, 4L, 500L, 501L);
        tmp.add(this.a3, 20L, 25L, 33L);
        tmp.add(this.a2, 25L, 26L, 26L);
        DigestTest.assertTrue((boolean)this.md.sameSenders(tmp));
        DigestTest.assertTrue((boolean)this.d.sameSenders(tmp));
    }

    public void testSameSendersNotSameLength() {
        this.md = new MutableDigest(3);
        this.md.add(this.a1, 4L, 500L, 501L);
        this.md.add(this.a2, 25L, 26L, 26L);
        DigestTest.assertFalse((boolean)this.d.sameSenders(this.md));
    }

    public void testStreamable() throws IOException, IllegalAccessException, InstantiationException {
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(outstream);
        this.d.writeTo(dos);
        dos.close();
        byte[] buf = outstream.toByteArray();
        ByteArrayInputStream instream = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(instream);
        Digest tmp = new Digest();
        tmp.readFrom(dis);
        DigestTest.assertEquals((Object)this.d, (Object)tmp);
    }

    public void testSerializedSize() throws Exception {
        long len = this.d.serializedSize();
        byte[] buf = Util.streamableToByteBuffer(this.d);
        DigestTest.assertEquals((long)len, (long)buf.length);
    }

    public static Test suite() {
        return new TestSuite(DigestTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)DigestTest.suite());
    }
}

