/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.pojo.impl;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.aop.Advised;
import org.jboss.aop.ClassInstanceAdvisor;
import org.jboss.aop.InstanceAdvisor;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.pojo.PojoCacheException;
import org.jboss.cache.pojo.Reference;
import org.jboss.cache.pojo.impl.AbstractHandler;
import org.jboss.cache.pojo.impl.CachedType;
import org.jboss.cache.pojo.impl.InternalHelper;
import org.jboss.cache.pojo.impl.PojoCacheImpl;
import org.jboss.cache.pojo.impl.PojoInstance;
import org.jboss.cache.pojo.impl.PojoUtil;
import org.jboss.cache.pojo.interceptors.dynamic.CacheFieldInterceptor;
import org.jboss.cache.pojo.memory.FieldPersistentReference;
import org.jboss.cache.pojo.util.AopUtil;
import org.jboss.cache.pojo.util.Instantiator;
import org.jboss.cache.pojo.util.ObjectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AdvisedPojoHandler
extends AbstractHandler {
    private final Log log = LogFactory.getLog(AdvisedPojoHandler.class);
    private Cache<Object, Object> cache_;
    private PojoCacheImpl pCache_;
    private PojoUtil util_;

    public AdvisedPojoHandler(PojoCacheImpl pCache, InternalHelper internal, PojoUtil util) {
        this.pCache_ = pCache;
        this.cache_ = this.pCache_.getCache();
        this.util_ = util;
    }

    @Override
    protected Fqn<?> getFqn(Object obj) {
        if (obj instanceof Advised) {
            InstanceAdvisor advisor = ((Advised)obj)._getInstanceAdvisor();
            if (advisor == null) {
                throw new PojoCacheException("_putObject(): InstanceAdvisor is null for: " + obj);
            }
            CacheFieldInterceptor interceptor = AopUtil.findCacheInterceptor(advisor);
            if (interceptor != null) {
                return interceptor.getFqn();
            }
        }
        return null;
    }

    @Override
    protected Object get(Fqn<?> fqn, Class<?> clazz, PojoInstance pojoInstance) throws CacheException {
        CachedType type = this.pCache_.getCachedType(clazz);
        Object obj = Instantiator.newInstance(clazz);
        try {
            for (FieldPersistentReference ref : type.getFinalFields()) {
                Field field = ref.getField();
                Object result = CachedType.isSimpleAttribute(field) ? this.cache_.get(fqn, (Object)field.getName()) : this.pCache_.find(fqn, field.getName(), obj);
                field.set(obj, result);
            }
        }
        catch (Exception e) {
            this.log.warn((Object)("Could not initialize final fields on object: " + ObjectUtil.identityString(obj)));
        }
        InstanceAdvisor advisor = ((Advised)obj)._getInstanceAdvisor();
        CacheFieldInterceptor interceptor = new CacheFieldInterceptor(this.pCache_, fqn, type);
        interceptor.setAopInstance(pojoInstance);
        this.util_.attachInterceptor(obj, advisor, interceptor);
        return obj;
    }

    @Override
    protected void put(Fqn<?> fqn, Reference reference, Object obj) throws CacheException {
        CachedType type = this.pCache_.getCachedType(obj.getClass());
        InstanceAdvisor advisor = ((Advised)obj)._getInstanceAdvisor();
        if (advisor == null) {
            advisor = new ClassInstanceAdvisor(obj);
            ((Advised)obj)._setInstanceAdvisor(advisor);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        PojoInstance pojoInstance = InternalHelper.initializeAopInstance(reference);
        map.put("POJOCache.PojoInstance", pojoInstance);
        pojoInstance.setPojoClass(type.getType());
        HashMap<Field, Object> subPojoMap = new HashMap<Field, Object>();
        Iterator<FieldPersistentReference> i = type.getFields().iterator();
        while (i.hasNext()) {
            Field field = (Field)i.next().get();
            Object value = null;
            try {
                value = field.get(obj);
            }
            catch (IllegalAccessException e) {
                throw new CacheException("field access failed", (Throwable)e);
            }
            if (CachedType.isSimpleAttribute(field)) {
                map.put(field.getName(), value);
                continue;
            }
            subPojoMap.put(field, value);
        }
        this.cache_.getRoot().addChild(fqn).putAll(map);
        CacheFieldInterceptor interceptor = new CacheFieldInterceptor(this.pCache_, fqn, type);
        interceptor.setAopInstance(pojoInstance);
        this.util_.attachInterceptor(obj, advisor, interceptor);
        InternalHelper.setPojo(pojoInstance, obj);
        for (Object o : subPojoMap.keySet()) {
            Field field = (Field)o;
            Object value = subPojoMap.get(field);
            if (value == null) continue;
            this.pCache_.attach(fqn, value, field.getName(), obj);
            if (!(value instanceof Map) && !(value instanceof List) && !(value instanceof Set)) continue;
            Object newValue = this.pCache_.find(fqn, field.getName(), obj);
            this.util_.inMemorySubstitution(obj, field, newValue);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("internalPut(): inserting with fqn: " + fqn));
        }
    }

    @Override
    protected Object remove(Fqn<?> fqn, Reference referencingFqn, Object result) throws CacheException {
        CachedType type = this.pCache_.getCachedType(result.getClass());
        InstanceAdvisor advisor = ((Advised)result)._getInstanceAdvisor();
        Iterator<FieldPersistentReference> i = type.getFields().iterator();
        while (i.hasNext()) {
            Field field = (Field)i.next().get();
            Object value = null;
            if (!CachedType.isSimpleAttribute(field)) {
                value = this.pCache_.detach(fqn, field.getName(), result);
                if (!(value instanceof Map) && !(value instanceof List) && !(value instanceof Set)) continue;
                this.util_.inMemorySubstitution(result, field, value);
                continue;
            }
            value = this.cache_.get(fqn, (Object)field.getName());
            this.util_.inMemorySubstitution(result, field, value);
        }
        this.cache_.removeNode(fqn);
        CacheFieldInterceptor interceptor = AopUtil.findCacheInterceptor(advisor);
        if (interceptor != null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("regularRemoveObject(): removed cache interceptor fqn: " + fqn + " interceptor: " + interceptor));
            }
            this.util_.detachInterceptor(advisor, interceptor);
        }
        return result;
    }

    @Override
    protected boolean handles(Class<?> clazz) {
        return Advised.class.isAssignableFrom(clazz);
    }
}

