/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.util;

import org.jboss.messaging.util.NamedThreadQueuedExecutor;
import org.jboss.messaging.util.SecurityActions;

public class JBMExecutor
extends NamedThreadQueuedExecutor {
    private boolean needToSetClassLoader = true;

    public JBMExecutor(String name) {
        super(name);
    }

    public void execute(Runnable runnable) throws InterruptedException {
        super.execute((Runnable)new TCLRunnable(runnable));
    }

    public void clearClassLoader() throws InterruptedException {
        super.execute(new Runnable(){

            public void run() {
                JBMExecutor.this.needToSetClassLoader = true;
            }
        });
    }

    public void clearAllExceptCurrentTask() {
        try {
            while (this.queue_.poll(0L) != null) {
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    class TCLRunnable
    implements Runnable {
        private final Runnable realRunnable;
        private ClassLoader tcl;

        public TCLRunnable(Runnable realRunnable) {
            if (JBMExecutor.this.needToSetClassLoader) {
                this.tcl = SecurityActions.getTCL();
            }
            this.realRunnable = realRunnable;
        }

        public void run() {
            if (JBMExecutor.this.needToSetClassLoader) {
                JBMExecutor.this.needToSetClassLoader = false;
                SecurityActions.setTCL(this.tcl);
            }
            this.realRunnable.run();
        }
    }
}

