/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.configuration;

import java.util.Collection;
import org.rhq.core.domain.configuration.AbstractPropertyMap;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.gui.configuration.AbstractConfigurationComponent;
import org.rhq.core.gui.configuration.AbstractPropertyBagUIComponentTreeFactory;
import org.rhq.core.gui.util.FacesExpressionUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapInConfigurationUIComponentTreeFactory
extends AbstractPropertyBagUIComponentTreeFactory {
    public MapInConfigurationUIComponentTreeFactory(AbstractConfigurationComponent configurationComponent, String mapName) {
        super(configurationComponent, MapInConfigurationUIComponentTreeFactory.getPropertyDefinitions(configurationComponent.getConfigurationDefinition(), mapName), (AbstractPropertyMap)configurationComponent.getConfiguration().getMap(mapName), false, MapInConfigurationUIComponentTreeFactory.createValueExpressionFormat(configurationComponent.getConfigurationExpressionString(), mapName));
    }

    static String createValueExpressionFormat(String configurationExpressionString, String mapName) {
        StringBuilder expression = new StringBuilder();
        expression.append("#{");
        expression.append(FacesExpressionUtility.unwrapExpressionString(configurationExpressionString));
        expression.append(".");
        expression.append("map");
        expression.append("['").append(mapName).append("'].");
        expression.append("map");
        expression.append("['%s'].");
        expression.append("stringValue");
        expression.append("}");
        return expression.toString();
    }

    private static Collection<PropertyDefinition> getPropertyDefinitions(ConfigurationDefinition configurationDefinition, String mapName) {
        return configurationDefinition.getPropertyDefinitionMap(mapName).getPropertyDefinitions().values();
    }
}

