/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.gui.configuration.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.UISelectItem;
import javax.faces.component.html.HtmlInputSecret;
import javax.faces.component.html.HtmlInputText;
import javax.faces.component.html.HtmlInputTextarea;
import javax.faces.component.html.HtmlSelectBooleanCheckbox;
import javax.faces.component.html.HtmlSelectOneMenu;
import javax.faces.component.html.HtmlSelectOneRadio;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionEnumeration;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.gui.converter.PropertySimpleValueConverter;
import org.rhq.core.gui.util.FacesComponentUtility;
import org.rhq.core.gui.util.FacesContextUtility;
import org.rhq.core.gui.util.PropertyIdGeneratorUtility;
import org.rhq.core.gui.validator.PropertySimpleValueValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyRenderingUtility {
    private static final int INPUT_TEXT_COMPONENT_WIDTH = 30;
    private static final int INPUT_TEXTAREA_COMPONENT_ROWS = 4;
    private static final String ERROR_MSG_STYLE_CLASS = "error-msg";
    private static final int LISTBOX_THRESHOLD_ENUM_SIZE = 6;
    private static final String UNIQUE_ID_PREFIX = "rhq_id";

    @NotNull
    public static UIInput createInputForSimpleProperty(PropertyDefinitionSimple propertyDefinitionSimple, PropertySimple propertySimple, ValueExpression propertyValueExpression, Integer listIndex, boolean configIsAggregate, boolean configReadOnly, boolean configFullyEditable, boolean prevalidate) {
        UIInput input = PropertyRenderingUtility.createInput(propertyDefinitionSimple);
        if (propertySimple != null) {
            PropertyRenderingUtility.addTitleAttribute(input, propertySimple.getStringValue());
        }
        boolean isUnset = PropertyRenderingUtility.isUnset(propertyDefinitionSimple, propertySimple, configIsAggregate);
        boolean isReadOnly = PropertyRenderingUtility.isReadOnly(propertyDefinitionSimple, propertySimple, configReadOnly, configFullyEditable);
        String propertyId = PropertyIdGeneratorUtility.getIdentifier((Property)propertySimple, listIndex);
        input.setId(propertyId);
        input.setValueExpression("value", propertyValueExpression);
        FacesComponentUtility.setUnset(input, isUnset);
        FacesComponentUtility.setReadonly(input, isReadOnly);
        PropertyRenderingUtility.addValidatorsAndConverter(input, propertyDefinitionSimple, configReadOnly);
        PropertyRenderingUtility.addErrorMessages(input, propertyDefinitionSimple, propertySimple, prevalidate);
        return input;
    }

    public static UIInput createInput(PropertyDefinitionSimple propertyDefinitionSimple) {
        UIInput input;
        PropertySimpleType type = propertyDefinitionSimple != null ? propertyDefinitionSimple.getType() : PropertySimpleType.STRING;
        switch (type) {
            case BOOLEAN: {
                input = PropertyRenderingUtility.createInputForBooleanProperty();
                break;
            }
            case LONG_STRING: {
                input = PropertyRenderingUtility.createInputForLongStringProperty();
                break;
            }
            case PASSWORD: {
                input = PropertyRenderingUtility.createInputForPasswordProperty();
                break;
            }
            default: {
                input = propertyDefinitionSimple != null && PropertyRenderingUtility.isEnum(propertyDefinitionSimple) ? PropertyRenderingUtility.createInputForEnumProperty(propertyDefinitionSimple) : PropertyRenderingUtility.createInputForStringProperty();
            }
        }
        input.setId(UNIQUE_ID_PREFIX + UUID.randomUUID());
        if (propertyDefinitionSimple != null) {
            input.getAttributes().put("label", propertyDefinitionSimple.getDisplayName());
            input.getAttributes().put("ondblclick", "//" + propertyDefinitionSimple.getName());
        }
        return input;
    }

    @NotNull
    public static UIInput createInputForSimpleProperty(PropertySimple propertySimple, ValueExpression valueExpression, boolean readOnly) {
        UIInput input = PropertyRenderingUtility.createInputForStringProperty();
        input.setValueExpression("value", valueExpression);
        FacesComponentUtility.setReadonly(input, readOnly);
        PropertyRenderingUtility.addTitleAttribute(input, propertySimple.getStringValue());
        return input;
    }

    public static void addMessageComponentForInput(UIComponent parent, UIInput input) {
        FacesComponentUtility.addMessage(parent, null, input.getId(), ERROR_MSG_STYLE_CLASS);
    }

    public static HtmlSelectBooleanCheckbox addUnsetControl(UIComponent parent, PropertyDefinitionSimple propertyDefinitionSimple, PropertySimple propertySimple, Integer listIndex, UIInput valueInput, boolean configIsAggregate, boolean configReadOnly, boolean configFullyEditable) {
        HtmlSelectBooleanCheckbox unsetCheckbox = FacesComponentUtility.createComponent(HtmlSelectBooleanCheckbox.class, null);
        if (propertySimple != null) {
            String unsetCheckboxId = PropertyIdGeneratorUtility.getIdentifier((Property)propertySimple, listIndex, "Unset");
            unsetCheckbox.setId(unsetCheckboxId);
        }
        parent.getChildren().add(unsetCheckbox);
        unsetCheckbox.setValue((Object)PropertyRenderingUtility.isUnset(propertyDefinitionSimple, propertySimple, configIsAggregate));
        if (PropertyRenderingUtility.isReadOnly(propertyDefinitionSimple, propertySimple, configReadOnly, configFullyEditable) || PropertyRenderingUtility.isAggregateWithDifferingValues(propertySimple, configIsAggregate)) {
            FacesComponentUtility.setDisabled((UIComponent)unsetCheckbox, true);
        } else {
            StringBuilder onclick = new StringBuilder();
            for (String htmlDomReference : PropertyRenderingUtility.getHtmlDomReferences((UIComponent)valueInput)) {
                onclick.append("setInputUnset(").append(htmlDomReference).append(", this.checked);");
            }
            unsetCheckbox.setOnclick(onclick.toString());
        }
        return unsetCheckbox;
    }

    public static void addInitInputsJavaScript(UIComponent parent, String componentId, boolean configFullyEditable, boolean postBack) {
        List<UIInput> inputs = FacesComponentUtility.getDescendantsOfType(parent, UIInput.class);
        ArrayList overrideInputs = new ArrayList();
        ArrayList<UIInput> unsetInputs = new ArrayList<UIInput>();
        ArrayList<UIInput> readOnlyInputs = new ArrayList<UIInput>();
        for (UIInput input : inputs) {
            if (postBack) {
                boolean inputIsNull = " ".equals(input.getSubmittedValue());
                FacesComponentUtility.setUnset(input, inputIsNull);
            }
            if (FacesComponentUtility.isUnset((UIComponent)input)) {
                unsetInputs.add(input);
            }
            if (configFullyEditable || !FacesComponentUtility.isReadonly((UIComponent)input)) continue;
            readOnlyInputs.add(input);
        }
        StringBuilder script = new StringBuilder();
        if (!overrideInputs.isEmpty()) {
            script.append("var overrideInputArray = new Array(");
            for (UIInput input : overrideInputs) {
                for (String htmlDomReference : PropertyRenderingUtility.getHtmlDomReferences((UIComponent)input)) {
                    script.append(htmlDomReference).append(", ");
                }
            }
            script.delete(script.length() - 2, script.length());
            script.append(");\n");
            script.append("setInputsOverride(overrideInputArray, false);\n");
        }
        if (!unsetInputs.isEmpty()) {
            script.append("var unsetInputArray = new Array(");
            for (UIInput input : unsetInputs) {
                for (String htmlDomReference : PropertyRenderingUtility.getHtmlDomReferences((UIComponent)input)) {
                    script.append(htmlDomReference).append(", ");
                }
            }
            script.delete(script.length() - 2, script.length());
            script.append(");\n");
            script.append("unsetInputs(unsetInputArray);\n");
        }
        if (!readOnlyInputs.isEmpty()) {
            script.append("var readOnlyInputArray = new Array(");
            for (UIInput input : readOnlyInputs) {
                for (String htmlDomReference : PropertyRenderingUtility.getHtmlDomReferences((UIComponent)input)) {
                    script.append(htmlDomReference).append(", ");
                }
            }
            script.delete(script.length() - 2, script.length());
            script.append(");\n");
            script.append("writeProtectInputs(readOnlyInputArray);\n");
        }
        UIOutput uiOutput = FacesComponentUtility.addJavaScript(parent, null, null, script);
        uiOutput.setId(componentId);
    }

    public static List<String> getHtmlDomReferences(UIComponent component) {
        ArrayList<String> htmlDomReferences = new ArrayList<String>();
        if (component instanceof HtmlSelectOneRadio) {
            String clientId = component.getClientId(FacesContext.getCurrentInstance());
            int selectItemCount = 0;
            for (UIComponent child : component.getChildren()) {
                if (child instanceof UISelectItem) {
                    String selectItemClientId = clientId + ':' + selectItemCount++;
                    htmlDomReferences.add(PropertyRenderingUtility.getHtmlDomReference(selectItemClientId));
                    continue;
                }
                throw new IllegalStateException("HtmlSelectOneRadio component has a child that is not a UISelectItem.");
            }
        } else {
            String clientId = component.getClientId(FacesContext.getCurrentInstance());
            htmlDomReferences.add(PropertyRenderingUtility.getHtmlDomReference(clientId));
        }
        return htmlDomReferences;
    }

    public static void addPropertyDisplayName(UIComponent parent, PropertyDefinition propertyDefinition, Property property, boolean configReadOnly) {
        String displayName = propertyDefinition != null ? propertyDefinition.getDisplayName() : property.getName();
        FacesComponentUtility.addOutputText(parent, null, displayName, "property-display-name-text");
        if (!configReadOnly && propertyDefinition != null && propertyDefinition.isRequired() && propertyDefinition instanceof PropertyDefinitionSimple) {
            FacesComponentUtility.addOutputText(parent, null, " * ", "required-marker-text");
        }
    }

    public static void addPropertyDescription(UIComponent parent, PropertyDefinition propertyDefinition) {
        if (propertyDefinition.getDescription() == null || propertyDefinition.getDescription().trim().equals("")) {
            FacesComponentUtility.addOutputText(parent, null, "<No Description Available>", "description");
        } else {
            FacesComponentUtility.addOutputText(parent, null, propertyDefinition.getDescription(), "description");
        }
    }

    static String getHtmlDomReference(String clientId) {
        return "document.getElementById('" + clientId + "')";
    }

    private static UIInput createInputForBooleanProperty() {
        HtmlSelectOneRadio selectOneRadio = FacesComponentUtility.createComponent(HtmlSelectOneRadio.class, null);
        selectOneRadio.setLayout("lineDirection");
        UISelectItem selectItem = FacesComponentUtility.createComponent(UISelectItem.class, null);
        selectItem.setItemLabel("Yes");
        selectItem.setItemValue((Object)"true");
        selectOneRadio.getChildren().add(selectItem);
        selectItem = FacesComponentUtility.createComponent(UISelectItem.class, null);
        selectItem.setItemLabel("No");
        selectItem.setItemValue((Object)"false");
        selectOneRadio.getChildren().add(selectItem);
        return selectOneRadio;
    }

    private static UIInput createInputForEnumProperty(PropertyDefinitionSimple propertyDefinitionSimple) {
        HtmlSelectOneMenu selectOne;
        if (propertyDefinitionSimple.getEnumeratedValues().size() >= 6) {
            HtmlSelectOneMenu menu;
            selectOne = menu = FacesComponentUtility.createComponent(HtmlSelectOneMenu.class, null);
        } else {
            HtmlSelectOneRadio radio = FacesComponentUtility.createComponent(HtmlSelectOneRadio.class, null);
            radio.setLayout("pageDirection");
            selectOne = radio;
        }
        List options = propertyDefinitionSimple.getEnumeratedValues();
        for (PropertyDefinitionEnumeration option : options) {
            UISelectItem selectItem = FacesComponentUtility.createComponent(UISelectItem.class, null);
            selectItem.setItemLabel(option.getName());
            selectItem.setItemValue((Object)option.getValue());
            selectOne.getChildren().add(selectItem);
        }
        return selectOne;
    }

    private static UIInput createInputForStringProperty() {
        HtmlInputText inputText = FacesComponentUtility.createComponent(HtmlInputText.class, null);
        inputText.setStyleClass("property-value-input");
        inputText.setMaxlength(2000);
        inputText.setAutocomplete("off");
        return inputText;
    }

    private static UIInput createInputForPasswordProperty() {
        HtmlInputSecret inputSecret = FacesComponentUtility.createComponent(HtmlInputSecret.class, null);
        inputSecret.setStyleClass("property-value-input");
        inputSecret.setMaxlength(2000);
        inputSecret.setRedisplay(true);
        inputSecret.setAutocomplete("off");
        return inputSecret;
    }

    private static UIInput createInputForLongStringProperty() {
        HtmlInputTextarea inputTextarea = FacesComponentUtility.createComponent(HtmlInputTextarea.class, null);
        inputTextarea.setRows(4);
        inputTextarea.setStyleClass("property-value-input");
        return inputTextarea;
    }

    private static boolean isEnum(PropertyDefinitionSimple simplePropertyDefinition) {
        return !simplePropertyDefinition.getEnumeratedValues().isEmpty();
    }

    private static void addValidatorsAndConverter(UIInput input, PropertyDefinitionSimple propertyDefinitionSimple, boolean readOnly) {
        if (!readOnly) {
            input.setRequired(propertyDefinitionSimple.isRequired());
            input.addValidator((Validator)new PropertySimpleValueValidator(propertyDefinitionSimple));
            input.setConverter((Converter)new PropertySimpleValueConverter());
        }
    }

    private static void addErrorMessages(UIInput input, @Nullable PropertyDefinitionSimple propertyDefinitionSimple, PropertySimple propertySimple, boolean prevalidate) {
        if (prevalidate) {
            PropertySimpleValueValidator validator = new PropertySimpleValueValidator(propertyDefinitionSimple);
            PropertyRenderingUtility.prevalidatePropertyValue(input, propertySimple, validator);
        }
        PropertyRenderingUtility.addPluginContainerDetectedErrorMessage(input, propertySimple);
    }

    private static void prevalidatePropertyValue(UIInput propertyValueInput, PropertySimple propertySimple, PropertySimpleValueValidator validator) {
        FacesContext facesContext = FacesContextUtility.getFacesContext();
        try {
            String value = propertySimple != null ? propertySimple.getStringValue() : null;
            validator.validate(facesContext, (UIComponent)propertyValueInput, value);
        }
        catch (ValidatorException e) {
            facesContext.addMessage(propertyValueInput.getClientId(facesContext), e.getFacesMessage());
        }
    }

    private static void addPluginContainerDetectedErrorMessage(UIInput input, PropertySimple propertySimple) {
        String errorMsg;
        String string = errorMsg = propertySimple != null ? propertySimple.getErrorMessage() : null;
        if (errorMsg != null && !errorMsg.equals("")) {
            FacesContext facesContext = FacesContextUtility.getFacesContext();
            FacesMessage facesMsg = new FacesMessage(FacesMessage.SEVERITY_ERROR, errorMsg, null);
            facesContext.addMessage(input.getClientId(facesContext), facesMsg);
        }
    }

    private static void addTitleAttribute(UIInput input, String propertyValue) {
        if (input instanceof HtmlInputText) {
            HtmlInputText inputText = (HtmlInputText)input;
            if (propertyValue != null && propertyValue.length() > 30) {
                inputText.setTitle(propertyValue);
            }
            inputText.setOnchange("setInputTitle(this)");
        }
    }

    private static boolean isUnset(PropertyDefinitionSimple propertyDefinitionSimple, PropertySimple propertySimple, boolean configIsAggregate) {
        if (PropertyRenderingUtility.isAggregateWithDifferingValues(propertySimple, configIsAggregate)) {
            return false;
        }
        if (propertySimple == null) {
            return false;
        }
        return (propertyDefinitionSimple == null || !propertyDefinitionSimple.isRequired()) && propertySimple.getStringValue() == null;
    }

    public static boolean isReadOnly(PropertyDefinitionSimple propertyDefinitionSimple, PropertySimple propertySimple, boolean configReadOnly, boolean configFullyEditable) {
        return !configFullyEditable && (configReadOnly || propertyDefinitionSimple != null && propertyDefinitionSimple.isReadOnly() && (propertySimple == null || !PropertyRenderingUtility.isInvalidRequiredProperty(propertyDefinitionSimple, propertySimple)));
    }

    public static boolean isAggregateWithDifferingValues(PropertySimple propertySimple, boolean configIsAggregate) {
        return configIsAggregate && (propertySimple.getOverride() == null || propertySimple.getOverride() == false);
    }

    private static boolean isInvalidRequiredProperty(PropertyDefinitionSimple propertyDefinitionSimple, PropertySimple propertySimple) {
        boolean isInvalidRequiredProperty = false;
        if (propertyDefinitionSimple.isRequired()) {
            String errorMessage = propertySimple.getErrorMessage();
            if (null == propertySimple.getStringValue() || "".equals(propertySimple.getStringValue()) || null != errorMessage && !"".equals(errorMessage.trim())) {
                isInvalidRequiredProperty = true;
            }
        }
        return isInvalidRequiredProperty;
    }
}

