/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIServer;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;

public abstract class RMIServerImpl
implements RMIServer {
    private MBeanServer mbeanServer = null;
    private Map environment = null;
    private ClassLoader defaultClassLoader = null;
    private RMIConnectorServer connectorServer = null;
    private Map clientConnections = new HashMap();
    private static int connectionIdNumber = 0;
    private boolean isRunning = true;
    protected static Logger log = Logger.getLogger((String)RMIServerImpl.class.getName());

    public RMIServerImpl(Map env) {
        this.environment = env;
    }

    protected abstract void export() throws IOException;

    public abstract Remote toStub() throws IOException;

    protected void setRMIConnectorServer(RMIConnectorServer connectorServer) {
        this.connectorServer = connectorServer;
    }

    public void setDefaultClassLoader(ClassLoader cl) {
        this.defaultClassLoader = cl;
    }

    public ClassLoader getDefaultClassLoader() {
        return this.defaultClassLoader;
    }

    public void setMBeanServer(MBeanServer mbs) {
        this.mbeanServer = mbs;
    }

    public MBeanServer getMBeanServer() {
        return this.mbeanServer;
    }

    public String getVersion() throws RemoteException {
        return "1.0 JBoss_JMX_Remoting_1_0_1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RMIConnection newClient(Object credentials) throws IOException, SecurityException {
        if (!this.isRunning) {
            throw new IOException("RMIServer has been closed.");
        }
        RMIConnection client = null;
        try {
            Subject subject = this.authenticateCaller(this.environment, credentials);
            String connectionId = this.gernerateConnectionId(subject);
            client = this.makeClient(connectionId, subject);
            WeakReference<RMIConnection> clientRef = new WeakReference<RMIConnection>(client);
            Map map = this.clientConnections;
            synchronized (map) {
                this.clientConnections.put(connectionId, clientRef);
            }
            this.connectorServer.connectionOpened(connectionId, "Connection opened for client: " + client, null);
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            log.error((Object)"Error creating new client (RMIConnection).", (Throwable)e);
            throw new IOException("Error creating new RMIConnection.  " + e.getMessage());
        }
        return client;
    }

    private Subject authenticateCaller(Map environment, Object credentials) {
        JMXAuthenticator authenticator = (JMXAuthenticator)environment.get("jmx.remote.authenticator");
        Subject subject = null;
        if (authenticator != null) {
            subject = authenticator.authenticate(credentials);
        }
        return subject;
    }

    private String gernerateConnectionId(Subject subject) {
        String protocol = this.getProtocol();
        StringBuffer connectionId = new StringBuffer(protocol + ":");
        try {
            String clientHost = RemoteServer.getClientHost();
            if (clientHost != null && clientHost.length() > 0) {
                if (clientHost.indexOf(58) != -1) {
                    connectionId.append("//[" + clientHost + "]");
                } else {
                    connectionId.append("//" + clientHost);
                }
            }
        }
        catch (ServerNotActiveException e) {
            log.warn((Object)("Can not get client host for connection id.  " + e.getMessage()));
        }
        connectionId.append(" ");
        if (subject != null) {
            String firstName;
            Set<Principal> principals = subject.getPrincipals();
            Iterator<Principal> itr = principals.iterator();
            String string = firstName = itr.hasNext() ? itr.next().getName().replace(' ', '_').replace(';', ':').trim() : null;
            if (firstName != null) {
                connectionId.append(firstName);
            }
            while (itr.hasNext()) {
                connectionId.append(";");
                Principal principal = itr.next();
                String name = principal.getName().replace(' ', '_').replace(';', ':').trim();
                connectionId.append(name);
            }
            connectionId.append(" ");
        }
        connectionId.append(RMIServerImpl.getNextConnectionIdNumber());
        return connectionId.toString();
    }

    private static synchronized int getNextConnectionIdNumber() {
        return connectionIdNumber++;
    }

    protected abstract RMIConnection makeClient(String var1, Subject var2) throws IOException;

    protected abstract void closeClient(RMIConnection var1) throws IOException;

    protected abstract String getProtocol();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clientClosed(RMIConnection client) throws IOException {
        if (client != null) {
            String connectionID = client.getConnectionId();
            RMIConnection rmiConnection = null;
            Map map = this.clientConnections;
            synchronized (map) {
                WeakReference clientRef = (WeakReference)this.clientConnections.remove(connectionID);
                if (clientRef != null) {
                    rmiConnection = (RMIConnection)clientRef.get();
                }
            }
            this.closeClient(client);
            this.connectorServer.connectionClosed(client.getConnectionId(), "Connection closed for client: " + client, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        this.isRunning = false;
        try {
            this.closeServer();
        }
        finally {
            this.closeClientConnections();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeClientConnections() {
        Map map = this.clientConnections;
        synchronized (map) {
            Set clients = this.clientConnections.entrySet();
            for (WeakReference weakReference : clients) {
                RMIConnection rmiConnection;
                if (weakReference == null || (rmiConnection = (RMIConnection)weakReference.get()) == null) continue;
                try {
                    rmiConnection.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected abstract void closeServer() throws IOException;
}

