/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.remoting.tracker;

import java.io.Serializable;
import java.util.ArrayList;
import javax.management.AttributeChangeNotification;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.ObjectName;

public class MBeanTrackerFilter
implements NotificationFilter,
Serializable {
    static final long serialVersionUID = -4239778153506655691L;
    protected final String[] classNames;
    protected final String serverId;
    protected final boolean wantNotifications;

    public MBeanTrackerFilter(String serverId, String[] cn, boolean wantNotifications) {
        this.serverId = serverId;
        this.classNames = cn;
        this.wantNotifications = wantNotifications;
    }

    public boolean isNotificationEnabled(Notification notification) {
        Object src;
        AttributeChangeNotification ch;
        int c;
        MBeanServer server;
        ArrayList<MBeanServer> list;
        if (notification instanceof MBeanServerNotification) {
            MBeanServerNotification n = (MBeanServerNotification)notification;
            ObjectName mbean = n.getMBeanName();
            list = MBeanServerFactory.findMBeanServer(this.serverId);
            if (!list.isEmpty()) {
                server = (MBeanServer)list.get(0);
                if (notification.getType().equals("JMX.mbean.registered")) {
                    if (this.classNames == null) {
                        return true;
                    }
                    for (c = 0; c < this.classNames.length; ++c) {
                        try {
                            if (!server.isInstanceOf(mbean, this.classNames[c])) continue;
                            return true;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                } else if (notification.getType().equals("JMX.mbean.unregistered")) {
                    return false == (mbean.getDomain().equals("mx.remoting") || mbean.getDomain().equals("JMImplementation"));
                }
            }
        } else if (notification instanceof AttributeChangeNotification && (ch = (AttributeChangeNotification)notification).getAttributeName().equals("State") && (ch.getAttributeType().equals(Integer.TYPE.getName()) || ch.getAttributeType().equals(Integer.class.getName()))) {
            return true;
        }
        if (this.wantNotifications && (src = notification.getSource()) instanceof ObjectName) {
            ObjectName obj = (ObjectName)src;
            list = MBeanServerFactory.findMBeanServer(this.serverId);
            if (!list.isEmpty()) {
                server = (MBeanServer)list.get(0);
                if (this.classNames == null) {
                    return true;
                }
                for (c = 0; c < this.classNames.length; ++c) {
                    try {
                        if (server.isInstanceOf(obj, this.classNames[c])) {
                            return true;
                        }
                        continue;
                    }
                    catch (InstanceNotFoundException inf) {
                        return false;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        }
        return false;
    }
}

