/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ParsedIOR;
import org.jacorb.orb.giop.ClientConnectionManager;
import org.jacorb.orb.giop.ClientGIOPConnection;
import org.jacorb.orb.giop.CodeSet;
import org.jacorb.orb.giop.ConnectionListener;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.LocateReplyInputStream;
import org.jacorb.orb.giop.MessageInputStream;
import org.jacorb.orb.giop.MessageOutputStream;
import org.jacorb.orb.giop.Messages;
import org.jacorb.orb.giop.ReplyInputStream;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.ReplyPlaceholder;
import org.jacorb.util.ObjectUtil;
import org.omg.CONV_FRAME.CodeSetComponent;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.SystemException;
import org.omg.ETF.Profile;

public class ClientConnection
implements ReplyListener,
ConnectionListener {
    private final GIOPConnection connection;
    private final org.omg.CORBA.ORB orb;
    private final Map replies;
    private final Map sasContexts;
    private static long last_client_context_id = 0L;
    private int client_count = 0;
    private int id_count = 0;
    private final ClientConnectionManager conn_mg;
    private final boolean client_initiated;
    private final String info;
    private boolean gracefulStreamClose;
    private final Profile registeredProfile;
    private final Logger logger;
    private final boolean ignoreComponentInfo;

    public ClientConnection(GIOPConnection gIOPConnection, org.omg.CORBA.ORB oRB, ClientConnectionManager clientConnectionManager, Profile profile, boolean bl) {
        this.connection = gIOPConnection;
        this.orb = oRB;
        this.conn_mg = clientConnectionManager;
        this.registeredProfile = profile;
        this.info = profile.toString();
        this.client_initiated = bl;
        Configuration configuration = ((ORB)oRB).getConfiguration();
        this.logger = configuration.getNamedLogger("jacorb.giop.conn");
        boolean bl2 = this.ignoreComponentInfo = !configuration.getAttributeAsBoolean("jacorb.codeset", true);
        if (!bl) {
            this.id_count = 1;
        }
        gIOPConnection.setReplyListener(this);
        gIOPConnection.setConnectionListener(this);
        this.replies = new HashMap();
        this.sasContexts = new HashMap();
    }

    public final GIOPConnection getGIOPConnection() {
        return this.connection;
    }

    public Profile getRegisteredProfile() {
        return this.registeredProfile;
    }

    public void setCodeSet(ParsedIOR parsedIOR) {
        if (this.isTCSNegotiated()) {
            return;
        }
        if (parsedIOR.getEffectiveProfile().version().minor == 0) {
            this.connection.markTCSNegotiated();
            return;
        }
        int n = -1;
        int n2 = -1;
        CodeSetComponentInfo codeSetComponentInfo = parsedIOR.getCodeSetComponentInfo();
        if (codeSetComponentInfo == null || this.ignoreComponentInfo) {
            this.logger.debug("No CodeSetComponentInfo in IOR. Will use default CodeSets");
            this.connection.markTCSNegotiated();
            return;
        }
        n = CodeSet.selectTCS(codeSetComponentInfo);
        n2 = CodeSet.selectTCSW(codeSetComponentInfo);
        if (n == -1 || n2 == -1) {
            if (this.logger.isDebugEnabled()) {
                CodeSetComponent codeSetComponent = codeSetComponentInfo.ForCharData;
                this.logger.debug("Attempted to negotiate with target codeset " + CodeSet.csName(codeSetComponent.native_code_set) + " to match with " + CodeSet.csName(CodeSet.getTCSDefault()));
                this.logger.debug("Target has " + (codeSetComponent.conversion_code_sets == null ? 0 : codeSetComponent.conversion_code_sets.length) + " conversion codesets and native has " + CodeSet.csName(CodeSet.getConversionDefault()));
                this.logger.debug("Was negotiating with IOR " + parsedIOR.getIORString());
            }
            throw new CODESET_INCOMPATIBLE("WARNING: CodeSet negotiation failed! No matching " + (n == -1 ? "normal" : "wide") + " CodeSet found");
        }
        this.connection.setCodeSets(n, n2);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Successfully negotiated Codesets. Using " + CodeSet.csName(n) + " as TCS and " + CodeSet.csName(n2) + " as TCSW");
        }
    }

    public boolean isTCSNegotiated() {
        return this.connection.isTCSNegotiated();
    }

    public int getTCS() {
        return this.connection.getTCS();
    }

    public int getTCSW() {
        return this.connection.getTCSW();
    }

    public synchronized int getId() {
        int n = this.id_count;
        this.id_count += 2;
        return n;
    }

    public synchronized void incClients() {
        ++this.client_count;
    }

    public synchronized boolean decClients() {
        boolean bl = false;
        --this.client_count;
        if (this.client_count == 0) {
            bl = true;
        }
        return bl;
    }

    public int numClients() {
        return this.client_count;
    }

    public boolean isClientInitiated() {
        return this.client_initiated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRequest(MessageOutputStream messageOutputStream, ReplyPlaceholder replyPlaceholder, int n, boolean bl) {
        Integer n2 = ObjectUtil.newInteger(n);
        Map map = this.replies;
        synchronized (map) {
            this.replies.put(n2, replyPlaceholder);
        }
        try {
            this.sendRequest(messageOutputStream, bl);
        }
        catch (SystemException systemException) {
            Map map2 = this.replies;
            synchronized (map2) {
                this.replies.remove(n2);
            }
            throw systemException;
        }
    }

    public void sendRequest(MessageOutputStream messageOutputStream, boolean bl) {
        try {
            this.connection.sendRequest(messageOutputStream, bl);
        }
        catch (IOException iOException) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("IOException", (Throwable)iOException);
            }
            throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_MAYBE);
        }
    }

    public void close() {
        this.connection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        gIOPConnection.decPendingMessages();
        Integer n = ObjectUtil.newInteger(Messages.getRequestId(byArray));
        ReplyPlaceholder replyPlaceholder = null;
        Object object = this.replies;
        synchronized (object) {
            replyPlaceholder = (ReplyPlaceholder)this.replies.remove(n);
        }
        if (replyPlaceholder != null) {
            object = new ReplyInputStream(this.orb, byArray);
            ((CDRInputStream)object).setCodeSet(this.getTCS(), this.getTCSW());
            replyPlaceholder.replyReceived((MessageInputStream)object);
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("Received reply for unknown request id: " + n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void locateReplyReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        gIOPConnection.decPendingMessages();
        Integer n = ObjectUtil.newInteger(Messages.getRequestId(byArray));
        ReplyPlaceholder replyPlaceholder = null;
        Map map = this.replies;
        synchronized (map) {
            replyPlaceholder = (ReplyPlaceholder)this.replies.remove(n);
        }
        if (replyPlaceholder != null) {
            replyPlaceholder.replyReceived(new LocateReplyInputStream(this.orb, byArray));
        } else if (this.logger.isWarnEnabled()) {
            this.logger.warn("Received reply for unknown request id: " + n);
        }
    }

    public void closeConnectionReceived(byte[] byArray, GIOPConnection gIOPConnection) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Received CloseConnection on " + gIOPConnection.toString());
        }
        if (this.client_initiated) {
            this.gracefulStreamClose = true;
            ((ClientGIOPConnection)gIOPConnection).closeAllowReopen();
            this.streamClosed();
        }
    }

    public void connectionClosed() {
        if (!this.client_initiated) {
            this.conn_mg.removeConnection(this);
        }
        this.streamClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamClosed() {
        Map map = this.replies;
        synchronized (map) {
            if (this.replies.size() > 0) {
                if (this.gracefulStreamClose) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Stream closed. Will remarshal " + this.replies.size() + " messages");
                    }
                } else if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Abnormal connection termination. Lost " + this.replies.size() + " outstanding replie(s)!");
                }
                Iterator iterator = this.replies.values().iterator();
                while (iterator.hasNext()) {
                    ReplyPlaceholder replyPlaceholder = (ReplyPlaceholder)iterator.next();
                    if (this.gracefulStreamClose) {
                        replyPlaceholder.retry();
                    } else {
                        replyPlaceholder.cancel();
                    }
                    iterator.remove();
                }
            }
        }
        this.gracefulStreamClose = false;
    }

    public Profile get_server_profile() {
        return this.connection.getTransport().get_server_profile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long cacheSASContext(byte[] byArray) {
        long l = 0L;
        String string = new String(byArray);
        Map map = this.sasContexts;
        synchronized (map) {
            if (!this.sasContexts.containsKey(string)) {
                l = ++last_client_context_id;
                this.sasContexts.put(string, new Long(l));
                l = -l;
            } else {
                l = (Long)this.sasContexts.get(string);
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long purgeSASContext(long l) {
        Map map = this.sasContexts;
        synchronized (map) {
            Iterator iterator = this.sasContexts.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if ((Long)this.sasContexts.get(k) != l) continue;
                iterator.remove();
                break;
            }
        }
        return l;
    }
}

