/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.system;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import org.hyperic.sigar.NetStat;

public class NetworkStats {
    protected int[] tcpStates;
    protected int tcpInboundTotal;
    protected int tcpOutboundTotal;
    protected int allInboundTotal;
    protected int allOutboundTotal;

    public NetworkStats(NetStat interfaceStat) {
        this.refresh(interfaceStat);
    }

    public void refresh(NetStat interfaceStat) {
        this.tcpStates = interfaceStat.getTcpStates();
        this.tcpInboundTotal = interfaceStat.getTcpInboundTotal();
        this.tcpOutboundTotal = interfaceStat.getTcpOutboundTotal();
        this.allInboundTotal = interfaceStat.getAllInboundTotal();
        this.allOutboundTotal = interfaceStat.getAllOutboundTotal();
    }

    public int getByName(String propertyName) {
        try {
            PropertyDescriptor[] descriptors;
            BeanInfo info = Introspector.getBeanInfo(NetworkStats.class);
            for (PropertyDescriptor descriptor : descriptors = info.getPropertyDescriptors()) {
                if (!descriptor.getName().equals(propertyName)) continue;
                Integer value = (Integer)descriptor.getReadMethod().invoke((Object)this, new Object[0]);
                return value;
            }
            throw new RuntimeException("Couldn't find property " + propertyName + " on NetworkStats");
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't read property " + propertyName + " from NetworkStats", e);
        }
    }

    public int getTcpInboundTotal() {
        return this.tcpInboundTotal;
    }

    public int getTcpOutboundTotal() {
        return this.tcpOutboundTotal;
    }

    public int getAllInboundTotal() {
        return this.allInboundTotal;
    }

    public int getAllOutboundTotal() {
        return this.allOutboundTotal;
    }

    public int[] getTcpStates() {
        return this.tcpStates;
    }

    public int getTcpEstablished() {
        return this.tcpStates[1];
    }

    public int getTcpSynSent() {
        return this.tcpStates[2];
    }

    public int getTcpSynRecv() {
        return this.tcpStates[3];
    }

    public int getTcpFinWait1() {
        return this.tcpStates[4];
    }

    public int getTcpFinWait2() {
        return this.tcpStates[5];
    }

    public int getTcpTimeWait() {
        return this.tcpStates[6];
    }

    public int getTcpClose() {
        return this.tcpStates[7];
    }

    public int getTcpCloseWait() {
        return this.tcpStates[8];
    }

    public int getTcpLastAck() {
        return this.tcpStates[9];
    }

    public int getTcpListen() {
        return this.tcpStates[10];
    }

    public int getTcpClosing() {
        return this.tcpStates[11];
    }

    public int getTcpIdle() {
        return this.tcpStates[12];
    }

    public int getTcpBound() {
        return this.tcpStates[13];
    }
}

