/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.richfaces.model.TreeRowKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListRowKey<T>
extends TreeRowKey<T> {
    private ArrayList<T> path;
    private static final long serialVersionUID = 7718335783201397177L;
    private static final String SEPARATOR = "(?<!_)\\:";

    @Override
    public String toString() {
        return this.getPath();
    }

    public ListRowKey() {
        this.path = new ArrayList();
    }

    public ListRowKey(ListRowKey<T> parentRowKey) {
        this.path = parentRowKey != null ? (ArrayList)parentRowKey.path.clone() : new ArrayList();
    }

    public ListRowKey(ListRowKey<T> parentRowKey, T pathElement) {
        this(parentRowKey);
        this.path.add(pathElement);
    }

    public ListRowKey(ListRowKey<T> parentRowKey, ListRowKey<T> childRowKey) {
        this(parentRowKey);
        this.path.addAll(childRowKey.path);
    }

    protected ListRowKey(ArrayList<T> list) {
        this.path = list;
    }

    public ListRowKey(List<T> list) {
        this.path = new ArrayList<T>(list);
    }

    public ListRowKey(T path) {
        this.path = new ArrayList(1);
        this.path.add(path);
    }

    @Override
    public int depth() {
        return this.path.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this.path.iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ListRowKey other = (ListRowKey)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    @Override
    public Iterator<T> getSubPathIterator(int fromIndex) {
        return this.path.listIterator(fromIndex);
    }

    @Override
    public TreeRowKey<T> getSubKey(int fromIndex) {
        return new ListRowKey<List<T>>(this.path.subList(fromIndex, this.path.size()));
    }

    @Override
    public boolean isSubKey(TreeRowKey<T> rowKey) {
        if (rowKey instanceof ListRowKey) {
            ListRowKey listRowKey = (ListRowKey)rowKey;
            return this.depth() == this.getCommonPathLength(listRowKey);
        }
        return super.isSubKey(rowKey);
    }

    private void appendSegment(StringBuilder builder, String segment) {
        StringBuilder escapedSubPath = new StringBuilder();
        for (int i = 0; i < segment.length(); ++i) {
            char ch = segment.charAt(i);
            if (':' == ch || '_' == ch) {
                escapedSubPath.append('_');
            }
            escapedSubPath.append(ch);
        }
        builder.append(escapedSubPath.toString());
    }

    @Override
    public String getPath() {
        StringBuilder result = new StringBuilder();
        Iterator<T> iterator = this.path.iterator();
        boolean hasNext = iterator.hasNext();
        while (hasNext) {
            T segment = iterator.next();
            if (segment instanceof CompositeKey) {
                CompositeKey compositeKey = (CompositeKey)segment;
                Iterator keySegments = compositeKey.getKeySegments();
                while (keySegments.hasNext()) {
                    this.appendSegment(result, keySegments.next().toString());
                    if (!keySegments.hasNext()) continue;
                    result.append(':');
                }
            } else {
                this.appendSegment(result, segment.toString());
            }
            if (!(hasNext = iterator.hasNext())) continue;
            result.append(':');
        }
        return result.toString();
    }

    @Override
    public int getCommonPathLength(TreeRowKey<T> otherRowKey) {
        if (otherRowKey == null) {
            return 0;
        }
        Iterator<T> iterator = this.iterator();
        Iterator<T> otherIterator = otherRowKey.iterator();
        int length = 0;
        while (iterator.hasNext() && otherIterator.hasNext() && iterator.next().equals(otherIterator.next())) {
            ++length;
        }
        return length;
    }

    public T get(int i) {
        return this.path.get(i);
    }

    public static String[] fromString(String keyString) {
        String[] split = keyString.split(SEPARATOR);
        for (int i = 0; i < split.length; ++i) {
            split[i] = split[i].replaceAll("_(:|_)", "$1");
        }
        return split;
    }

    public static void main(String[] args) {
        System.out.println(Arrays.toString(ListRowKey.fromString("test_:abc:123:a__b")));
    }

    @Override
    public TreeRowKey<T> getParentKey() {
        int toIdx = this.path.size() - 1;
        ListRowKey<ArrayList<T>> result = null;
        if (toIdx >= 0) {
            result = new ListRowKey<ArrayList<T>>(new ArrayList<T>(this.path.subList(0, toIdx)));
        }
        return result;
    }

    public static interface CompositeKey {
        public Iterator getKeySegments();
    }
}

