/*
 * Decompiled with CFR 0.152.
 */
package mazz.i18n.ant;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mazz.i18n.Msg;
import mazz.i18n.annotation.I18NMessage;
import mazz.i18n.annotation.I18NMessages;
import mazz.i18n.annotation.I18NResourceBundle;
import mazz.i18n.ant.Helpdoc;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@I18NResourceBundle(baseName="i18n-anttask-messages", defaultLocale="en")
public class I18NAntTask
extends Task {
    static final Msg.BundleBaseName BUNDLE_BASE_NAME = new Msg.BundleBaseName("i18n-anttask-messages");
    @I18NMessage(value="Processing I18N messages")
    static final String I18N_START_PROCESSING = "I18NAntTask.start-processing";
    @I18NMessage(value="Processing I18N class file [{0}]")
    static final String I18N_PROCESSING_CLASS = "I18NAntTask.processing-class";
    @I18NMessage(value="Loaded I18N class from classloader: [{0}]")
    static final String I18N_LOADED_CLASS = "I18NAntTask.loaded-class";
    @I18NMessage(value="The class [{0}] does not appear to be annotated for I18N and was not processed")
    static final String I18N_CLASS_IGNORED = "I18NAntTask.class-ignored";
    @I18NMessage(value="Cannot find class file [{0}] on the I18N task''s classpath. Cause: {1}")
    static final String I18N_CANNOT_FIND_CLASS = "I18NAntTask.cannot-find-class";
    @I18NMessage(value="An error occurred when attempting to put the template footer in the help documents. Cause: {0}")
    static final String I18N_CANNOT_APPEND_HELPDOC_TEMPLATE_FOOTER = "I18NAntTask.cannot-append-helpdoc-footer";
    @I18NMessage(value="The following I18N resource bundles were placed in {0}")
    static final String I18N_BUNDLES_PLACED_IN_DIR = "I18NAntTask.bundles-placed-in";
    @I18NMessage(value="-> {0}: {1} messages")
    static final String I18N_BUNDLE_MESSAGE_COUNTER = "I18NAntTask.bundle-message-counter";
    @I18NMessage(value="The following help documents were placed in {0}")
    static final String HELPDOCS_PLACED_IN_DIR = "I18NAntTask.helpdocs-placed-in";
    @I18NMessage(value="-> {0}{1}: {2} help doc items")
    static final String HELPDOCS_MESSAGE_COUNTER = "I18NAntTask.helpdocs-message-counter";
    @I18NMessage(value="[{0}] I18N resource bundles have been created with a total of [{1}] messages")
    static final String I18N_NUM_BUNDLES_MESSAGES_CREATED = "I18NAntTask.num-bundles-messages-created";
    @I18NMessage(value="[{0}] help documents have been created with a total of [{1}] items")
    static final String NUM_HELPDOCS_ITEMS_CREATED = "I18NAntTask.num-helpdocs-items-created";
    @I18NMessage(value="Did not find any I18N messages so no I18N resource bundles were created")
    static final String I18N_NO_BUNDLES_CREATED = "I18NAntTask.no-bundles-created";
    @I18NMessage(value="[{0}] is annotated with resource bundle definition [{1}]")
    static final String I18N_CLASS_ANNOTATED_WITH_BUNDLE = "I18NAntTask.class-annotated-with-bundle";
    @I18NMessage(value="[{0}] does not define a resource bundle definition; will default to [{1}]")
    static final String I18N_CLASS_NOT_ANNOTATED_WITH_BUNDLE = "I18NAntTask.class-not-annotated-with-bundle";
    @I18NMessage(value="Field [{0}.{1}] is annotated with its own resource bundle definition [{2}]")
    static final String I18N_FIELD_ANNOTATED_WITH_BUNDLE = "I18NAntTask.field-annotated-with-bundle";
    @I18NMessage(value="Field [{0}.{1}] has [{2}] I18N messages")
    static final String I18N_FIELD_MESSAGE_COUNT = "I18NAntTask.field-message-count";
    @I18NMessage(value="Field [{0}.{1}] is not of type String; cannot use I18N annotations on non-String fields.")
    static final String I18N_FIELD_NOT_STRING = "I18NAntTask.field-not-string";
    @I18NMessage(value="Field [{0}.{1}] is not static final; cannot use I18N annotations on non-constant fields.")
    static final String I18N_FIELD_NOT_STATIC_FINAL = "I18NAntTask.field-not-static-final";
    @I18NMessage(value="Resource bundle keys cannot be null or an empty string - must be at least 1 character long")
    static final String I18N_FIELD_VALUE_CANNOT_BE_EMPTY = "I18NAntTask.field-cannot-be-empty";
    @I18NMessage(value="Resource bundle keys cannot contain any ''='' characters [{0}]")
    static final String I18N_NO_EQUALS_ALLOWED = "I18NAntTask.no-equals-allowed";
    @I18NMessage(value="Failed to get the constant value of field [{0}.{1}] - Cause: {2}")
    static final String I18N_FAILED_TO_GET_FIELD_VALUE = "I18NAntTask.failed-to-get-field-value";
    @I18NMessage(value="Failed to write I18N message to resource bundle for field [{0}.{1}] - Cause: {2}")
    static final String I18N_FAILED_TO_WRITE_TO_BUNDLE = "I18NAntTask.failed-to-write-to-bundle";
    @I18NMessage(value="Failed to write help doc item for I18N message for field [{0}.{1}] - Cause: {2}")
    static final String I18N_FAILED_TO_WRITE_HELPDOC_ITEM = "I18NAntTask.failed-to-write-helpdoc-item";
    @I18NMessage(value="VERIFY WARNING: The text for I18N message key [{0}] for field [{1}.{2}] is empty and will be ignored")
    static final String I18N_MESSAGE_TEXT_IS_EMPTY = "I18NAntTask.message-text-is-empty";
    @I18NMessage(value="Writing to bundle file [{0}] the key=message of: {1}")
    static final String I18N_WRITING_MESSAGE_TO_BUNDLE = "I18NAntTask.writing-message-to-bundle";
    @I18NMessage(value="VERIFY WARNING: The I18N message [{0}] found on field [{1}.{2}] has a duplicate key. The message associated with this duplicate key is:\\n\\\n{3}")
    static final String I18N_VERIFY_WARNING_DUPLICATE = "I18NAntTask.warning-duplicate";
    @I18NMessage(value="VERIFY WARNING: The I18N message [{0}] found on field [{1}.{2}] has a text value that contains a newline break at character #[{3}] but is not preceded by an escape backslash (\\\\):\\n\\\n\"...{4}\"\\n\\\nPlease make sure this is the value you really want:\\n\\\n{5}")
    static final String I18N_VERIFY_WARNING_UNESCAPED_NEWLINE = "I18NAntTask.warning-unescaped-newline";
    @I18NMessage(value="VERIFY WARNING: The I18N message [{0}] found on field [{1}.{2}] has a text value that contains a quoted placeholder.  Check your use of single quotes and make sure you are using them the way you want:\\n\\\n{3}")
    static final String I18N_VERIFY_WARNING_QUOTED_PLACEHOLDER = "I18NAntTask.warning-quoted-placeholder";
    @I18NMessage(value="Cannot create output directory [{0}]")
    static final String I18N_CANNOT_CREATE_OUTPUT_DIR = "I18NAntTask.cannot-create-output-dir";
    @I18NMessage(value="Output directory is not a true directory [{0}]")
    static final String I18N_OUTPUT_DIR_NOT_A_DIR = "I18NAntTask.output-dir-not-a-dir";
    @I18NMessage(value="There are no class filesets defined")
    static final String I18N_NO_CLASS_FILESETS = "I18NAntTask.no-class-filesets";
    @I18NMessage(value="There is no classpath defined or the classpath is empty")
    static final String I18N_EMPTY_CLASSPATH = "I18NAntTask.empty-classpath";
    @I18NMessage(value="Verbose mode is ON")
    static final String I18N_VERBOSE_ON = "I18NAntTask.verbose-on";
    @I18NMessage(value="Default locale is [{0}]")
    static final String I18N_DEFAULT_LOCALE = "I18NAntTask.default-locale";
    @I18NMessage(value="Verify mode is {0}")
    static final String I18N_VERIFY_MODE = "I18NAntTask.verify-mode";
    @I18NMessage(value="Append mode is {0}")
    static final String I18N_APPEND_MODE = "I18NAntTask.append-mode";
    @I18NMessage(value="Output directory is: [{0}]")
    static final String I18N_OUTPUT_DIR = "I18NAntTask.output-dir";
    @I18NMessage(value="Classpath: [{0}]")
    static final String I18N_CLASSPATH = "I18NAntTask.classpath";
    @I18NMessage(value="Help Doc: [{0}]")
    static final String I18N_HELPDOC = "I18NAntTask.helpdoc";
    @I18NMessage(value="The <helpdoc> element has already been specified.  Cannot specify it more than once.")
    static final String I18N_HELPDOC_ALREADY_SPECIFIED = "I18NAntTask.helpdoc-already-exists";
    @I18NMessage(value="The <helpdoc> output directory [{0}] exists but is not actually a directory.")
    static final String I18N_HELPDOC_OUTPUT_DIR_NOT_A_DIR = "I18NAntTask.helpdoc-outputdir-not-dir";
    @I18NMessage(value="The <helpdoc> output directory [{0}] cannot be created")
    static final String I18N_HELPDOC_CANNOT_CREATE_OUTPUT_DIR = "I18NAntTask.cannot-create-helpdoc-outputdir";
    @I18NMessage(value="The <helpdoc> output directory is required but was not specified.")
    static final String I18N_HELPDOC_OUTPUT_DIR_IS_NULL = "I18NAntTask.helpdoc-outputdir-missing";
    @I18NMessage(value="The <helpdoc> template item file [{0}] exists but is actually a directory.")
    static final String I18N_HELPDOC_TEMPLATE_ITEM_FILE_NOT_A_FILE = "I18NAntTask.helpdoc-templateitem-not-file";
    @I18NMessage(value="The <helpdoc> template header file [{0}] exists but is actually a directory.")
    static final String I18N_HELPDOC_TEMPLATE_HEADER_FILE_NOT_A_FILE = "I18NAntTask.helpdoc-templateheader-not-file";
    @I18NMessage(value="The <helpdoc> template footer file [{0}] exists but is actually a directory.")
    static final String I18N_HELPDOC_TEMPLATE_FOOTER_FILE_NOT_A_FILE = "I18NAntTask.helpdoc-templatefooter-not-file";
    @I18NMessage(value="Writing helpdoc item [{0}] for bundle [{1}]")
    static final String I18N_WRITING_HELPDOC_ITEM = "I18NAntTask.writing-helpdoc-item";
    @I18NMessage(value="Appending template footer to the helpdoc [{0}]")
    static final String I18N_WRITING_HELPDOC_FOOTER = "I18NAntTask.writing-helpdoc-footer";
    @I18NMessage(value="The template footer contents is empty - not writing anything to the helpdoc.")
    static final String I18N_NOT_WRITING_EMPTY_HELPDOC_FOOTER = "I18NAntTask.not-writing-empty-helpdoc-footer";
    @I18NMessage(value="Ignoring the message [{0}] because it does not have a help description.")
    static final String I18N_IGNORE_NON_HELP_MESSAGE = "I18NAntTask.ignore-non-help-message";
    @I18NMessage(value="A default locale has been defined [{0}]")
    static final String DEFAULT_LOCALE_DEFINED = "I18NAntTask.default-locale-defined";
    @I18NMessage(value="VERIFY WARNING: A default locale has not been defined.\\n\\\nIf your users are in a locale which is not supported,\\n\\\nthey will not see any messages.")
    static final String I18N_VERIFY_WARNING_DEFAULT_LOCALE_NOT_DEFINED = "I18NAntTask.warning-default-locale-not-defined";
    @I18NMessage(value="Failed to copy resource bundle [{0}] to [{1}]. Cause: {2}")
    static final String FAILED_TO_COPY_BUNDLE = "I18NAntTask.failed-to-copy-bundle";
    @I18NMessage(value="[{0}] resource bundles have been created to support the default locale of [{1}]")
    static final String DEFAULT_BUNDLES_CREATED = "I18NAntTask.default-bundles-created";
    protected List<FileSet> m_classFilesets = new ArrayList<FileSet>();
    protected boolean m_verbose = false;
    protected boolean m_verify = true;
    private boolean m_append = false;
    private Locale m_defaultLocale = null;
    protected File m_outputDir;
    private Path m_classpath;
    private Map<ResourceBundleDefinition, List<String>> m_generatedBundleMessageKeys;
    private Map<ResourceBundleDefinition, MutableInteger> m_bundleCounters;
    private Map<ResourceBundleDefinition, MutableInteger> m_helpdocCounters;
    private Helpdoc m_helpdoc = null;

    public void addClassfileset(FileSet fs) {
        this.m_classFilesets.add(fs);
    }

    public void setClassfilesetRef(Reference reference) {
        this.addClassfileset(this.createFileSet(reference));
    }

    public void setVerbose(boolean verbose) {
        this.m_verbose = verbose;
    }

    public void setVerify(boolean verify) {
        this.m_verify = verify;
    }

    public void setOutputDir(File directory) {
        this.m_outputDir = directory;
    }

    public void setAppend(boolean append) {
        this.m_append = append;
    }

    public void setDefaultLocale(String default_locale) {
        this.m_defaultLocale = this.parseLocaleString(default_locale);
    }

    public void setClasspath(Path s) {
        this.createClasspath().append(s);
    }

    public void setClasspathRef(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path createClasspath() {
        if (this.m_classpath == null) {
            this.m_classpath = new Path(this.getProject());
        }
        return this.m_classpath;
    }

    public void addConfiguredHelpdoc(Helpdoc helpdoc) throws BuildException {
        if (this.m_helpdoc != null) {
            throw new BuildException(this.getMsg(I18N_HELPDOC_ALREADY_SPECIFIED, new Object[0]));
        }
        this.m_helpdoc = helpdoc;
    }

    /*
     * WARNING - void declaration
     */
    public void execute() throws BuildException {
        this.logMsg(I18N_START_PROCESSING, new Object[0]);
        this.validateTaskConfiguration();
        if (this.m_verify) {
            this.m_generatedBundleMessageKeys = new HashMap<ResourceBundleDefinition, List<String>>();
        }
        this.m_bundleCounters = new HashMap<ResourceBundleDefinition, MutableInteger>();
        this.m_helpdocCounters = new HashMap<ResourceBundleDefinition, MutableInteger>();
        AntClassLoader classloader = new AntClassLoader(((Object)((Object)this)).getClass().getClassLoader(), this.getProject(), this.m_classpath, true);
        classloader.setIsolated(false);
        List<String> class_files = this.getClassesFromFileSets(this.m_classFilesets);
        for (String string : class_files) {
            this.logMsgIfVerbose(I18N_PROCESSING_CLASS, string);
            try {
                String string2 = this.getClassNameFromClassFile(string);
                Class clazz = classloader.loadClass(string2);
                this.logMsgIfVerbose(I18N_LOADED_CLASS, clazz);
                if (this.processI18NClass(clazz)) continue;
                this.logMsgIfVerbose(I18N_CLASS_IGNORED, clazz);
            }
            catch (ClassNotFoundException e) {
                throw new BuildException(this.getMsg(I18N_CANNOT_FIND_CLASS, string, e.getMessage()));
            }
        }
        if (this.m_helpdoc != null) {
            try {
                for (Map.Entry entry : this.m_helpdocCounters.entrySet()) {
                    this.writeHelpDocFooter((ResourceBundleDefinition)entry.getKey());
                }
            }
            catch (Exception e) {
                throw new BuildException(this.getMsg(I18N_CANNOT_APPEND_HELPDOC_TEMPLATE_FOOTER, e.getMessage()), (Throwable)e);
            }
        }
        if (this.m_defaultLocale != null) {
            this.logMsgIfVerbose(DEFAULT_LOCALE_DEFINED, this.m_defaultLocale);
            HashMap<ResourceBundleDefinition, MutableInteger> default_bundles = new HashMap<ResourceBundleDefinition, MutableInteger>();
            for (Map.Entry<ResourceBundleDefinition, MutableInteger> bundle_counter : this.m_bundleCounters.entrySet()) {
                ResourceBundleDefinition generated_bundle = bundle_counter.getKey();
                if (!this.m_defaultLocale.equals(generated_bundle.locale)) continue;
                ResourceBundleDefinition default_bundle = new ResourceBundleDefinition();
                default_bundle.baseName = generated_bundle.baseName;
                default_bundle.locale = null;
                this.copyResourceBundle(generated_bundle, default_bundle);
                MutableInteger count = new MutableInteger();
                count.value = bundle_counter.getValue().value;
                default_bundles.put(default_bundle, count);
            }
            this.m_bundleCounters.putAll(default_bundles);
            this.logMsgIfVerbose(DEFAULT_BUNDLES_CREATED, default_bundles.size(), this.m_defaultLocale);
        } else if (this.m_verify) {
            this.logMsg(I18N_VERIFY_WARNING_DEFAULT_LOCALE_NOT_DEFINED, new Object[0]);
        }
        if (this.m_bundleCounters.size() > 0) {
            if (this.m_verbose) {
                this.logMsg(I18N_BUNDLES_PLACED_IN_DIR, this.m_outputDir);
                for (Map.Entry entry : this.m_bundleCounters.entrySet()) {
                    this.logMsg(I18N_BUNDLE_MESSAGE_COUNTER, entry.getKey(), ((MutableInteger)entry.getValue()).value);
                }
                if (this.m_helpdoc != null) {
                    this.logMsg(HELPDOCS_PLACED_IN_DIR, this.m_helpdoc.getOutputdir());
                    for (Map.Entry entry : this.m_helpdocCounters.entrySet()) {
                        this.logMsg(HELPDOCS_MESSAGE_COUNTER, entry.getKey(), this.m_helpdoc.getOutputfileext(), ((MutableInteger)entry.getValue()).value);
                    }
                }
            } else {
                void var4_17;
                int num_bundles = 0;
                boolean bl = false;
                for (MutableInteger num_messages_in_bundle : this.m_bundleCounters.values()) {
                    ++num_bundles;
                    var4_17 += num_messages_in_bundle.value;
                }
                this.logMsg(I18N_NUM_BUNDLES_MESSAGES_CREATED, num_bundles, (int)var4_17);
                if (this.m_helpdoc != null) {
                    int num_helpdocs = 0;
                    int num_helpdocs_items = 0;
                    for (MutableInteger num_items_in_helpdoc : this.m_bundleCounters.values()) {
                        ++num_helpdocs;
                        num_helpdocs_items += num_items_in_helpdoc.value;
                    }
                    this.logMsg(NUM_HELPDOCS_ITEMS_CREATED, num_helpdocs, num_helpdocs_items);
                }
            }
        } else {
            this.logMsg(I18N_NO_BUNDLES_CREATED, new Object[0]);
        }
    }

    private boolean processI18NClass(Class<?> clazz) throws BuildException {
        boolean was_internationalized = false;
        ResourceBundleDefinition default_bundle_def = new ResourceBundleDefinition();
        if (clazz.isAnnotationPresent(I18NResourceBundle.class)) {
            I18NResourceBundle bundle_ann = clazz.getAnnotation(I18NResourceBundle.class);
            this.processI18NResourceBundleAnnotation(default_bundle_def, bundle_ann);
            was_internationalized = true;
            this.logMsgIfVerbose(I18N_CLASS_ANNOTATED_WITH_BUNDLE, clazz.getName(), default_bundle_def);
        } else {
            this.logMsgIfVerbose(I18N_CLASS_NOT_ANNOTATED_WITH_BUNDLE, clazz.getName(), default_bundle_def);
        }
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            ResourceBundleDefinition field_bundle;
            Field field = fields[i];
            ArrayList<I18NMessage> i18n_messages_list = new ArrayList<I18NMessage>();
            if (field.isAnnotationPresent(I18NResourceBundle.class)) {
                field_bundle = new ResourceBundleDefinition();
                this.processI18NResourceBundleAnnotation(field_bundle, field.getAnnotation(I18NResourceBundle.class));
                this.logMsgIfVerbose(I18N_FIELD_ANNOTATED_WITH_BUNDLE, clazz.getName(), field.getName(), field_bundle);
            } else {
                field_bundle = default_bundle_def;
            }
            if (field.isAnnotationPresent(I18NMessages.class)) {
                i18n_messages_list.addAll(Arrays.asList(field.getAnnotation(I18NMessages.class).value()));
            }
            if (field.isAnnotationPresent(I18NMessage.class)) {
                i18n_messages_list.add(field.getAnnotation(I18NMessage.class));
            }
            if (i18n_messages_list.size() > 0) {
                this.generateResourceBundle(clazz, field, field_bundle, i18n_messages_list);
                was_internationalized = true;
            }
            i18n_messages_list = null;
        }
        return was_internationalized;
    }

    private void generateResourceBundle(Class<?> clazz, Field field, ResourceBundleDefinition bundle, List<I18NMessage> i18n_messages_list) throws BuildException {
        String bundle_key;
        this.logMsgIfVerbose(I18N_FIELD_MESSAGE_COUNT, clazz.getName(), field.getName(), i18n_messages_list.size());
        if (!field.getType().equals(String.class)) {
            throw new BuildException(this.getMsg(I18N_FIELD_NOT_STRING, clazz.getName(), field.getName()));
        }
        if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) {
            throw new BuildException(this.getMsg(I18N_FIELD_NOT_STATIC_FINAL, clazz.getName(), field.getName()));
        }
        try {
            bundle_key = (String)field.get(null);
            if (bundle_key == null || bundle_key.length() == 0) {
                throw new Exception(this.getMsg(I18N_FIELD_VALUE_CANNOT_BE_EMPTY, new Object[0]));
            }
            if (bundle_key.indexOf(61) > -1) {
                throw new Exception(this.getMsg(I18N_NO_EQUALS_ALLOWED, bundle_key));
            }
        }
        catch (Exception e) {
            throw new BuildException(this.getMsg(I18N_FAILED_TO_GET_FIELD_VALUE, clazz.getName(), field.getName(), e.getMessage()));
        }
        for (I18NMessage i18n_message : i18n_messages_list) {
            try {
                this.writeI18NMessage(clazz, field, bundle, bundle_key, i18n_message);
            }
            catch (BuildException be) {
                throw be;
            }
            catch (Exception e) {
                throw new BuildException(this.getMsg(I18N_FAILED_TO_WRITE_TO_BUNDLE, clazz.getName(), field.getName(), e.getMessage()), (Throwable)e);
            }
        }
    }

    private void writeI18NMessage(Class<?> clazz, Field field, ResourceBundleDefinition bundle, String bundle_key, I18NMessage i18n_message) throws BuildException, IOException {
        String msg_text = i18n_message.value();
        String msg_locale = i18n_message.locale();
        ResourceBundleDefinition bundle_to_write_to = bundle;
        if (msg_locale != null && msg_locale.length() > 0) {
            bundle_to_write_to = new ResourceBundleDefinition();
            bundle_to_write_to.baseName = bundle.baseName;
            bundle_to_write_to.locale = this.parseLocaleString(msg_locale);
        }
        if (msg_text == null || msg_text.trim().length() == 0) {
            this.logMsg(I18N_MESSAGE_TEXT_IS_EMPTY, bundle_key, clazz.getName(), field.getName());
            return;
        }
        if (this.m_verify) {
            this.checkNewlines(clazz, field, bundle_key, msg_text);
            this.checkSingleQuotes(clazz, field, bundle_key, msg_text);
            this.checkForDuplicate(clazz, field, bundle_to_write_to, bundle_key, msg_text);
        }
        boolean append_bundle = true;
        MutableInteger old_bundle_count = this.m_bundleCounters.get(bundle_to_write_to);
        if (old_bundle_count == null) {
            old_bundle_count = new MutableInteger();
            this.m_bundleCounters.put(bundle_to_write_to, old_bundle_count);
            append_bundle = this.m_append;
        }
        ++old_bundle_count.value;
        File bundle_file = new File(this.m_outputDir, bundle_to_write_to + ".properties");
        String resource_key_and_value = bundle_key + "=" + msg_text;
        this.logMsgIfVerbose(I18N_WRITING_MESSAGE_TO_BUNDLE, bundle_file, resource_key_and_value);
        PrintWriter pw = new PrintWriter(new FileWriter(bundle_file, append_bundle));
        pw.println(resource_key_and_value);
        pw.close();
        if (this.m_helpdoc != null) {
            if (!this.m_helpdoc.getHelpmessagesonly() || i18n_message.help() != null && i18n_message.help().length() > 0) {
                boolean append_helpdoc = true;
                boolean include_header = false;
                MutableInteger old_helpdoc_count = this.m_helpdocCounters.get(bundle_to_write_to);
                if (old_helpdoc_count == null) {
                    old_helpdoc_count = new MutableInteger();
                    this.m_helpdocCounters.put(bundle_to_write_to, old_helpdoc_count);
                    append_helpdoc = this.m_helpdoc.getAppend();
                    include_header = true;
                }
                ++old_helpdoc_count.value;
                try {
                    this.writeHelpDocItem(clazz, field, bundle_to_write_to, bundle_key, i18n_message, append_helpdoc, include_header);
                }
                catch (Exception e) {
                    throw new BuildException(this.getMsg(I18N_FAILED_TO_WRITE_HELPDOC_ITEM, clazz.getName(), field.getName(), e.getMessage()), (Throwable)e);
                }
            } else {
                this.logMsgIfVerbose(I18N_IGNORE_NON_HELP_MESSAGE, bundle_key);
            }
        }
    }

    private void writeHelpDocItem(Class<?> clazz, Field field, ResourceBundleDefinition bundle, String bundle_key, I18NMessage i18n_message, boolean append, boolean include_header) throws Exception {
        this.logMsgIfVerbose(I18N_WRITING_HELPDOC_ITEM, bundle_key, bundle);
        String template_contents = this.m_helpdoc.getTemplateitemContents();
        template_contents = this.replaceAll(template_contents, "@@@I18NBUNDLE@@@", bundle.toString());
        template_contents = this.replaceAll(template_contents, "@@@I18NKEY@@@", bundle_key);
        template_contents = this.replaceAll(template_contents, "@@@I18NMESSAGE@@@", i18n_message.value());
        if (i18n_message.help() != null) {
            template_contents = this.replaceAll(template_contents, "@@@I18NHELP@@@", i18n_message.help());
        }
        File helpdoc_file = new File(this.m_helpdoc.getOutputdir(), bundle + this.m_helpdoc.getOutputfileext());
        PrintWriter pw = new PrintWriter(new FileWriter(helpdoc_file, append));
        if (include_header) {
            String header_contents = this.m_helpdoc.getTemplateheaderContents();
            header_contents = this.replaceAll(header_contents, "@@@I18NBUNDLE@@@", bundle.toString());
            pw.print(header_contents);
        }
        pw.print(template_contents);
        pw.close();
    }

    private void writeHelpDocFooter(ResourceBundleDefinition bundle) throws Exception {
        File helpdoc_file = new File(this.m_helpdoc.getOutputdir(), bundle + this.m_helpdoc.getOutputfileext());
        String footer_contents = this.m_helpdoc.getTemplatefooterContents();
        this.logMsgIfVerbose(I18N_WRITING_HELPDOC_FOOTER, helpdoc_file);
        if (footer_contents != null && footer_contents.length() > 0) {
            footer_contents = this.replaceAll(footer_contents, "@@@I18NBUNDLE@@@", bundle.toString());
            PrintWriter pw = new PrintWriter(new FileWriter(helpdoc_file, true));
            pw.print(footer_contents);
            pw.close();
        } else {
            this.logMsgIfVerbose(I18N_NOT_WRITING_EMPTY_HELPDOC_FOOTER, new Object[0]);
        }
    }

    private void checkForDuplicate(Class<?> clazz, Field field, ResourceBundleDefinition bundle, String bundle_key, String text) {
        List<String> bundleKeyList = this.m_generatedBundleMessageKeys.get(bundle);
        if (bundleKeyList != null) {
            if (bundleKeyList.contains(bundle_key)) {
                this.logMsg(I18N_VERIFY_WARNING_DUPLICATE, bundle_key, clazz.getName(), field.getName(), text);
            }
        } else {
            bundleKeyList = new ArrayList<String>();
            this.m_generatedBundleMessageKeys.put(bundle, bundleKeyList);
        }
        bundleKeyList.add(bundle_key);
    }

    private void checkSingleQuotes(Class<?> clazz, Field field, String bundle_key, String text) {
        int first_quote = text.indexOf(39);
        boolean quoted_placeholder = false;
        while (first_quote > -1 && !quoted_placeholder) {
            int second_quote = text.indexOf(39, first_quote + 1);
            if (first_quote + 1 == second_quote) {
                first_quote = text.indexOf(39, second_quote + 1);
                continue;
            }
            if (second_quote > -1) {
                quoted_placeholder = text.substring(first_quote, second_quote).matches("(?s).*\\{[0-9].*");
                first_quote = text.indexOf(39, second_quote + 1);
                continue;
            }
            quoted_placeholder = text.substring(first_quote).matches("(?s).*\\{[0-9].*");
            first_quote = -1;
        }
        if (quoted_placeholder) {
            this.logMsg(I18N_VERIFY_WARNING_QUOTED_PLACEHOLDER, bundle_key, clazz.getName(), field.getName(), text);
        }
    }

    private void checkNewlines(Class<?> clazz, Field field, String bundle_key, String text) {
        int newline_index = -1;
        do {
            int next_index_increment = 1;
            int start_search_index = newline_index;
            if ((newline_index = text.indexOf("\r\n", start_search_index)) == -1) {
                newline_index = text.indexOf("\n", start_search_index);
            } else {
                next_index_increment = 2;
            }
            if (newline_index <= -1) continue;
            if (newline_index == 0 || text.charAt(newline_index - 1) != '\\') {
                this.logMsg(I18N_VERIFY_WARNING_UNESCAPED_NEWLINE, bundle_key, clazz.getName(), field.getName(), newline_index, text.substring(newline_index - 30 < 0 ? 0 : newline_index - 30, newline_index), text);
                break;
            }
            newline_index += next_index_increment;
        } while (newline_index > -1);
    }

    private void processI18NResourceBundleAnnotation(ResourceBundleDefinition definition, I18NResourceBundle annotation) {
        String ann_default_locale = annotation.defaultLocale();
        String ann_base_name = annotation.baseName();
        if (ann_default_locale != null && ann_default_locale.length() > 0) {
            definition.locale = this.parseLocaleString(ann_default_locale);
        }
        if (ann_base_name != null && ann_base_name.length() > 0) {
            definition.baseName = ann_base_name;
        }
    }

    private Locale parseLocaleString(String locale_str) {
        String[] locale_specs = locale_str.split("_");
        String language = locale_specs.length > 0 ? locale_specs[0] : "";
        String country = locale_specs.length > 1 ? locale_specs[1] : "";
        String variant = locale_specs.length > 2 ? locale_specs[2] : "";
        return new Locale(language, country, variant);
    }

    private void validateTaskConfiguration() throws BuildException {
        if (this.m_outputDir == null) {
            this.m_outputDir = new File(System.getProperty("java.io.tmpdir"));
        }
        if (!this.m_outputDir.exists() && !this.m_outputDir.mkdirs()) {
            throw new BuildException(this.getMsg(I18N_CANNOT_CREATE_OUTPUT_DIR, this.m_outputDir));
        }
        if (!this.m_outputDir.isDirectory()) {
            throw new BuildException(this.getMsg(I18N_OUTPUT_DIR_NOT_A_DIR, this.m_outputDir));
        }
        if (this.m_classFilesets == null || this.m_classFilesets.size() == 0) {
            throw new BuildException(this.getMsg(I18N_NO_CLASS_FILESETS, new Object[0]));
        }
        if (this.m_classpath == null || this.m_classpath.size() == 0) {
            throw new BuildException(this.getMsg(I18N_EMPTY_CLASSPATH, new Object[0]));
        }
        if (this.m_helpdoc != null) {
            this.validateHelpdoc(this.m_helpdoc);
        }
        if (this.m_verbose) {
            this.logMsg(I18N_VERBOSE_ON, new Object[0]);
            this.logMsg(I18N_DEFAULT_LOCALE, (I18NAntTask)this.new ResourceBundleDefinition().locale);
            this.logMsg(I18N_VERIFY_MODE, this.m_verify ? "ON" : "OFF");
            this.logMsg(I18N_APPEND_MODE, this.m_append ? "ON" : "OFF");
            this.logMsg(I18N_OUTPUT_DIR, this.m_outputDir);
            this.logMsg(I18N_CLASSPATH, this.m_classpath);
            this.logMsg(I18N_HELPDOC, new Object[]{this.m_helpdoc});
        }
    }

    private void validateHelpdoc(Helpdoc helpdoc) throws BuildException {
        File template;
        if (helpdoc.getTemplateitem() != null && (template = new File(helpdoc.getTemplateitem())).exists() && template.isDirectory()) {
            throw new BuildException(this.getMsg(I18N_HELPDOC_TEMPLATE_ITEM_FILE_NOT_A_FILE, helpdoc.getTemplateitem()));
        }
        if (helpdoc.getTemplateheader() != null && (template = new File(helpdoc.getTemplateheader())).exists() && template.isDirectory()) {
            throw new BuildException(this.getMsg(I18N_HELPDOC_TEMPLATE_HEADER_FILE_NOT_A_FILE, helpdoc.getTemplateheader()));
        }
        if (helpdoc.getTemplatefooter() != null && (template = new File(helpdoc.getTemplatefooter())).exists() && template.isDirectory()) {
            throw new BuildException(this.getMsg(I18N_HELPDOC_TEMPLATE_FOOTER_FILE_NOT_A_FILE, helpdoc.getTemplatefooter()));
        }
        if (helpdoc.getOutputdir() == null) {
            throw new BuildException(this.getMsg(I18N_HELPDOC_OUTPUT_DIR_IS_NULL, new Object[0]));
        }
        File output = new File(helpdoc.getOutputdir());
        if (output.exists()) {
            if (!output.isDirectory()) {
                throw new BuildException(this.getMsg(I18N_HELPDOC_OUTPUT_DIR_NOT_A_DIR, helpdoc.getOutputdir()));
            }
        } else {
            output.mkdirs();
            if (!output.isDirectory()) {
                throw new BuildException(this.getMsg(I18N_HELPDOC_CANNOT_CREATE_OUTPUT_DIR, helpdoc.getOutputdir()));
            }
        }
    }

    private List<String> getClassesFromFileSets(List<FileSet> filesets) {
        ArrayList<String> class_files = new ArrayList<String>();
        for (FileSet fileset : filesets) {
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            for (String file : ds.getIncludedFiles()) {
                class_files.add(file);
            }
        }
        return class_files;
    }

    private FileSet createFileSet(Reference reference) {
        FileSet fs = new FileSet();
        fs.setRefid(reference);
        fs.setProject(this.getProject());
        return fs;
    }

    private void logMsg(String key, Object ... params) {
        this.log(this.getMsg(key, params));
    }

    private void logMsgIfVerbose(String key, Object ... varargs) {
        if (this.m_verbose) {
            this.log(this.getMsg(key, varargs));
        }
    }

    private String getMsg(String key, Object ... varargs) {
        return Msg.createMsg(BUNDLE_BASE_NAME, key, varargs).toString();
    }

    private String getClassNameFromClassFile(String class_file) {
        class_file = class_file.replace(File.separatorChar, '.');
        class_file = class_file.replaceAll("\\.class$", "");
        return class_file;
    }

    private String replaceAll(String target_str, String substring_to_replace, String replacement) {
        return target_str.replaceAll(Pattern.quote(substring_to_replace), Matcher.quoteReplacement(replacement));
    }

    private void copyResourceBundle(ResourceBundleDefinition from, ResourceBundleDefinition to) throws BuildException {
        File from_file = new File(this.m_outputDir, from + ".properties");
        File to_file = new File(this.m_outputDir, to + ".properties");
        InputStream from_stream = null;
        OutputStream to_stream = null;
        try {
            int buffer_size = 32768;
            from_stream = new BufferedInputStream(new FileInputStream(from_file), buffer_size);
            to_stream = new BufferedOutputStream(new FileOutputStream(to_file), buffer_size);
            byte[] buffer = new byte[buffer_size];
            int bytes = from_stream.read(buffer);
            while (bytes != -1) {
                to_stream.write(buffer, 0, bytes);
                bytes = from_stream.read(buffer);
            }
            to_stream.flush();
        }
        catch (Exception e) {
            throw new BuildException(this.getMsg(FAILED_TO_COPY_BUNDLE, from_file, to_file, e.getMessage()), (Throwable)e);
        }
        finally {
            try {
                if (to_stream != null) {
                    to_stream.close();
                }
            }
            catch (Exception e) {}
            try {
                if (from_stream != null) {
                    from_stream.close();
                }
            }
            catch (Exception e) {}
        }
    }

    static /* synthetic */ Locale access$200(I18NAntTask x0) {
        return x0.m_defaultLocale;
    }

    private class MutableInteger {
        int value = 0;

        private MutableInteger() {
        }
    }

    private class ResourceBundleDefinition {
        String baseName = "messages";
        Locale locale = I18NAntTask.access$200(I18NAntTask.this) != null ? I18NAntTask.access$200(I18NAntTask.this) : Locale.getDefault();

        private ResourceBundleDefinition() {
        }

        public String toString() {
            return this.baseName + (this.locale != null ? "_" + this.locale : "");
        }

        public boolean equals(Object obj) {
            return this.toString().equals(obj.toString());
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

