/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bootstrap.api.helpers;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Map;
import org.jboss.webbeans.bootstrap.api.Singleton;
import org.jboss.webbeans.bootstrap.api.SingletonProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCCLSingletonProvider
extends SingletonProvider {
    @Override
    public <T> Singleton<T> create(Class<? extends T> type) {
        return new TCCLSingleton();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TCCLSingleton<T>
    implements Singleton<T> {
        private final Map<ClassLoader, T> store = new Hashtable<ClassLoader, T>();

        private TCCLSingleton() {
        }

        @Override
        public T get() {
            return this.store.get(this.getClassLoader());
        }

        @Override
        public void set(T object) {
            this.store.put(this.getClassLoader(), object);
        }

        private ClassLoader getClassLoader() {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return Thread.currentThread().getContextClassLoader();
                    }
                });
            }
            return Thread.currentThread().getContextClassLoader();
        }
    }
}

