/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository;

import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.client.spi.main.MainDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.profileservice.spi.ProfileDeployment;
import org.jboss.system.server.profileservice.attachments.AttachmentStore;

public class MainDeployerAdapter {
    private MainDeployer mainDeployer;
    private AttachmentStore store;

    public AttachmentStore getAttachmentStore() {
        return this.store;
    }

    public void setAttachmentStore(AttachmentStore store) {
        this.store = store;
    }

    public MainDeployer getMainDeployer() {
        return this.mainDeployer;
    }

    public void setMainDeployer(MainDeployer mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    public void create() throws Exception {
        if (this.mainDeployer == null) {
            throw new IllegalStateException("Null mainDeployer");
        }
        if (this.store == null) {
            throw new IllegalStateException("Null attachment store.");
        }
    }

    public void addDeployment(ProfileDeployment deployment) throws Exception {
        if (deployment == null) {
            throw new IllegalArgumentException("Null deployment.");
        }
        Deployment d = this.loadDeploymentData(deployment);
        this.mainDeployer.addDeployment(d);
    }

    public void removeDeployment(String name) throws DeploymentException {
        if (name == null) {
            throw new IllegalArgumentException("Null name.");
        }
        this.mainDeployer.removeDeployment(name);
    }

    public void removeDeployment(ProfileDeployment deployment) throws Exception {
        if (deployment == null) {
            throw new IllegalArgumentException("Null deployment");
        }
        this.removeDeployment(deployment.getName());
    }

    public void process() {
        this.mainDeployer.process();
    }

    public void checkComplete(String ... names) throws DeploymentException {
        this.mainDeployer.checkComplete(names);
    }

    public void checkComplete() throws DeploymentException {
        this.mainDeployer.checkComplete();
    }

    protected Deployment loadDeploymentData(ProfileDeployment deployment) throws Exception {
        return this.store.createDeployment(deployment);
    }
}

