/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.measurement;

import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pc.PluginContainer;
import org.rhq.core.pc.inventory.InventoryManager;
import org.rhq.core.pc.inventory.ResourceContainer;
import org.rhq.core.pc.measurement.MeasurementManager;
import org.rhq.core.pc.measurement.ScheduledMeasurementInfo;
import org.rhq.core.pc.util.ComponentUtil;
import org.rhq.core.pc.util.FacetLockType;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasurementCollectorRunner
implements Callable<MeasurementReport>,
Runnable {
    private Log log = LogFactory.getLog(MeasurementCollectorRunner.class);
    private MeasurementManager measurementManager;

    public MeasurementCollectorRunner(MeasurementManager measurementManager) {
        this.measurementManager = measurementManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MeasurementReport call() {
        MeasurementReport report = null;
        try {
            this.measurementManager.getLock().readLock().lock();
            report = this.measurementManager.getActiveReport();
            long start = System.currentTimeMillis();
            InventoryManager im = PluginContainer.getInstance().getInventoryManager();
            Set<ScheduledMeasurementInfo> requests = this.measurementManager.getNextScheduledSet();
            if (requests != null) {
                if (System.currentTimeMillis() - 30000L > requests.iterator().next().getNextCollection()) {
                    this.measurementManager.incrementLateCollections(requests.size());
                    this.log.debug((Object)("Measurement collection is falling behind... Missed requested time by [" + (System.currentTimeMillis() - requests.iterator().next().getNextCollection()) + "ms]"));
                    this.measurementManager.reschedule(requests);
                    MeasurementReport measurementReport = report;
                    return measurementReport;
                }
                Integer id = requests.iterator().next().getResourceId();
                ResourceContainer container = im.getResourceContainer(id);
                if (container.getResourceComponentState() != ResourceContainer.ResourceComponentState.STARTED || container.getAvailability() == null || container.getAvailability().getAvailabilityType() == AvailabilityType.DOWN) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Measurements not collected for inactive resource component: " + container.getResource()));
                    }
                } else {
                    MeasurementFacet measurementComponent = ComponentUtil.getComponent(id, MeasurementFacet.class, FacetLockType.READ, 30000L, true, true);
                    this.getValues(measurementComponent, report, requests);
                }
                this.measurementManager.reschedule(requests);
                report.incrementCollectionTime(System.currentTimeMillis() - start);
            }
        }
        catch (Throwable t) {
            this.log.error((Object)"Failed to run measurement collection", t);
        }
        finally {
            this.measurementManager.getLock().readLock().unlock();
        }
        return report;
    }

    private void getValues(MeasurementFacet measurementComponent, MeasurementReport report, Set<? extends MeasurementScheduleRequest> requests) {
        try {
            long start = System.currentTimeMillis();
            measurementComponent.getValues(report, requests);
            long duration = System.currentTimeMillis() - start;
            if (duration > 2000L) {
                this.log.info((Object)("Collection of measurements for [" + measurementComponent + "] took [" + duration + "ms]"));
            }
        }
        catch (Throwable t) {
            this.measurementManager.incrementFailedCollections(requests.size());
            this.log.warn((Object)("Failure to collect measurement data from: " + measurementComponent), t);
        }
    }

    @Override
    public void run() {
        try {
            this.call();
        }
        catch (Exception e) {
            this.log.error((Object)"Could not get measurement report", (Throwable)e);
        }
    }
}

