/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.plugin;

import java.io.File;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.descriptor.AgentPluginDescriptorUtil;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.pc.plugin.PluginClassLoader;

public class PluginDescriptorLoader {
    private final Log log = LogFactory.getLog(this.getClass());
    private final URL pluginJarUrl;
    private ClassLoader pluginClassLoader;

    public PluginDescriptorLoader(URL pluginJarUrl, ClassLoader classLoader, ClassLoader parentClassLoader, boolean unpackJars, File tmpDir) throws PluginContainerException {
        this.pluginJarUrl = pluginJarUrl;
        this.pluginClassLoader = classLoader != null ? classLoader : this.createPluginClassLoader(pluginJarUrl, parentClassLoader, unpackJars, tmpDir);
    }

    private ClassLoader createPluginClassLoader(URL jarUrl, ClassLoader parentClassLoader, boolean unpackJars, File tmpDir) throws PluginContainerException {
        ClassLoader classLoader;
        if (parentClassLoader == null) {
            parentClassLoader = this.getClass().getClassLoader();
        }
        if (jarUrl != null) {
            classLoader = PluginClassLoader.create(new File(jarUrl.getPath()).getName(), jarUrl, unpackJars, parentClassLoader, tmpDir);
            this.log.debug((Object)("Created classloader for plugin [" + jarUrl + "]"));
        } else {
            classLoader = parentClassLoader;
        }
        return classLoader;
    }

    public ClassLoader getPluginClassLoader() {
        return this.pluginClassLoader;
    }

    public PluginDescriptor loadPluginDescriptor() throws PluginContainerException {
        return AgentPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)this.pluginJarUrl);
    }

    public void destroy() {
        if (this.pluginClassLoader instanceof PluginClassLoader) {
            ((PluginClassLoader)this.pluginClassLoader).destroy();
        }
        this.pluginClassLoader = null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[pluginJarUrl=" + this.pluginJarUrl + ", pluginClassLoader=" + this.pluginClassLoader + "]";
    }
}

