/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.platform.content.yum;

import java.io.File;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.plugins.platform.content.yum.Request;
import org.rhq.plugins.platform.content.yum.YumContext;

public class YumServer {
    private ServerSocket socket = null;
    private Thread thread = null;
    private boolean run = true;
    YumContext context;
    private static final String yumconf = "/etc/yum.repos.d/rhq.repo";
    private final Log log = LogFactory.getLog(YumServer.class);

    public void start(YumContext context) throws Exception {
        this.context = context;
        if (this.thread != null) {
            this.log.warn((Object)"Already started, restarting ...");
            this.halt();
        }
        this.setupYumConfiguration();
        int port = context.baseurl().getPort();
        InetAddress host = this.bindAddress();
        this.log.info((Object)("Binding: " + host + ":" + port));
        this.socket = new ServerSocket(port, 20, host);
        this.socket.setSoTimeout(2000);
        this.start(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void halt() {
        if (this.thread == null) {
            this.log.warn((Object)"Stop ignored: not running");
            return;
        }
        try {
            this.run = false;
            this.thread.join();
            this.thread = null;
            this.socket.close();
            this.log.info((Object)"Stopped");
        }
        catch (Exception e) {
            this.log.error((Object)"halt falied", (Throwable)e);
        }
        finally {
            this.removeYumConfiguration();
        }
    }

    public void cleanMetadata() {
        try {
            Request request = new Request(this, null);
            request.cleanMetadata();
        }
        catch (Exception e) {
            this.log.error((Object)"Clean metadata failed", (Throwable)e);
        }
    }

    private void start(int port) {
        this.run = true;
        this.thread = new Thread("yum:" + port){

            public void run() {
                YumServer.this.log.info((Object)"listening ...");
                while (YumServer.this.run) {
                    YumServer.this.listen();
                }
            }
        };
        this.thread.start();
        this.log.info((Object)("Started, listening on port: " + port));
    }

    private void listen() {
        try {
            Socket client = this.socket.accept();
            client.setTcpNoDelay(true);
            client.setSoLinger(false, 0);
            Request request = new Request(this, client);
            request.process();
        }
        catch (SocketTimeoutException te) {
        }
        catch (Exception e) {
            this.log.warn((Object)"listen failed", (Throwable)e);
            this.run = false;
        }
    }

    private void setupYumConfiguration() {
        File file = new File(yumconf);
        try {
            PrintWriter writer = new PrintWriter(file);
            writer.println("[rhq]");
            writer.println("name=RHQ");
            writer.printf("baseurl=%s\n", this.context.baseurl());
            writer.printf("metadata_expire=%d\n", this.context.getMetadataCacheTimeout());
            writer.println("enabled=1");
            writer.println("gpgcheck=0");
            writer.println("keepalive=0");
            writer.println("timeout=90");
            writer.close();
        }
        catch (Exception e) {
            String msg = "The yum repo configuration file '" + file + "' could not be created/updated!";
            this.log.error((Object)msg, (Throwable)e);
        }
    }

    public void removeYumConfiguration() {
        File file = new File(yumconf);
        try {
            file.delete();
        }
        catch (Exception e) {
            String msg = "The yum repo configuration file '" + file + "' could not be removed!";
            this.log.error((Object)msg, (Throwable)e);
        }
    }

    private InetAddress bindAddress() throws UnknownHostException {
        byte[] host = new byte[]{127, 0, 0, 1};
        return InetAddress.getByAddress(host);
    }
}

