/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.read;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.buddyreplication.BuddyFqnTransformer;
import org.jboss.cache.buddyreplication.BuddyManager;
import org.jboss.cache.buddyreplication.GravitateResult;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.commands.read.AbstractDataCommand;
import org.jboss.cache.marshall.NodeData;
import org.jgroups.Address;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GravitateDataCommand
extends AbstractDataCommand {
    public static final int METHOD_ID = 35;
    private CacheSPI spi;
    protected boolean searchSubtrees;
    private Address localAddress;
    private static final Log log = LogFactory.getLog(GravitateDataCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private BuddyFqnTransformer buddyFqnTransformer;

    public GravitateDataCommand(Fqn fqn, boolean searchSubtrees, Address localAddress) {
        this.fqn = fqn;
        this.searchSubtrees = searchSubtrees;
        this.localAddress = localAddress;
    }

    public GravitateDataCommand(Address localAddress) {
        this.localAddress = localAddress;
    }

    public void initialize(DataContainer dataContainer, CacheSPI spi, BuddyFqnTransformer transformer) {
        this.dataContainer = dataContainer;
        this.spi = spi;
        this.buddyFqnTransformer = transformer;
    }

    @Override
    public Object perform(InvocationContext ctx) {
        if (trace) {
            log.trace((Object)("Caller is asking for " + this.fqn));
        }
        try {
            Object allGroupNames;
            ctx.setOriginLocal(false);
            ctx.getOptionOverrides().setSkipDataGravitation(true);
            NodeSPI actualNode = this.spi.getNode(this.fqn);
            ctx.getOptionOverrides().setSkipDataGravitation(false);
            if (trace) {
                log.trace((Object)("In local tree, this is " + actualNode));
            }
            Fqn<Object> backupNodeFqn = null;
            if (actualNode == null && this.searchSubtrees) {
                log.trace((Object)"Looking at backup trees.");
                allGroupNames = this.getBackupRoots();
                if (allGroupNames != null) {
                    Iterator i$ = allGroupNames.iterator();
                    while (i$.hasNext()) {
                        Object groupName = i$.next();
                        Fqn<String> backupRoot = Fqn.fromRelativeElements(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, (String)groupName);
                        if (this.buddyFqnTransformer.isDeadBackupRoot(backupRoot)) {
                            TreeSet<Object> deadChildNames = new TreeSet<Object>(this.spi.getChildrenNames(backupRoot));
                            Integer[] elems = deadChildNames.toArray(new Integer[deadChildNames.size()]);
                            for (int i = elems.length - 1; i > -1; --i) {
                                Integer versionOfDefunctData = elems[i];
                                backupNodeFqn = Fqn.fromRelativeFqn(Fqn.fromRelativeElements(backupRoot, versionOfDefunctData), this.fqn);
                                ctx.getOptionOverrides().setSkipDataGravitation(true);
                                actualNode = this.spi.peek(backupNodeFqn, false);
                                ctx.getOptionOverrides().setSkipDataGravitation(false);
                                if (actualNode == null) {
                                    continue;
                                }
                                break;
                            }
                        } else {
                            backupNodeFqn = Fqn.fromRelativeFqn(backupRoot, this.fqn);
                            ctx.getOptionOverrides().setSkipDataGravitation(true);
                            actualNode = this.spi.getNode(backupNodeFqn);
                            ctx.getOptionOverrides().setSkipDataGravitation(false);
                        }
                        if (trace) {
                            log.trace((Object)("Looking for " + backupNodeFqn + ". Search result: " + actualNode));
                        }
                        if (actualNode == null) continue;
                        break;
                    }
                }
            }
            if (actualNode == null) {
                allGroupNames = GravitateResult.noDataFound();
                return allGroupNames;
            }
            actualNode.getData();
            actualNode.getChildrenNames();
            if (backupNodeFqn == null && this.searchSubtrees) {
                backupNodeFqn = this.buddyFqnTransformer.getBackupFqn(this.buddyFqnTransformer.getGroupNameFromAddress(this.localAddress), this.fqn);
            }
            List<NodeData> list = this.dataContainer.buildNodeData(new LinkedList<NodeData>(), actualNode, false);
            GravitateResult gravitateResult = GravitateResult.subtreeResult(list, backupNodeFqn);
            return gravitateResult;
        }
        catch (RuntimeException re) {
            if (trace) {
                log.trace((Object)"Caught throwable", (Throwable)re);
            }
            throw re;
        }
        finally {
            ctx.setOriginLocal(true);
        }
    }

    protected Set<Object> getBackupRoots() {
        InternalNode backupSubtree = this.dataContainer.peekInternalNode(BuddyManager.BUDDY_BACKUP_SUBTREE_FQN, false);
        if (backupSubtree == null) {
            return null;
        }
        return backupSubtree.getChildrenNames();
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitGravitateDataCommand(ctx, this);
    }

    @Override
    public int getCommandId() {
        return 35;
    }

    public boolean isSearchSubtrees() {
        return this.searchSubtrees;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.fqn, this.searchSubtrees};
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        this.fqn = (Fqn)args[0];
        this.searchSubtrees = (Boolean)args[1];
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GravitateDataCommand that = (GravitateDataCommand)o;
        return this.searchSubtrees == that.searchSubtrees;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.searchSubtrees ? 1 : 0);
        return result;
    }

    @Override
    public String toString() {
        return "GravitateDataCommand{fqn=" + this.fqn + ", searchSubtrees=" + this.searchSubtrees + '}';
    }
}

