/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeltaMap<K, V>
extends AbstractMap<K, V> {
    private Map<K, V> original;
    private Set<K> exclude;
    private Map<K, V> changed = new HashMap();

    private DeltaMap(Map<K, V> original, Set<K> exclude) {
        if (original == null) {
            throw new NullPointerException("original");
        }
        if (exclude == null) {
            throw new NullPointerException("exclude");
        }
        this.original = original;
        this.exclude = exclude;
    }

    public static <K, V> DeltaMap<K, V> create(Map<K, V> original) {
        return new DeltaMap<K, V>(original, new HashSet());
    }

    public static <K, V> DeltaMap<K, V> create() {
        return DeltaMap.create(new HashMap(0));
    }

    public static <K, V> DeltaMap<K, V> excludeKeys(Map<K, V> original, Set<K> exclude) {
        return new DeltaMap<K, V>(original, exclude);
    }

    public static <K, V> DeltaMap<K, V> excludeKeys(Map<K, V> original, K ... exclude) {
        return DeltaMap.excludeKeys(original, new HashSet<K>(Arrays.asList(exclude)));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new WrappedIterator();
            }

            @Override
            public int size() {
                return DeltaMap.this.size();
            }
        };
    }

    @Override
    public int size() {
        int size = this.original.size();
        for (K o : this.changed.keySet()) {
            if (this.original.containsKey(o)) continue;
            ++size;
        }
        for (K o : this.exclude) {
            if (!this.original.containsKey(o)) continue;
            --size;
        }
        return size;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.exclude.contains(key)) {
            return false;
        }
        if (this.changed.containsKey(key)) {
            return true;
        }
        return this.original.containsKey(key);
    }

    @Override
    public V get(Object key) {
        if (this.exclude.contains(key)) {
            return null;
        }
        if (this.changed.containsKey(key)) {
            return this.changed.get(key);
        }
        return this.original.get(key);
    }

    @Override
    public V put(K key, V value) {
        V old = this.changed.containsKey(key) ? this.changed.get(key) : this.original.get(key);
        this.changed.put(key, value);
        if (this.exclude.contains(key)) {
            this.exclude.remove(key);
            return null;
        }
        return old;
    }

    @Override
    public V remove(Object key) {
        if (this.changed.containsKey(key)) {
            if (this.original.containsKey(key)) {
                this.exclude.add(key);
            }
            return this.changed.remove(key);
        }
        if (this.exclude.contains(key)) {
            return null;
        }
        if (this.original.containsKey(key)) {
            this.exclude.add(key);
            return this.original.get(key);
        }
        return null;
    }

    public void commit() {
        this.original.keySet().removeAll(this.exclude);
        this.original.putAll(this.changed);
        this.exclude.clear();
        this.changed.clear();
    }

    public boolean isModified() {
        return !this.changed.isEmpty() || !this.exclude.isEmpty();
    }

    public String toDebugString() {
        return "DeltaMap original=" + this.original + " exclude=" + this.exclude + " changed=" + this.changed;
    }

    @Override
    public void clear() {
        this.exclude.addAll(this.original.keySet());
        this.changed.clear();
    }

    public Map<K, V> getOriginal() {
        return this.original;
    }

    public void setOriginal(Map<K, V> original) {
        if (original == null) {
            throw new NullPointerException("original");
        }
        this.original = original;
    }

    public Map<K, V> getChanged() {
        return this.changed;
    }

    public Set<K> getRemoved() {
        return this.exclude;
    }

    static /* synthetic */ Map access$100(DeltaMap x0) {
        return x0.original;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WrappedIterator
    implements Iterator<Map.Entry<K, V>> {
        private boolean orig = true;
        private boolean nextSet = false;
        private Map.Entry<K, V> next;
        private Iterator<Map.Entry<K, V>> i = DeltaMap.access$100(DeltaMap.this).entrySet().iterator();

        private WrappedIterator() {
        }

        private boolean redef(Map.Entry<K, V> e) {
            Object key = e.getKey();
            return DeltaMap.this.exclude.contains(key) || DeltaMap.this.changed.containsKey(key);
        }

        @Override
        public boolean hasNext() {
            if (this.nextSet) {
                return true;
            }
            if (this.orig) {
                do {
                    if (!this.i.hasNext()) {
                        this.orig = false;
                        this.i = DeltaMap.this.changed.entrySet().iterator();
                        return this.hasNext();
                    }
                    this.next = this.i.next();
                } while (this.redef(this.next));
                this.nextSet = true;
                return true;
            }
            if (!this.i.hasNext()) {
                return false;
            }
            this.next = this.i.next();
            this.nextSet = true;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            try {
                Map.Entry entry = this.next;
                Object var3_2 = null;
                this.nextSet = false;
                return entry;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.nextSet = false;
                throw throwable;
            }
        }

        @Override
        public void remove() {
            DeltaMap.this.remove(this.next.getKey());
        }
    }
}

