/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.policy;

import org.apache.ws.policy.PrimitiveAssertion;
import org.jboss.ws.extensions.policy.deployer.domainAssertion.AssertionDeployer;
import org.jboss.ws.extensions.policy.deployer.exceptions.UnsupportedAssertion;
import org.jboss.ws.extensions.wsrm.config.RMConfig;
import org.jboss.ws.extensions.wsrm.config.RMDeliveryAssuranceConfig;
import org.jboss.ws.extensions.wsrm.config.RMPortConfig;
import org.jboss.ws.extensions.wsrm.protocol.RMProvider;
import org.jboss.ws.metadata.umdm.EndpointMetaData;
import org.jboss.ws.metadata.umdm.ExtensibleMetaData;

public final class RM10PolicyAssertionDeployer
implements AssertionDeployer {
    private static final String WSRM_NS = "http://schemas.xmlsoap.org/ws/2005/02/rm";

    public void deployClientSide(PrimitiveAssertion assertion, ExtensibleMetaData extMetaData) throws UnsupportedAssertion {
        RM10PolicyAssertionDeployer.deploy(assertion, extMetaData);
    }

    public void deployServerSide(PrimitiveAssertion assertion, ExtensibleMetaData extMetaData) throws UnsupportedAssertion {
        RM10PolicyAssertionDeployer.deploy(assertion, extMetaData);
    }

    private static void deploy(PrimitiveAssertion assertion, ExtensibleMetaData extMetaData) throws UnsupportedAssertion {
        if (extMetaData instanceof EndpointMetaData) {
            EndpointMetaData endpointMD = (EndpointMetaData)extMetaData;
            RMConfig rmMD = endpointMD.getConfig().getRMMetaData();
            if (rmMD == null) {
                rmMD = new RMConfig();
                endpointMD.getConfig().setRMMetaData(rmMD);
            }
            RMPortConfig portMD = new RMPortConfig();
            portMD.setPortName(endpointMD.getPortName());
            RMDeliveryAssuranceConfig deliveryMD = new RMDeliveryAssuranceConfig();
            deliveryMD.setInOrder("false");
            deliveryMD.setQuality("AtLeastOnce");
            portMD.setDeliveryAssurance(deliveryMD);
            for (RMPortConfig pMD : rmMD.getPorts()) {
                assert (!pMD.getPortName().equals(portMD.getPortName()));
            }
            rmMD.getPorts().add(portMD);
            if (!WSRM_NS.equals(RMProvider.get().getNamespaceURI())) {
                throw new IllegalArgumentException("RM provider namespace mismatch");
            }
        }
    }
}

