/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.jbws;

import org.jboss.ws.extensions.eventing.deployment.EventingEndpointDeployment;
import org.jboss.ws.extensions.eventing.metadata.EventingEpMetaExt;
import org.jboss.ws.extensions.eventing.mgmt.SubscriptionManagerFactory;
import org.jboss.ws.extensions.eventing.mgmt.SubscriptionManagerMBean;
import org.jboss.ws.metadata.umdm.ServerEndpointMetaData;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.Endpoint;

public class EventingDeploymentAspect
extends DeploymentAspect {
    public void start(Deployment dep) {
        for (Endpoint ep : dep.getService().getEndpoints()) {
            ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)ep.getAttachment(ServerEndpointMetaData.class);
            if (sepMetaData == null) {
                throw new IllegalStateException("Cannot obtain endpoint meta data");
            }
            EventingEpMetaExt ext = (EventingEpMetaExt)sepMetaData.getExtension("http://schemas.xmlsoap.org/ws/2004/08/eventing");
            if (ext == null) continue;
            EventingEndpointDeployment desc = new EventingEndpointDeployment(ext.getEventSourceNS(), ext.getNotificationSchema(), ext.getNotificationRootElementNS());
            desc.setEndpointAddress(sepMetaData.getEndpointAddress());
            desc.setPortName(sepMetaData.getPortName());
            SubscriptionManagerFactory factory = SubscriptionManagerFactory.getInstance();
            SubscriptionManagerMBean manager = factory.getSubscriptionManager();
            manager.registerEventSource(desc);
        }
    }

    public void destroy(Deployment dep) {
        for (Endpoint ep : dep.getService().getEndpoints()) {
            ServerEndpointMetaData sepMetaData = (ServerEndpointMetaData)ep.getAttachment(ServerEndpointMetaData.class);
            if (sepMetaData == null) {
                throw new IllegalStateException("Cannot obtain endpoint meta data");
            }
            EventingEpMetaExt ext = (EventingEpMetaExt)sepMetaData.getExtension("http://schemas.xmlsoap.org/ws/2004/08/eventing");
            if (ext == null) continue;
            SubscriptionManagerFactory factory = SubscriptionManagerFactory.getInstance();
            SubscriptionManagerMBean manager = factory.getSubscriptionManager();
            manager.removeEventSource(ext.getEventSourceURI());
        }
    }
}

