/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.inject.DuplicateBindingTypeException;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.metadata.MetaDataCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FacadeImpl<T> {
    private static final Annotation[] EMPTY_BINDINGS = new Annotation[0];
    protected final Set<? extends Annotation> bindings;
    private final ManagerImpl manager;
    protected final Type type;

    protected FacadeImpl(Type type, ManagerImpl manager, Set<? extends Annotation> bindings) {
        this.manager = manager;
        this.type = type;
        this.bindings = bindings;
    }

    public String toString() {
        return "Abstract facade implmentation";
    }

    protected Annotation[] mergeInBindings(Annotation ... newBindings) {
        HashSet<? extends Annotation> result = new HashSet<Annotation>();
        result.addAll(this.bindings);
        for (Annotation newAnnotation : newBindings) {
            if (!((MetaDataCache)this.getManager().getServices().get(MetaDataCache.class)).getBindingTypeModel(newAnnotation.annotationType()).isValid()) {
                throw new IllegalArgumentException(newAnnotation + " is not a binding for " + this);
            }
            if (result.contains(newAnnotation)) {
                throw new DuplicateBindingTypeException(newAnnotation + " is already present in the bindings list for " + this);
            }
            result.add(newAnnotation);
        }
        return result.toArray(EMPTY_BINDINGS);
    }

    protected ManagerImpl getManager() {
        return this.manager.getCurrent();
    }
}

