/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.bean;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Named;
import javax.annotation.Stereotype;
import javax.context.Dependent;
import javax.event.Event;
import javax.inject.BindingType;
import javax.inject.DefinitionException;
import javax.inject.Specializes;
import javax.inject.Standard;
import javax.inject.manager.Bean;
import org.jboss.webbeans.ManagerImpl;
import org.jboss.webbeans.bean.RIBean;
import org.jboss.webbeans.bootstrap.BeanDeployerEnvironment;
import org.jboss.webbeans.context.DependentInstancesStore;
import org.jboss.webbeans.conversation.ConversationImpl;
import org.jboss.webbeans.injection.AnnotatedInjectionPoint;
import org.jboss.webbeans.introspector.AnnotatedField;
import org.jboss.webbeans.introspector.AnnotatedItem;
import org.jboss.webbeans.introspector.AnnotatedParameter;
import org.jboss.webbeans.literal.CurrentLiteral;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.metadata.MergedStereotypes;
import org.jboss.webbeans.metadata.MetaDataCache;
import org.jboss.webbeans.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBean<T, E>
extends RIBean<T> {
    private static Set<Class<?>> STANDARD_WEB_BEAN_CLASSES = new HashSet<Class>(Arrays.asList(Event.class, ManagerImpl.class, ConversationImpl.class));
    private boolean proxyable;
    protected final DependentInstancesStore dependentInstancesStore;
    private final LogProvider log = Logging.getLogProvider(AbstractBean.class);
    protected Set<Annotation> bindings;
    protected String name;
    protected Class<? extends Annotation> scopeType;
    private MergedStereotypes<T, E> mergedStereotypes;
    protected Class<? extends Annotation> deploymentType;
    protected Class<T> type;
    protected Set<? extends Type> types;
    protected Set<AnnotatedInjectionPoint<?, ?>> injectionPoints;
    private boolean primitive;
    protected ManagerImpl manager;
    protected boolean _serializable;
    private boolean initialized;

    public static Class<? extends Annotation> getDeploymentType(List<Class<? extends Annotation>> enabledDeploymentTypes, Map<Class<? extends Annotation>, Annotation> possibleDeploymentTypes) {
        for (int i = enabledDeploymentTypes.size() - 1; i > 0; --i) {
            if (!possibleDeploymentTypes.containsKey(enabledDeploymentTypes.get(i))) continue;
            return enabledDeploymentTypes.get(i);
        }
        return null;
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    public AbstractBean(ManagerImpl manager) {
        super(manager);
        this.manager = manager;
        this.injectionPoints = new HashSet();
        this.dependentInstancesStore = new DependentInstancesStore();
    }

    @Override
    public void initialize(BeanDeployerEnvironment environment) {
        this.mergedStereotypes = new MergedStereotypes(this.getAnnotatedItem().getMetaAnnotations(Stereotype.class), this.manager);
        if (this.isSpecializing()) {
            this.preSpecialize(environment);
            this.specialize(environment);
            this.postSpecialize();
        }
        this.initDefaultBindings();
        this.initPrimitive();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Building Web Bean bean metadata for " + this.getType()));
        }
        this.initName();
        this.initDeploymentType();
        this.checkDeploymentType();
        this.initScopeType();
        this.initSerializable();
        this.initProxyable();
        this.checkRequiredTypesImplemented();
    }

    protected void initTypes() {
        this.types = this.getAnnotatedItem().getFlattenedTypeHierarchy();
    }

    protected void initBindings() {
        this.bindings = new HashSet<Annotation>();
        this.bindings.addAll(this.getAnnotatedItem().getMetaAnnotations(BindingType.class));
    }

    protected void initDefaultBindings() {
        if (this.bindings.size() == 0) {
            this.log.trace((Object)"Adding default @Current binding type");
            this.bindings.add((Annotation)((Object)new CurrentLiteral()));
        } else if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Using binding types " + this.bindings + " specified by annotations"));
        }
    }

    protected abstract void initDeploymentType();

    protected void initDeploymentTypeFromStereotype() {
        Map<Class<? extends Annotation>, Annotation> possibleDeploymentTypes = this.getMergedStereotypes().getPossibleDeploymentTypes();
        if (possibleDeploymentTypes.size() > 0) {
            this.deploymentType = AbstractBean.getDeploymentType(this.manager.getEnabledDeploymentTypes(), possibleDeploymentTypes);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Deployment type " + this.deploymentType + " specified by stereotype"));
            }
            return;
        }
    }

    protected abstract Class<? extends Annotation> getDefaultDeploymentType();

    protected void initName() {
        boolean beanNameDefaulted = false;
        if (this.getAnnotatedItem().isAnnotationPresent(Named.class)) {
            String javaName = this.getAnnotatedItem().getAnnotation(Named.class).value();
            if ("".equals(javaName)) {
                this.log.trace((Object)"Using default name (specified by annotations)");
                beanNameDefaulted = true;
            } else {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Using name " + javaName + " specified by annotations"));
                }
                this.name = javaName;
                return;
            }
        }
        if (beanNameDefaulted || this.getMergedStereotypes().isBeanNameDefaulted()) {
            this.name = this.getDefaultName();
            return;
        }
    }

    protected void initProxyable() {
        this.proxyable = this.getAnnotatedItem().isProxyable();
    }

    protected void initPrimitive() {
        this.primitive = Reflections.isPrimitive(this.getType());
    }

    private boolean checkInjectionPointsAreSerializable() {
        boolean passivating = ((MetaDataCache)this.manager.getServices().get(MetaDataCache.class)).getScopeModel(this.getScopeType()).isPassivating();
        for (AnnotatedInjectionPoint<?, ?> injectionPoint : this.getInjectionPoints()) {
            Annotation[] bindings = injectionPoint.getMetaAnnotationsAsArray(BindingType.class);
            Bean resolvedBean = this.manager.resolveByType(injectionPoint.getRawType(), bindings).iterator().next();
            if (!passivating || !Dependent.class.equals((Object)resolvedBean.getScopeType()) || resolvedBean.isSerializable() || (!(injectionPoint instanceof AnnotatedField) || ((AnnotatedField)((Object)injectionPoint)).isTransient()) && !(injectionPoint instanceof AnnotatedParameter)) continue;
            return false;
        }
        return true;
    }

    protected abstract void initScopeType();

    protected boolean initScopeTypeFromStereotype() {
        Set<Annotation> possibleScopeTypes = this.getMergedStereotypes().getPossibleScopeTypes();
        if (possibleScopeTypes.size() == 1) {
            this.scopeType = possibleScopeTypes.iterator().next().annotationType();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Scope " + this.scopeType + " specified by stereotype"));
            }
            return true;
        }
        if (possibleScopeTypes.size() > 1) {
            throw new DefinitionException("All stereotypes must specify the same scope OR a scope must be specified on " + this.getAnnotatedItem());
        }
        return false;
    }

    protected void checkDeploymentType() {
        if (this.deploymentType == null) {
            throw new DefinitionException("type: " + this.getType() + " must specify a deployment type");
        }
        if (this.deploymentType.equals(Standard.class) && !STANDARD_WEB_BEAN_CLASSES.contains(this.getAnnotatedItem().getRawType())) {
            throw new DefinitionException(this.getAnnotatedItem().getName() + " cannot have deployment type @Standard");
        }
    }

    protected void checkRequiredTypesImplemented() {
        for (Class<T> clazz : this.getMergedStereotypes().getRequiredTypes()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Checking if required type " + clazz + " is implemented"));
            }
            if (clazz.isAssignableFrom(this.type)) continue;
            throw new DefinitionException("Required type " + clazz + " isn't implemented on " + this.type);
        }
    }

    protected void postSpecialize() {
        if (this.getAnnotatedItem().isAnnotationPresent(Named.class) && ((AbstractBean)this.getSpecializedBean()).getAnnotatedItem().isAnnotationPresent(Named.class)) {
            throw new DefinitionException("Cannot put name on specializing and specialized class " + this.getAnnotatedItem());
        }
        this.bindings.addAll(((AbstractBean)this.getSpecializedBean()).getBindings());
        if (this.isSpecializing() && ((AbstractBean)this.getSpecializedBean()).getAnnotatedItem().isAnnotationPresent(Named.class)) {
            this.name = ((AbstractBean)this.getSpecializedBean()).getName();
            return;
        }
        this.manager.getSpecializedBeans().put(this.getSpecializedBean(), this);
    }

    protected void preSpecialize(BeanDeployerEnvironment environment) {
    }

    protected void specialize(BeanDeployerEnvironment environment) {
    }

    protected abstract AnnotatedItem<T, E> getAnnotatedItem();

    public Set<Annotation> getBindings() {
        return this.bindings;
    }

    protected abstract String getDefaultName();

    public abstract AbstractBean<?, ?> getSpecializedBean();

    public Class<? extends Annotation> getDeploymentType() {
        return this.deploymentType;
    }

    @Override
    public Set<AnnotatedInjectionPoint<?, ?>> getInjectionPoints() {
        return this.injectionPoints;
    }

    protected MergedStereotypes<T, E> getMergedStereotypes() {
        return this.mergedStereotypes;
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends Annotation> getScopeType() {
        return this.scopeType;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    public Set<? extends Type> getTypes() {
        return this.types;
    }

    public boolean isAssignableFrom(AnnotatedItem<?, ?> annotatedItem) {
        return this.getAnnotatedItem().isAssignableFrom(annotatedItem);
    }

    public boolean isNullable() {
        return !this.isPrimitive();
    }

    @Override
    public boolean isPrimitive() {
        return this.primitive;
    }

    public boolean isSerializable() {
        return this._serializable && this.checkInjectionPointsAreSerializable();
    }

    protected void initSerializable() {
        this._serializable = Reflections.isSerializable(this.type);
    }

    public String toString() {
        return "AbstractBean " + this.getName();
    }

    @Override
    public boolean isProxyable() {
        return this.proxyable;
    }

    @Override
    public boolean isDependent() {
        return Dependent.class.equals(this.getScopeType());
    }

    @Override
    public boolean isSpecializing() {
        return this.getAnnotatedItem().isAnnotationPresent(Specializes.class);
    }
}

