/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.context.beanstore;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.context.Contextual;
import org.jboss.webbeans.CurrentManager;
import org.jboss.webbeans.context.api.BeanStore;
import org.jboss.webbeans.context.beanstore.BeanStoreNamingScheme;
import org.jboss.webbeans.log.LogProvider;
import org.jboss.webbeans.log.Logging;
import org.jboss.webbeans.util.EnumerationIterable;
import org.jboss.webbeans.util.Names;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAttributeBackedBeanStore
implements BeanStore {
    private static LogProvider log = Logging.getLogProvider(AbstractAttributeBackedBeanStore.class);

    public <T> T get(Contextual<? extends T> contextual) {
        String key = this.getNamingScheme().getContextualKey(contextual);
        Object instance = this.getAttribute(key);
        log.trace((Object)("Looked for " + key + " and got " + instance));
        return (T)instance;
    }

    public <T> T remove(Contextual<? extends T> contextual) {
        T instance = this.get(contextual);
        String key = this.getNamingScheme().getContextualKey(contextual);
        this.removeAttribute(key);
        log.trace((Object)("Removed bean under key " + key));
        return instance;
    }

    public void clear() {
        for (String attributeName : this.getFilteredAttributeNames()) {
            this.removeAttribute(attributeName);
        }
        log.trace((Object)"Bean store cleared");
    }

    public Iterable<Contextual<? extends Object>> getBeans() {
        ArrayList<Contextual<? extends Object>> contextuals = new ArrayList<Contextual<? extends Object>>();
        BeanStoreNamingScheme namingScheme = this.getNamingScheme();
        for (String attributeName : this.getFilteredAttributeNames()) {
            int beanIndex = namingScheme.getBeanIndexFromKey(attributeName);
            Contextual contextual = (Contextual)CurrentManager.rootManager().getBeans().get(beanIndex);
            contextuals.add((Contextual<? extends Object>)contextual);
        }
        return contextuals;
    }

    private List<String> getFilteredAttributeNames() {
        ArrayList<String> attributeNames = new ArrayList<String>();
        BeanStoreNamingScheme namingScheme = this.getNamingScheme();
        for (String attributeName : new EnumerationIterable<String>(this.getAttributeNames())) {
            if (!namingScheme.acceptKey(attributeName)) continue;
            attributeNames.add(attributeName);
        }
        return attributeNames;
    }

    public <T> void put(Contextual<? extends T> bean, T instance) {
        String key = this.getNamingScheme().getContextualKey(bean);
        this.setAttribute(key, instance);
        log.trace((Object)("Added bean " + bean + " under key " + key));
    }

    protected abstract Object getAttribute(String var1);

    protected abstract void removeAttribute(String var1);

    protected abstract Enumeration<String> getAttributeNames();

    protected abstract void setAttribute(String var1, Object var2);

    protected abstract BeanStoreNamingScheme getNamingScheme();

    public String toString() {
        return "holding " + Names.count(this.getBeans()) + " instances";
    }
}

