/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webbeans.event;

import javax.transaction.Synchronization;
import org.jboss.webbeans.transaction.spi.TransactionServices;

public class TransactionSynchronizedRunnable
implements Synchronization {
    private final TransactionServices.Status desiredStatus;
    private final Runnable task;
    private final boolean before;

    public TransactionSynchronizedRunnable(Runnable task, boolean before) {
        this(task, TransactionServices.Status.ALL, before);
    }

    public TransactionSynchronizedRunnable(Runnable task, TransactionServices.Status desiredStatus) {
        this(task, desiredStatus, false);
    }

    private TransactionSynchronizedRunnable(Runnable task, TransactionServices.Status desiredStatus, boolean before) {
        this.task = task;
        this.desiredStatus = desiredStatus;
        this.before = before;
    }

    public void afterCompletion(int status) {
        if (this.desiredStatus == TransactionServices.Status.SUCCESS && status == 3 || this.desiredStatus == TransactionServices.Status.FAILURE && status != 3 || this.desiredStatus == TransactionServices.Status.ALL) {
            this.task.run();
        }
    }

    public void beforeCompletion() {
        if (this.before) {
            this.task.run();
        }
    }
}

