/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jbossatx.jts;

import com.arjuna.ats.internal.jts.ORBManager;
import com.arjuna.ats.jts.utils.Utility;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.omg.CORBA.Object;
import org.omg.CosTransactions.CoordinatorHelper;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.TerminatorHelper;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.otid_t;

public class PropagationContextWrapper
implements Externalizable {
    private static boolean _propagateFullContext = false;
    private boolean _isNull = true;
    private int _timeout;
    private TransIdentityWrapper _current;
    private TransIdentityWrapper[] _parents = null;
    private PropagationContext _tpc = null;

    public static void setPropagateFullContext(boolean propagateFullContext) {
        _propagateFullContext = propagateFullContext;
    }

    public static boolean getPropagateFullContext() {
        return _propagateFullContext;
    }

    public PropagationContextWrapper() {
    }

    public PropagationContextWrapper(PropagationContext tpc) {
        this();
        boolean bl = this._isNull = tpc == null;
        if (tpc != null) {
            this._current = new TransIdentityWrapper();
            this._current._coordinator = ORBManager.getORB().orb().object_to_string((Object)tpc.current.coord);
            this._current.setOtid(tpc.current.otid);
            this._timeout = tpc.timeout;
            if (_propagateFullContext) {
                this._current._terminator = ORBManager.getORB().orb().object_to_string((Object)tpc.current.term);
                this._parents = new TransIdentityWrapper[tpc.parents.length];
                for (int count = 0; count < tpc.parents.length; ++count) {
                    this._parents[count] = new TransIdentityWrapper();
                    this._parents[count]._coordinator = ORBManager.getORB().orb().object_to_string((Object)tpc.parents[count].coord);
                    this._parents[count]._terminator = ORBManager.getORB().orb().object_to_string((Object)tpc.parents[count].term);
                    this._parents[count].setOtid(tpc.parents[count].otid);
                }
            }
        }
    }

    public int hashCode() {
        return this._isNull ? 0 : this._current.hashCode();
    }

    public boolean equals(java.lang.Object o) {
        if (o instanceof PropagationContextWrapper) {
            PropagationContextWrapper comp = (PropagationContextWrapper)o;
            if (!this._isNull && !comp._isNull) {
                return this._current.equals(comp._current);
            }
        }
        return false;
    }

    public PropagationContext getPropagationContext() {
        if (this._isNull) {
            return null;
        }
        if (this._tpc == null) {
            if (_propagateFullContext) {
                TransIdentity[] parents = new TransIdentity[this._parents != null ? this._parents.length : 0];
                for (int count = 0; count < parents.length; ++count) {
                    parents[count] = this._parents[count].getTransIdentity();
                }
                this._tpc = new PropagationContext(this._timeout, this._current.getTransIdentity(), parents, null);
            } else {
                this._tpc = new PropagationContext(this._timeout, this._current.getTransIdentity(), new TransIdentity[0], null);
            }
        }
        return this._tpc;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            out.writeBoolean(_propagateFullContext);
            out.writeBoolean(this._isNull);
            if (!this._isNull) {
                out.writeInt(this._timeout);
                this._current.writeExternal(out, _propagateFullContext);
                if (_propagateFullContext) {
                    out.writeInt(this._parents.length);
                    for (int count = 0; count < this._parents.length; ++count) {
                        this._parents[count].writeExternal(out, _propagateFullContext);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            boolean fullContext = in.readBoolean();
            this._isNull = in.readBoolean();
            if (!this._isNull) {
                this._timeout = in.readInt();
                this._current = new TransIdentityWrapper();
                this._current.readExternal(in, fullContext);
                if (fullContext) {
                    this._parents = new TransIdentityWrapper[in.readInt()];
                    for (int count = 0; count < this._parents.length; ++count) {
                        this._parents[count] = new TransIdentityWrapper();
                        this._parents[count].readExternal(in, fullContext);
                    }
                }
            }
            this._tpc = null;
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
    }

    private class TransIdentityWrapper
    implements Serializable {
        public String _coordinator = null;
        private otid_t _otid = null;
        public String _terminator = null;
        private int _hashCode = 0;

        private TransIdentityWrapper() {
        }

        public TransIdentity getTransIdentity() {
            return new TransIdentity(CoordinatorHelper.narrow((Object)ORBManager.getORB().orb().string_to_object(this._coordinator)), this._terminator == null ? null : TerminatorHelper.narrow((Object)ORBManager.getORB().orb().string_to_object(this._terminator)), this._otid);
        }

        public otid_t getOtid() {
            return this._otid;
        }

        public void setOtid(otid_t o) {
            this._otid = o;
            this._hashCode = Utility.otidToUid((otid_t)this._otid).hashCode();
        }

        private boolean same(otid_t otid1, otid_t otid2) {
            if (otid1.formatID == otid2.formatID && otid1.bqual_length == otid2.bqual_length) {
                for (int i = 0; i < otid1.bqual_length; ++i) {
                    if (otid1.tid[i] == otid2.tid[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(java.lang.Object o) {
            if (o instanceof TransIdentityWrapper) {
                TransIdentityWrapper t = (TransIdentityWrapper)o;
                return this._otid != null && t._otid != null && this.same(this._otid, t._otid);
            }
            return false;
        }

        public void writeExternal(ObjectOutput out, boolean fullContext) throws IOException {
            out.writeObject(this._coordinator);
            out.writeObject(this.getOtid());
            if (fullContext) {
                out.writeObject(this._terminator);
            }
        }

        public void readExternal(ObjectInput in, boolean fullContext) throws IOException, ClassNotFoundException {
            this._coordinator = (String)in.readObject();
            this.setOtid((otid_t)in.readObject());
            this._terminator = fullContext ? (String)in.readObject() : null;
        }
    }
}

