/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.spi;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.jboss.deployment.spi.JBossTarget;
import org.jboss.deployment.spi.status.ProgressObjectImpl;
import org.jboss.logging.Logger;

public class DeploymentWorker
extends Thread {
    private static final Logger log = Logger.getLogger(DeploymentWorker.class);
    private ProgressObjectImpl progress;

    public DeploymentWorker(ProgressObject progress) {
        this.progress = (ProgressObjectImpl)progress;
    }

    public void run() {
        log.trace((Object)"Begin run");
        CommandType cmdType = this.progress.getDeploymentStatus().getCommand();
        TargetModuleID[] modules = this.progress.getResultTargetModuleIDs();
        for (int i = 0; i < modules.length; ++i) {
            TargetModuleID moduleid = modules[i];
            JBossTarget target = (JBossTarget)moduleid.getTarget();
            try {
                this.progress.sendProgressEvent(StateType.RUNNING, "Operation " + cmdType + " started", moduleid);
                if (cmdType == CommandType.DISTRIBUTE) {
                    target.deploy(moduleid);
                    this.deleteDeployment(moduleid);
                } else if (cmdType == CommandType.START) {
                    target.start(moduleid);
                } else if (cmdType == CommandType.STOP) {
                    target.stop(moduleid);
                } else if (cmdType == CommandType.UNDEPLOY) {
                    target.undeploy(moduleid);
                    this.deleteDeployment(moduleid);
                }
                this.progress.sendProgressEvent(StateType.COMPLETED, "Operation " + cmdType + " completed", moduleid);
                continue;
            }
            catch (Exception e) {
                String message = "Operation " + cmdType + " failed on target " + target;
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println(message);
                e.printStackTrace(pw);
                pw.close();
                message = sw.toString();
                this.progress.sendProgressEvent(StateType.FAILED, message, moduleid);
                log.error((Object)message, (Throwable)e);
            }
        }
        log.trace((Object)"End run");
    }

    private void deleteDeployment(TargetModuleID moduleid) throws MalformedURLException {
        File deployment = new File(new URL(moduleid.getModuleID()).getPath());
        if (deployment.exists()) {
            if (!deployment.delete()) {
                log.warn((Object)("Cannot delete deployment file " + deployment + ", will be deleted on exit"));
                deployment.deleteOnExit();
            }
        } else {
            log.error((Object)("Deployment does not exist: " + deployment));
        }
    }
}

