/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metatype.plugins.values.mappers;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.ObjectName;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.plugins.types.MutableCompositeMetaType;
import org.jboss.metatype.spi.values.MetaMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectNameMetaMapper
extends MetaMapper<ObjectName> {
    CompositeMetaType type;

    public ObjectNameMetaMapper() {
        this.type = new MutableCompositeMetaType(ObjectName.class.getName(), "JMX ObjectName");
    }

    public ObjectNameMetaMapper(String ... args) {
        MutableCompositeMetaType mcmt = new MutableCompositeMetaType(ObjectName.class.getName(), "JMX ObjectName");
        if (!(args.length % 2 == 0)) {
            throw new IllegalStateException("args counts must be 2*n for n key,key-description pairs");
        }
        mcmt.addItem("domain", "the object name domain", SimpleMetaType.STRING);
        for (int n = 0; n < args.length; n += 2) {
            String key = args[n];
            String description = args[n + 1];
            mcmt.addItem(key, description, SimpleMetaType.STRING);
        }
        mcmt.freeze();
        this.type = mcmt;
    }

    @Override
    public MetaType getMetaType() {
        return this.type;
    }

    @Override
    public Type mapToType() {
        return ObjectName.class;
    }

    @Override
    public MetaValue createMetaValue(MetaType metaType, ObjectName object) {
        String domain = object.getDomain();
        Hashtable<String, String> props = object.getKeyPropertyList();
        HashMap<String, MetaValue> metaProps = new HashMap<String, MetaValue>();
        metaProps.put("domain", SimpleValueSupport.wrap((Serializable)((Object)domain)));
        for (Map.Entry entry : props.entrySet()) {
            metaProps.put((String)entry.getKey(), SimpleValueSupport.wrap((Serializable)entry.getValue()));
        }
        MapCompositeValueSupport map = new MapCompositeValueSupport(metaProps, SimpleMetaType.STRING);
        return map;
    }

    @Override
    public ObjectName unwrapMetaValue(MetaValue metaValue) {
        CompositeValue cv = (CompositeValue)metaValue;
        String domain = null;
        Hashtable<String, String> props = new Hashtable<String, String>();
        for (String key : cv.getMetaType().itemSet()) {
            SimpleValue svalue = (SimpleValue)cv.get(key);
            String value = (String)((Object)svalue.getValue());
            if (key.equalsIgnoreCase("domain")) {
                domain = value;
                continue;
            }
            props.put(key, value);
        }
        try {
            ObjectName name = new ObjectName(domain, props);
            return name;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to build ObjectName from MetaValue: " + metaValue, e);
        }
    }
}

