/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.jaxws;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPMessage;
import org.jboss.logging.Logger;
import org.jboss.ws.extensions.wsrm.RMConstant;
import org.jboss.ws.extensions.wsrm.RMFault;
import org.jboss.ws.extensions.wsrm.RMSequence;
import org.jboss.ws.extensions.wsrm.api.RMException;
import org.jboss.ws.extensions.wsrm.jaxws.RMHandlerHelper;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSerializable;
import org.jboss.wsf.common.handler.GenericSOAPHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RMHandlerAbstractBase
extends GenericSOAPHandler {
    protected final Logger log = Logger.getLogger(((Object)((Object)this)).getClass());

    public final Set<QName> getHeaders() {
        return RMConstant.PROTOCOL_OPERATION_QNAMES;
    }

    protected final void serialize(QName msgQN, List<QName> outMsgs, Map<QName, RMSerializable> data, SOAPMessage soapMessage, RMSequence seq) {
        RMSerializable msg = RMHandlerHelper.prepareData(msgQN, outMsgs, seq);
        if (msg != null) {
            msg.serializeTo(soapMessage);
            data.put(msgQN, msg);
            this.log.debug((Object)(msgQN.getLocalPart() + " WSRM message was serialized to payload"));
        }
    }

    protected final void deserialize(QName msgQN, SOAPMessage soapMessage, List<QName> messages, Map<QName, RMSerializable> data) {
        try {
            RMSerializable wsrmMsg = RMHandlerHelper.getMessage(msgQN);
            if (wsrmMsg != null) {
                wsrmMsg.deserializeFrom(soapMessage);
                messages.add(msgQN);
                data.put(msgQN, wsrmMsg);
                this.log.debug((Object)(msgQN.getLocalPart() + " WSRM message was deserialized from payload"));
            }
        }
        catch (RMException ignore) {
            // empty catch block
        }
    }

    protected final void serialize(QName msgQN, List<QName> outMsgs, Map<QName, RMSerializable> data, SOAPMessage soapMessage, RMFault fault) {
        RMSerializable msg = RMHandlerHelper.prepareData(msgQN, outMsgs, fault);
        if (msg != null) {
            msg.serializeTo(soapMessage);
            data.put(msgQN, msg);
            this.log.debug((Object)(msgQN.getLocalPart() + " WSRM message was serialized to payload"));
        }
    }
}

