/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.jaxws.impl;

import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxws.AbstractWrapperGenerator;
import org.jboss.ws.metadata.umdm.FaultMetaData;
import org.jboss.ws.metadata.umdm.OperationMetaData;
import org.jboss.ws.metadata.umdm.ParameterMetaData;
import org.jboss.ws.metadata.umdm.WrappedParameter;
import org.jboss.ws.tools.jaxws.impl.WritableWrapperGenerator;
import org.jboss.wsf.common.JavaUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceWrapperGenerator
extends AbstractWrapperGenerator
implements WritableWrapperGenerator {
    private static Logger log = Logger.getLogger(SourceWrapperGenerator.class);
    private PrintStream stream;
    private JCodeModel codeModel;

    public SourceWrapperGenerator(ClassLoader loader, PrintStream stream) {
        super(loader);
        this.stream = stream;
        this.codeModel = new JCodeModel();
    }

    @Override
    public void reset(ClassLoader loader) {
        super.reset(loader);
        this.codeModel = new JCodeModel();
    }

    @Override
    public void write(File directory) throws IOException {
        this.stream.println("Writing Source:");
        this.codeModel.build(directory, this.stream);
    }

    @Override
    public void generate(ParameterMetaData parameterMD) {
        List<WrappedParameter> wrappedParameters = parameterMD.getWrappedParameters();
        OperationMetaData operationMetaData = parameterMD.getOperationMetaData();
        if (!operationMetaData.isDocumentWrapped()) {
            throw new WSException("Operation is not document/literal (wrapped)");
        }
        if (wrappedParameters == null) {
            throw new WSException("Cannot generate a type when there is no type information");
        }
        String wrapperName = parameterMD.getJavaTypeName();
        log.debug((Object)("Generating wrapper: " + wrapperName));
        try {
            JDefinedClass clazz = this.codeModel._class(wrapperName);
            SourceWrapperGenerator.addClassAnnotations(clazz, parameterMD.getXmlName(), parameterMD.getXmlType(), null);
            for (WrappedParameter wrapped : wrappedParameters) {
                this.addProperty(clazz, wrapped.getType(), wrapped.getName(), wrapped.getVariable(), wrapped.getTypeArguments(), false, wrapped.isXmlList(), wrapped.getAdapter(), this.loader);
            }
        }
        catch (Exception e) {
            throw new WSException("Could not generate wrapper type: " + wrapperName, e);
        }
    }

    @Override
    public void generate(FaultMetaData faultMD) {
        String faultBeanName = faultMD.getFaultBeanName();
        Class exception = faultMD.getJavaType();
        try {
            SortedMap<String, AbstractWrapperGenerator.ExceptionProperty> properties = this.getExceptionProperties(exception);
            String[] propertyOrder = properties.keySet().toArray(new String[0]);
            JDefinedClass clazz = this.codeModel._class(faultBeanName);
            SourceWrapperGenerator.addClassAnnotations(clazz, faultMD.getXmlName(), faultMD.getXmlType(), propertyOrder);
            for (String property : propertyOrder) {
                AbstractWrapperGenerator.ExceptionProperty p = (AbstractWrapperGenerator.ExceptionProperty)properties.get(property);
                this.addProperty(clazz, p.getReturnType().getName(), new QName(property), property, null, p.isTransientAnnotated(), false, null, this.loader);
            }
        }
        catch (Exception e) {
            throw new WSException("Could not generate wrapper type: " + faultBeanName, e);
        }
    }

    private static String getterPrefix(Class<?> type) {
        return Boolean.TYPE == type || Boolean.class == type ? "is" : "get";
    }

    private void addProperty(JDefinedClass clazz, String typeName, QName name, String variable, String[] typeArguments, boolean xmlTransient, boolean xmlList, String adapter, ClassLoader loader) throws Exception {
        Class javaType = JavaUtils.loadJavaType((String)typeName, (ClassLoader)loader);
        if (JavaUtils.isPrimitive((Class)javaType)) {
            SourceWrapperGenerator.addPrimitiveProperty(clazz, javaType, name, variable, xmlTransient);
        } else {
            SourceWrapperGenerator.addProperty(clazz, javaType, name, variable, typeArguments, xmlTransient, xmlList, adapter, this.codeModel);
        }
    }

    private static void addProperty(JDefinedClass clazz, Class<?> javaType, QName name, String variable, String[] typeArguments, boolean xmlTransient, boolean xmlList, String adapter, JCodeModel codeModel) throws Exception {
        String realVariableName = JavaUtils.isReservedKeyword((String)variable) ? "_" + variable : variable;
        JClass type = codeModel.ref(javaType);
        if (typeArguments != null) {
            LinkedList<JClass> jclasses = new LinkedList<JClass>();
            for (String tp : typeArguments) {
                jclasses.add(codeModel.ref(tp));
            }
            type = type.narrow(jclasses);
        }
        JFieldVar field = clazz.field(4, (JType)type, realVariableName);
        if (!xmlTransient) {
            JAnnotationUse annotation = field.annotate(XmlElement.class);
            annotation.param("name", name.getLocalPart());
            if (name.getNamespaceURI() != null) {
                annotation.param("namespace", name.getNamespaceURI());
            }
        } else {
            field.annotate(XmlTransient.class);
        }
        if (xmlList) {
            field.annotate(XmlList.class);
        }
        if (adapter != null) {
            JAnnotationUse xmlJavaTypeAdapter = field.annotate(XmlJavaTypeAdapter.class);
            xmlJavaTypeAdapter.param("value", (JType)codeModel.ref(adapter));
        }
        JMethod method = clazz.method(1, (JType)type, SourceWrapperGenerator.getterPrefix(javaType) + JavaUtils.capitalize((String)variable));
        method.body()._return((JExpression)JExpr._this().ref(realVariableName));
        method = clazz.method(1, Void.TYPE, "set" + JavaUtils.capitalize((String)variable));
        method.body().assign((JAssignmentTarget)JExpr._this().ref(realVariableName), (JExpression)method.param((JType)type, realVariableName));
    }

    private static void addPrimitiveProperty(JDefinedClass clazz, Class<?> javaType, QName name, String variable, boolean xmlTransient) {
        String realVariableName = JavaUtils.isReservedKeyword((String)variable) ? "_" + variable : variable;
        JFieldVar field = clazz.field(4, javaType, realVariableName);
        if (!xmlTransient) {
            JAnnotationUse annotation = field.annotate(XmlElement.class);
            annotation.param("name", name.getLocalPart());
            if (name.getNamespaceURI() != null) {
                annotation.param("namespace", name.getNamespaceURI());
            }
        } else {
            field.annotate(XmlTransient.class);
        }
        JMethod method = clazz.method(1, javaType, SourceWrapperGenerator.getterPrefix(javaType) + JavaUtils.capitalize((String)variable));
        method.body()._return((JExpression)JExpr._this().ref(realVariableName));
        method = clazz.method(1, Void.TYPE, "set" + JavaUtils.capitalize((String)variable));
        method.body().assign((JAssignmentTarget)JExpr._this().ref(realVariableName), (JExpression)method.param(javaType, realVariableName));
    }

    private static void addClassAnnotations(JDefinedClass clazz, QName xmlName, QName xmlType, String[] propertyOrder) {
        JAnnotationUse xmlRootElementAnnotation = clazz.annotate(XmlRootElement.class);
        xmlRootElementAnnotation.param("name", xmlName.getLocalPart());
        String xmlNameNS = xmlName.getNamespaceURI();
        if (xmlNameNS != null && xmlNameNS.length() > 0) {
            xmlRootElementAnnotation.param("namespace", xmlNameNS);
        }
        JAnnotationUse xmlTypeAnnotation = clazz.annotate(XmlType.class);
        xmlTypeAnnotation.param("name", xmlType.getLocalPart());
        String xmlTypeNS = xmlType.getNamespaceURI();
        if (xmlTypeNS != null && xmlTypeNS.length() > 0) {
            xmlTypeAnnotation.param("namespace", xmlTypeNS);
        }
        if (propertyOrder != null) {
            JAnnotationArrayMember paramArray = xmlTypeAnnotation.paramArray("propOrder");
            for (String property : propertyOrder) {
                paramArray.param(property);
            }
        }
        JAnnotationUse xmlAccessorTypeAnnotation = clazz.annotate(XmlAccessorType.class);
        xmlAccessorTypeAnnotation.param("value", (Enum)XmlAccessType.FIELD);
    }
}

