/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.alert;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import org.hibernate.annotations.Cascade;
import org.rhq.core.domain.alert.AlertDampeningEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Embeddable
public class AlertDampening
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="DAMPENING_CATEGORY", nullable=false)
    @Enumerated(value=EnumType.ORDINAL)
    private Category category;
    @Column(name="DAMPENING_VALUE")
    private int value;
    @Column(name="DAMPENING_VALUE_UNITS")
    @Enumerated(value=EnumType.ORDINAL)
    private TimeUnits valueUnits;
    @Column(name="DAMPENING_PERIOD")
    private int period;
    @Column(name="DAMPENING_PERIOD_UNITS")
    @Enumerated(value=EnumType.ORDINAL)
    private TimeUnits periodUnits;
    @OneToMany(mappedBy="alertDefinition", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @JoinColumn(name="ID")
    private Set<AlertDampeningEvent> alertDampeningEvents = new HashSet<AlertDampeningEvent>();

    protected AlertDampening() {
    }

    public AlertDampening(Category category) {
        this.category = category;
    }

    public AlertDampening(AlertDampening alertDampening) {
        this.update(alertDampening);
    }

    public void update(AlertDampening alertDampening) {
        this.clearAlertDampeningEvents();
        this.category = alertDampening.category;
        this.value = alertDampening.value;
        this.valueUnits = alertDampening.valueUnits;
        this.period = alertDampening.period;
        this.periodUnits = alertDampening.periodUnits;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public TimeUnits getValueUnits() {
        return this.valueUnits;
    }

    public void setValueUnits(TimeUnits valueUnits) {
        this.valueUnits = valueUnits;
    }

    public int getPeriod() {
        return this.period;
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public TimeUnits getPeriodUnits() {
        return this.periodUnits;
    }

    public void setPeriodUnits(TimeUnits periodUnits) {
        this.periodUnits = periodUnits;
    }

    public Set<AlertDampeningEvent> getAlertDampeningEvents() {
        return this.alertDampeningEvents;
    }

    public void addAlertDampeningEvent(AlertDampeningEvent alertDampeningEvent) {
        this.getAlertDampeningEvents().add(alertDampeningEvent);
    }

    public void setAlertDampeningEvents(Set<AlertDampeningEvent> alertDampeningEvents) {
        this.alertDampeningEvents = alertDampeningEvents;
    }

    public void clearAlertDampeningEvents() {
        this.alertDampeningEvents.clear();
    }

    public String toString() {
        return "org.rhq.core.domain.alert.AlertDampening[ category=" + (Object)((Object)this.category) + "[" + this.toString(this.category) + "]" + " ]";
    }

    private String toString(Category category) {
        if (category == Category.NONE) {
            return "";
        }
        if (category == Category.PARTIAL_COUNT) {
            return "count=" + this.value + ", " + "collections=" + this.period;
        }
        if (category == Category.DURATION_COUNT) {
            return "count=" + this.value + ", " + "period=" + this.period + " " + (Object)((Object)this.periodUnits);
        }
        if (category == Category.CONSECUTIVE_COUNT) {
            return "count=" + this.value;
        }
        return "<unknown details>";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TimeUnits {
        MINUTES(60L),
        HOURS(MINUTES.getNumberOfSeconds() * 60L),
        DAYS(HOURS.getNumberOfSeconds() * 24L),
        WEEKS(DAYS.getNumberOfSeconds() * 7L);

        private long numberOfSeconds;

        private TimeUnits(long numberOfSeconds) {
            this.numberOfSeconds = numberOfSeconds;
        }

        public long getNumberOfSeconds() {
            return this.numberOfSeconds;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Category {
        NONE,
        CONSECUTIVE_COUNT,
        PARTIAL_COUNT,
        INVERSE_COUNT,
        DURATION_COUNT,
        NO_DUPLICATES,
        ONCE;

    }
}

