/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.content;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.content.ContentSource;
import org.rhq.core.domain.content.DownloadMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@NamedQueries(value={@NamedQuery(name="ContentSourceType.findAll", query="SELECT cst   FROM ContentSourceType cst        LEFT JOIN FETCH cst.contentSourceConfigurationDefinition d        LEFT JOIN FETCH d.templates "), @NamedQuery(name="ContentSourceType.findByNameWithConfigDef", query="SELECT cst   FROM ContentSourceType cst        LEFT JOIN FETCH cst.contentSourceConfigurationDefinition d        LEFT JOIN FETCH d.templates  WHERE cst.name = :name"), @NamedQuery(name="ContentSourceType.findByName", query="SELECT cst   FROM ContentSourceType cst  WHERE cst.name = :name")})
@SequenceGenerator(name="SEQ", sequenceName="RHQ_CONTENT_SOURCE_TYPE_ID_SEQ")
@Table(name="RHQ_CONTENT_SOURCE_TYPE")
public class ContentSourceType
implements Serializable {
    public static final String QUERY_FIND_ALL = "ContentSourceType.findAll";
    public static final String QUERY_FIND_BY_NAME_WITH_CONFIG_DEF = "ContentSourceType.findByNameWithConfigDef";
    public static final String QUERY_FIND_BY_NAME = "ContentSourceType.findByName";
    private static final long serialVersionUID = 1L;
    @Column(name="ID", nullable=false)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SEQ")
    @Id
    private int id;
    @Column(name="NAME", nullable=false)
    private String name;
    @Column(name="DISPLAY_NAME", nullable=true)
    private String displayName;
    @Column(name="DESCRIPTION", nullable=true)
    private String description;
    @Column(name="PLUGIN_NAME", nullable=true)
    private String pluginName;
    @Column(name="DEFAULT_LAZY_LOAD", nullable=false)
    private boolean defaultLazyLoad;
    @Column(name="DEFAULT_DOWNLOAD_MODE", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private DownloadMode defaultDownloadMode = DownloadMode.DATABASE;
    @Column(name="DEFAULT_SYNC_SCHEDULE", nullable=true)
    private String defaultSyncSchedule = "0 0 3 * * ?";
    @JoinColumn(name="SOURCE_CONFIG_DEF_ID", nullable=true)
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @XmlTransient
    private ConfigurationDefinition contentSourceConfigurationDefinition;
    @Column(name="API_CLASS", nullable=false)
    private String contentSourceApiClass;
    @OneToMany(mappedBy="contentSourceType", fetch=FetchType.LAZY)
    private Set<ContentSource> contentSources;

    public ContentSourceType() {
    }

    public ContentSourceType(String name) {
        this.name = name;
        this.contentSourceApiClass = "undefined";
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public boolean isDefaultLazyLoad() {
        return this.defaultLazyLoad;
    }

    public void setDefaultLazyLoad(boolean defaultLazyLoad) {
        this.defaultLazyLoad = defaultLazyLoad;
    }

    public DownloadMode getDefaultDownloadMode() {
        return this.defaultDownloadMode;
    }

    public void setDefaultDownloadMode(DownloadMode defaultDownloadMode) {
        this.defaultDownloadMode = defaultDownloadMode;
    }

    public String getDefaultSyncSchedule() {
        return this.defaultSyncSchedule;
    }

    public void setDefaultSyncSchedule(String syncSchedule) {
        if (syncSchedule != null && syncSchedule.trim().length() == 0) {
            syncSchedule = null;
        }
        this.defaultSyncSchedule = syncSchedule;
    }

    public ConfigurationDefinition getContentSourceConfigurationDefinition() {
        return this.contentSourceConfigurationDefinition;
    }

    public void setContentSourceConfigurationDefinition(ConfigurationDefinition contentSourceConfigurationDefinition) {
        this.contentSourceConfigurationDefinition = contentSourceConfigurationDefinition;
    }

    public String getContentSourceApiClass() {
        return this.contentSourceApiClass;
    }

    public void setContentSourceApiClass(String contentSourceApiClass) {
        this.contentSourceApiClass = contentSourceApiClass;
    }

    public Set<ContentSource> getContentSources() {
        return this.contentSources;
    }

    public void addContentSource(ContentSource contentSource) {
        if (this.contentSources == null) {
            this.contentSources = new HashSet<ContentSource>();
        }
        this.contentSources.add(contentSource);
        contentSource.setContentSourceType(this);
    }

    public void setContentSources(Set<ContentSource> contentSources) {
        this.contentSources = contentSources;
    }

    public String toString() {
        return "ContentSourceType: name=[" + this.name + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof ContentSourceType)) {
            return false;
        }
        ContentSourceType other = (ContentSourceType)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

