/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.metadata;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Date;
import java.util.TreeSet;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public class CachedTabularDataSupport
extends TabularDataSupport
implements Externalizable {
    public CachedTabularDataSupport(TabularType tabularType) {
        super(tabularType);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        TabularType tt = this.getTabularType();
        out.writeLong(this.size());
        CompositeType rowType = tt.getRowType();
        TreeSet<String> columns = new TreeSet<String>(rowType.keySet());
        for (Object d : this.values()) {
            CompositeData data = (CompositeData)d;
            for (String column : columns) {
                OpenType<?> ot = rowType.getType(column);
                if (!(ot instanceof SimpleType)) continue;
                SimpleType st = (SimpleType)ot;
                Object o = data.get(column);
            }
        }
    }

    private void write(ObjectOutput out, SimpleType st, Object o) throws IOException {
        if (st == SimpleType.BIGDECIMAL || st == SimpleType.BIGINTEGER || st == SimpleType.OBJECTNAME) {
            out.writeObject(o);
        } else if (st == SimpleType.BOOLEAN) {
            out.writeBoolean((Boolean)o);
        } else if (st == SimpleType.BYTE) {
            out.writeByte(((Byte)o).byteValue());
        } else if (st == SimpleType.CHARACTER) {
            out.writeChar(((Character)o).charValue());
        } else if (st == SimpleType.DATE) {
            out.writeLong(((Date)o).getTime());
        } else if (st == SimpleType.DOUBLE) {
            out.writeDouble((Double)o);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }
}

