/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.bootstrap;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.LogManager;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import org.jboss.Version;
import org.jboss.bootstrap.BaseServerConfig;
import org.jboss.bootstrap.SecurityActions;
import org.jboss.bootstrap.spi.Bootstrap;
import org.jboss.bootstrap.spi.ServerConfig;
import org.jboss.bootstrap.spi.ServerProcess;
import org.jboss.logging.Logger;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.net.protocol.URLStreamHandlerFactory;
import org.jboss.util.StopWatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractServerImpl
extends NotificationBroadcasterSupport
implements ServerProcess,
NotificationEmitter {
    protected Logger log;
    private final Version version = Version.getInstance();
    private final Package jbossPackage = Package.getPackage("org.jboss");
    private BaseServerConfig config;
    private Map<String, Object> metadata;
    private Date startDate;
    private boolean started;
    private boolean isInStart;
    private boolean isInShutdown;
    private boolean isInternalShutdown;
    private ShutdownHook shutdownHook;
    private LifeThread lifeThread;
    private List<Bootstrap> bootstraps = new CopyOnWriteArrayList<Bootstrap>();
    private List<Bootstrap> startedBootstraps = new CopyOnWriteArrayList<Bootstrap>();

    public void addBootstrap(Bootstrap bootstrap) {
        if (bootstrap == null) {
            throw new IllegalArgumentException("Null bootstrap");
        }
        this.bootstraps.add(bootstrap);
    }

    public void removeBootstrap(Bootstrap bootstrap) {
        if (bootstrap == null) {
            throw new IllegalArgumentException("Null bootstrap");
        }
        this.bootstraps.remove(bootstrap);
    }

    @Override
    public void init(Properties props) throws IllegalStateException, Exception {
        this.init(props, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Properties props, Map<String, Object> metadata) throws IllegalStateException, Exception {
        if (props == null) {
            throw new IllegalArgumentException("props is null");
        }
        if (this.config != null) {
            throw new IllegalStateException("already initialized");
        }
        this.metadata = metadata == null ? Collections.emptyMap() : Collections.unmodifiableMap(metadata);
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.doInit(props);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
        }
    }

    private void doInit(Properties props) throws Exception {
        this.config = new BaseServerConfig(props);
        boolean overrideTmpDir = Boolean.getBoolean("jboss.server.temp.dir.overrideJavaTmpDir");
        if (overrideTmpDir) {
            File serverTmpDir = this.config.getServerTempDir();
            System.setProperty("java.io.tmpdir", serverTmpDir.toString());
        }
        this.config.getServerLogDir();
        this.log = Logger.getLogger(this.getClass());
        this.initURLHandlers();
        this.config.initURLs();
        this.log.info((Object)"Starting JBoss (Microcontainer)...");
        if (this.jbossPackage != null) {
            this.log.info((Object)("Release ID: " + this.jbossPackage.getImplementationTitle() + " " + this.jbossPackage.getImplementationVersion()));
        } else {
            this.log.warn((Object)"could not get package info to display release, either the jar manifest in jboss-system.jar has been mangled or you're running unit tests from ant outside of JBoss itself.");
        }
        this.log.debug((Object)("Using config: " + this.config));
        this.log.debug((Object)("Server type: " + this.getClass()));
        ClassLoader cl = this.getClass().getClassLoader();
        this.log.debug((Object)("Server loaded through: " + cl.getClass().getName()));
        this.log.info((Object)("Bootstrap URL: " + this.config.getBootstrapURL()));
        this.log.info((Object)("Home Dir: " + this.config.getHomeDir()));
        this.log.info((Object)("Home URL: " + this.config.getHomeURL()));
        this.log.info((Object)("Library URL: " + this.config.getLibraryURL()));
        this.log.info((Object)("Patch URL: " + this.config.getPatchURL()));
        this.log.info((Object)("Common Base URL: " + this.config.getCommonBaseURL()));
        this.log.info((Object)("Common Library URL: " + this.config.getCommonLibraryURL()));
        this.log.info((Object)("Server Name: " + this.config.getServerName()));
        this.log.info((Object)("Server Base Dir: " + this.config.getServerBaseDir()));
        this.log.info((Object)("Server Base URL: " + this.config.getServerBaseURL()));
        this.log.info((Object)("Server Config URL: " + this.config.getServerConfigURL()));
        this.log.info((Object)("Server Home Dir: " + this.config.getServerHomeDir()));
        this.log.info((Object)("Server Home URL: " + this.config.getServerHomeURL()));
        this.log.info((Object)("Server Data Dir: " + this.config.getServerDataDir()));
        this.log.info((Object)("Server Library URL: " + this.config.getServerLibraryURL()));
        this.log.info((Object)("Server Log Dir: " + this.config.getServerLogDir()));
        this.log.info((Object)("Server Native Dir: " + this.config.getServerNativeDir()));
        this.log.info((Object)("Server Temp Dir: " + this.config.getServerTempDir()));
        this.log.info((Object)("Server Temp Deploy Dir: " + this.config.getServerTempDeployDir()));
    }

    private void initURLHandlers() {
        if (this.config.getRequireJBossURLStreamHandlerFactory()) {
            this.internalInitURLHandlers();
        } else {
            try {
                this.internalInitURLHandlers();
            }
            catch (SecurityException e) {
                this.log.warn((Object)"You do not have permissions to set URLStreamHandlerFactory", (Throwable)e);
            }
            catch (Error e) {
                this.log.warn((Object)"URLStreamHandlerFactory already set", (Throwable)e);
            }
        }
    }

    private void internalInitURLHandlers() {
        try {
            URL.setURLStreamHandlerFactory((java.net.URLStreamHandlerFactory)new URLStreamHandlerFactory());
            URLStreamHandlerFactory.preload();
        }
        catch (Error error) {
            this.log.warn((Object)"Caught Throwable Error, this probably means we've already set the URLStreamHAndlerFactory before");
        }
        String handlerPkgs = System.getProperty("java.protocol.handler.pkgs");
        handlerPkgs = handlerPkgs != null ? handlerPkgs + "|org.jboss.net.protocol" : "org.jboss.net.protocol";
        System.setProperty("java.protocol.handler.pkgs", handlerPkgs);
    }

    @Override
    @ManagementProperty(managed=true)
    public ServerConfig getConfig() throws IllegalStateException {
        if (this.config == null) {
            throw new IllegalStateException("not initialized");
        }
        return this.config;
    }

    @Override
    public Map<String, Object> getMetaData() {
        return this.metadata;
    }

    public void setMetaData(Map<String, Object> metadata) {
        this.metadata = metadata == null ? Collections.emptyMap() : Collections.unmodifiableMap(metadata);
    }

    void setConfig(BaseServerConfig config) {
        assert (config != null) : "Specified " + ServerConfig.class.getSimpleName() + " was null";
        this.config = config;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    @Override
    public boolean isInShutdown() {
        return this.isInShutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws IllegalStateException, Exception {
        AbstractServerImpl abstractServerImpl = this;
        synchronized (abstractServerImpl) {
            if (this.isInStart) {
                this.log.debug((Object)"Already in start, ignoring duplicate start");
                return;
            }
            this.isInStart = true;
        }
        ServerConfig config = this.getConfig();
        if (this.started) {
            throw new IllegalStateException("already started");
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader myCL = this.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(myCL);
            StopWatch watch = new StopWatch(true);
            this.startDate = new Date();
            this.shutdownHook = new ShutdownHook();
            this.shutdownHook.setDaemon(true);
            try {
                Runtime.getRuntime().addShutdownHook(this.shutdownHook);
                if (this.log != null && this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Shutdown hook added " + this.shutdownHook));
                }
            }
            catch (Exception e) {
                this.log.warn((Object)"Failed to add shutdown hook; ignoring", (Throwable)e);
            }
            this.doStart(watch);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                for (Bootstrap bootstrap : this.bootstraps) {
                    Thread.currentThread().setContextClassLoader(bootstrap.getClass().getClassLoader());
                    this.startedBootstraps.add(0, bootstrap);
                    bootstrap.start(this);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
            if (config.isInstallLifeThread()) {
                this.lifeThread = new LifeThread();
                if (this.log != null && this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Installing life thread " + this.lifeThread));
                }
                this.lifeThread.start();
            }
            this.started = true;
            Notification msg = new Notification("org.jboss.system.server.started", this, 1L);
            msg.setUserData(new Long(watch.getLapTime()));
            this.sendNotification(msg);
            watch.stop();
            if (this.jbossPackage != null) {
                if (this.log != null) {
                    this.log.info((Object)("JBoss (Microcontainer) [" + this.jbossPackage.getImplementationVersion() + "] Started in " + watch));
                }
            } else if (this.log != null) {
                this.log.info((Object)("JBoss (Microcontainer) [unknown version] Started in " + watch));
            }
        }
        catch (Throwable t) {
            if (this.log != null && this.log.isDebugEnabled()) {
                this.log.debug((Object)"Failed to start", t);
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException("Unexpected error", t);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
            this.isInStart = false;
        }
    }

    protected abstract void doStart(StopWatch var1) throws Throwable;

    protected abstract void doShutdown();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownServer() {
        if (this.log != null && this.log.isTraceEnabled()) {
            this.log.trace((Object)"Shutdown caller:", new Throwable("Here"));
        }
        if (this.isInternalShutdown) {
            return;
        }
        this.isInternalShutdown = true;
        Notification msg = new Notification("org.jboss.system.server.stopped", this, 2L);
        this.sendNotification(msg);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            for (Bootstrap bootstrap : this.startedBootstraps) {
                bootstrap.prepareShutdown(this);
            }
            for (Bootstrap bootstrap : this.startedBootstraps) {
                Thread.currentThread().setContextClassLoader(bootstrap.getClass().getClassLoader());
                try {
                    bootstrap.shutdown(this);
                }
                catch (Throwable t) {
                    if (this.log == null) continue;
                    this.log.warn((Object)("Error shutting down bootstrap: " + bootstrap), t);
                }
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        try {
            this.doShutdown();
        }
        finally {
            if (this.log != null) {
                this.log.info((Object)"Shutdown complete");
            }
            System.out.println("Shutdown complete");
        }
    }

    @Override
    public void shutdown() throws IllegalStateException {
        if (this.log != null && this.log.isTraceEnabled()) {
            this.log.trace((Object)"Shutdown caller:", new Throwable("Here"));
        }
        if (!this.started) {
            throw new IllegalStateException("not started");
        }
        if (this.isInShutdown) {
            throw new IllegalStateException("already in shutdown mode");
        }
        this.isInShutdown = true;
        boolean exitOnShutdown = this.config.getExitOnShutdown();
        boolean blockingShutdown = this.config.getBlockingShutdown();
        if (this.log != null) {
            this.log.info((Object)("Shutting down the server, blockingShutdown: " + blockingShutdown));
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("exitOnShutdown: " + exitOnShutdown));
                this.log.debug((Object)("blockingShutdown: " + blockingShutdown));
            }
        }
        if (exitOnShutdown) {
            this.exit(0);
        } else {
            this.lifeThread.interrupt();
            if (blockingShutdown) {
                this.shutdownServer();
            } else {
                new Thread(){

                    public void run() {
                        AbstractServerImpl.this.shutdownServer();
                    }
                }.start();
            }
        }
    }

    @Override
    public void exit(final int exitcode) {
        new Thread(){

            public void run() {
                AbstractServerImpl.this.log.info((Object)("Server exit(" + exitcode + ") called"));
                AbstractServerImpl.this.shutdownHook.setHaltExitCode(exitcode);
                Runtime.getRuntime().exit(exitcode);
            }
        }.start();
    }

    @Override
    public void exit() {
        this.exit(1);
    }

    @Override
    public void halt(final int exitcode) {
        new Thread(){

            public void run() {
                System.err.println("Server halt(" + exitcode + ") called, halting the JVM now!");
                Runtime.getRuntime().halt(exitcode);
            }
        }.start();
    }

    @Override
    public void halt() {
        this.halt(1);
    }

    private void logMemoryUsage(Runtime rt) {
        this.log.info((Object)("Total/free memory: " + rt.totalMemory() + "/" + rt.freeMemory()));
    }

    public void runGarbageCollector() {
        Runtime rt = Runtime.getRuntime();
        this.logMemoryUsage(rt);
        rt.gc();
        this.log.info((Object)"Hinted to the JVM to run garbage collection");
        this.logMemoryUsage(rt);
    }

    public void runFinalization() {
        Runtime.getRuntime().runFinalization();
        this.log.info((Object)"Hinted to the JVM to run any pending object finalizations");
    }

    public void traceMethodCalls(Boolean flag) {
        Runtime.getRuntime().traceMethodCalls(flag);
    }

    public void traceInstructions(Boolean flag) {
        Runtime.getRuntime().traceInstructions(flag);
    }

    @Override
    @ManagementProperty(description="The server start time")
    public Date getStartDate() {
        return this.startDate;
    }

    @Override
    @ManagementProperty(description="The server version string")
    public String getVersion() {
        return this.version.toString();
    }

    @Override
    @ManagementProperty(description="The server version name")
    public String getVersionName() {
        return this.version.getName();
    }

    @Override
    @ManagementProperty(description="The server version number string")
    public String getVersionNumber() {
        return this.version.getVersionNumber();
    }

    @Override
    @ManagementProperty(description="The server build number")
    public String getBuildNumber() {
        return this.version.getBuildNumber();
    }

    @Override
    @ManagementProperty(description="The server build JVM")
    public String getBuildJVM() {
        return this.version.getBuildJVM();
    }

    @Override
    @ManagementProperty(description="The server build OS")
    public String getBuildOS() {
        return this.version.getBuildOS();
    }

    @Override
    @ManagementProperty(description="The server build ID")
    public String getBuildID() {
        return this.version.getBuildID();
    }

    @Override
    @ManagementProperty(description="The server build date")
    public String getBuildDate() {
        return this.version.getBuildDate();
    }

    private class ShutdownHook
    extends Thread {
        private boolean forceHalt;
        private int haltExitCode;

        public ShutdownHook() {
            super("JBoss Shutdown Hook");
            this.forceHalt = true;
            String value = SecurityActions.getSystemProperty("jboss.shutdown.forceHalt", null);
            if (value != null) {
                this.forceHalt = Boolean.valueOf(value);
            }
        }

        public void setHaltExitCode(int haltExitCode) {
            this.haltExitCode = haltExitCode;
        }

        public void run() {
            block3: {
                AbstractServerImpl.this.log.info((Object)("Runtime shutdown hook called, forceHalt: " + this.forceHalt));
                AbstractServerImpl.this.shutdownServer();
                LogManager lm = LogManager.getLogManager();
                try {
                    Class[] sig = new Class[]{};
                    Method doReset = lm.getClass().getDeclaredMethod("doReset", sig);
                    Object[] args = new Object[]{};
                    doReset.invoke((Object)lm, args);
                }
                catch (Exception e) {
                    if (!AbstractServerImpl.this.log.isTraceEnabled()) break block3;
                    AbstractServerImpl.this.log.trace((Object)"No doReset found?", (Throwable)e);
                }
            }
            if (this.forceHalt) {
                System.out.println("Halting VM");
                Runtime.getRuntime().halt(this.haltExitCode);
            }
        }
    }

    private class LifeThread
    extends Thread {
        Object lock;

        LifeThread() {
            super("JBossLifeThread");
            this.lock = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this.lock;
            synchronized (object) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            AbstractServerImpl.this.log.info((Object)"LifeThread.run() exits!");
        }
    }
}

