/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.remoting;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import org.jboss.deployment.spi.JBossTarget;
import org.jboss.deployment.spi.SerializableTargetModuleID;
import org.jboss.deployment.spi.TargetModuleIDImpl;
import org.jboss.logging.Logger;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;

public class StreamingTarget
implements JBossTarget {
    private static final Logger log = Logger.getLogger(StreamingTarget.class);
    public static final String DESCRIPTION = "JBoss remoting streaming deployment target";
    private static final String REMOTING_SUBSYSTEM = "JSR88";
    private URI deployURI;

    public StreamingTarget(URI deployURI) {
        log.debug((Object)("new StreamingTarget: " + deployURI));
        try {
            String localHostName = InetAddress.getLocalHost().getHostName();
            String scheme = deployURI.getScheme();
            String host = deployURI.getHost();
            int port = deployURI.getPort();
            String query = deployURI.getRawQuery();
            String uri = deployURI.toASCIIString();
            if (uri.startsWith("http://org.jboss.deployment/jsr88")) {
                scheme = "socket";
                host = localHostName;
                port = 4446;
                query = null;
            }
            StringBuffer tmp = new StringBuffer(scheme + "://");
            tmp.append(host != null ? host : localHostName);
            tmp.append(port > 0 ? ":" + port : "");
            tmp.append(query != null ? "/?" + query : "");
            deployURI = new URI(tmp.toString());
            log.debug((Object)("URI changed to: " + deployURI));
            this.deployURI = deployURI;
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getName() {
        return this.deployURI.toString();
    }

    public String getHostName() {
        return this.deployURI.getHost();
    }

    public void deploy(TargetModuleID targetModuleID) throws Exception {
        TargetModuleIDImpl moduleID = (TargetModuleIDImpl)targetModuleID;
        SerializableTargetModuleID smoduleID = new SerializableTargetModuleID(moduleID);
        Client client = this.getClient();
        log.info((Object)("Begin deploy: " + moduleID));
        this.transferDeployment(client, smoduleID);
        log.info((Object)"End deploy");
        client.disconnect();
    }

    public void start(TargetModuleID targetModuleID) throws Exception {
        Client client = this.getClient();
        URL url = new URL(targetModuleID.getModuleID());
        log.debug((Object)("Start: " + url));
        HashMap<String, String> args = new HashMap<String, String>(1);
        args.put("moduleID", url.toExternalForm());
        log.info((Object)("Begin start: " + url));
        this.invoke(client, "start", args);
        log.info((Object)"End start");
    }

    public void stop(TargetModuleID targetModuleID) throws Exception {
        Client client = this.getClient();
        URL url = new URL(targetModuleID.getModuleID());
        log.debug((Object)("Start: " + url));
        HashMap<String, String> args = new HashMap<String, String>(1);
        args.put("moduleID", url.toExternalForm());
        log.info((Object)("Begin stop: " + url));
        this.invoke(client, "stop", args);
        log.info((Object)"End stop");
    }

    public void undeploy(TargetModuleID targetModuleID) throws Exception {
        Client client = this.getClient();
        URL url = new URL(targetModuleID.getModuleID());
        log.debug((Object)("Start: " + url));
        HashMap<String, String> args = new HashMap<String, String>(1);
        args.put("moduleID", url.toExternalForm());
        log.info((Object)("Begin undeploy: " + url));
        this.invoke(client, "undeploy", args);
        log.info((Object)"End undeploy");
    }

    public TargetModuleID[] getAvailableModules(ModuleType moduleType) throws TargetException {
        try {
            Client client = this.getClient();
            HashMap<String, Integer> args = new HashMap<String, Integer>(1);
            args.put("moduleType", moduleType.getValue());
            SerializableTargetModuleID[] modules = (SerializableTargetModuleID[])this.invoke(client, "getAvailableModules", args);
            ArrayList<TargetModuleIDImpl> list = new ArrayList<TargetModuleIDImpl>();
            for (int n = 0; n < modules.length; ++n) {
                SerializableTargetModuleID id = modules[n];
                String moduleID = id.getModuleID();
                boolean isRunning = id.isRunning();
                ModuleType type = ModuleType.getModuleType((int)id.getModuleType());
                TargetModuleIDImpl tmid = new TargetModuleIDImpl(this, moduleID, null, isRunning, type);
                this.convertChildren(tmid, id);
                list.add(tmid);
            }
            TargetModuleID[] targetModuleIDs = new TargetModuleID[list.size()];
            list.toArray(targetModuleIDs);
            return targetModuleIDs;
        }
        catch (Exception e) {
            TargetException tex = new TargetException("Failed to get available modules");
            tex.initCause((Throwable)e);
            throw tex;
        }
    }

    private void convertChildren(TargetModuleIDImpl parent, SerializableTargetModuleID parentID) {
        SerializableTargetModuleID[] children = parentID.getChildModuleIDs();
        int length = children != null ? children.length : 0;
        for (int n = 0; n < length; ++n) {
            SerializableTargetModuleID id = children[n];
            String moduleID = id.getModuleID();
            boolean isRunning = id.isRunning();
            ModuleType type = ModuleType.getModuleType((int)id.getModuleType());
            TargetModuleIDImpl child = new TargetModuleIDImpl(this, moduleID, parent, isRunning, type);
            parent.addChildTargetModuleID(child);
            this.convertChildren(child, id);
        }
    }

    private Client getClient() throws Exception {
        String locatorURI = this.deployURI.toString();
        InvokerLocator locator = new InvokerLocator(locatorURI);
        log.debug((Object)("Calling remoting server with locator uri of: " + locatorURI));
        Client remotingClient = new Client(locator, REMOTING_SUBSYSTEM);
        remotingClient.connect();
        return remotingClient;
    }

    private void transferDeployment(Client client, SerializableTargetModuleID smoduleID) throws Exception {
        URL deployURL = new URL(smoduleID.getModuleID());
        InputStream is = deployURL.openStream();
        try {
            client.invoke(is, (Object)smoduleID);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            is.close();
        }
    }

    private Object invoke(Client client, String name, HashMap args) throws Exception {
        try {
            Object returnValue = client.invoke((Object)name, (Map)args);
            return returnValue;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

