/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.services;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.dependency.spi.Controller;
import org.jboss.deployers.client.spi.Deployment;
import org.jboss.deployers.plugins.main.MainDeployerImpl;
import org.jboss.deployers.spi.DeploymentState;
import org.jboss.deployers.structure.spi.DeploymentContext;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.deployers.vfs.spi.client.VFSDeploymentFactory;
import org.jboss.deployment.services.DeploymentManagerServiceMBean;
import org.jboss.deployment.spi.SerializableTargetModuleID;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.system.metadata.ServiceMetaData;
import org.jboss.util.file.Files;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentManagerService
implements DeploymentManagerServiceMBean {
    private static Logger log = Logger.getLogger(DeploymentManagerService.class);
    VFSDeploymentFactory deploymentFactory = VFSDeploymentFactory.getInstance();
    private Map<String, SerializableTargetModuleID> moduleMap = Collections.synchronizedMap(new HashMap());
    private Class carDeployerType;
    private Class earDeployerType;
    private Class ejbDeployerType;
    private Class ejb3DeployerType;
    private Class rarDeployerType;
    private Class warDeployerType;
    private MainDeployerImpl mainDeployer;
    private Controller controller;
    private File uploadDir;
    private boolean failOnCollision;
    private boolean deleteOnUndeploy;

    public static String getDeploymentName(VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        try {
            URI uri = file.toURI();
            return uri.toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("File does not have a valid uri: " + file, e);
        }
    }

    @Override
    public MainDeployerImpl getMainDeployer() {
        return this.mainDeployer;
    }

    @Override
    public void setMainDeployer(MainDeployerImpl mainDeployer) {
        this.mainDeployer = mainDeployer;
    }

    @Override
    public Controller getController() {
        return this.controller;
    }

    @Override
    public void setController(Controller controller) {
        this.controller = controller;
    }

    @Override
    public Class getCarDeployerType() {
        return this.carDeployerType;
    }

    @Override
    public void setCarDeployerType(Class carDeployerType) {
        this.carDeployerType = carDeployerType;
    }

    @Override
    public Class getEarDeployerType() {
        return this.earDeployerType;
    }

    @Override
    public void setEarDeployerType(Class earDeployerType) {
        this.earDeployerType = earDeployerType;
    }

    @Override
    public Class getEjbDeployerType() {
        return this.ejbDeployerType;
    }

    @Override
    public void setEjbDeployerType(Class ejbDeployerType) {
        this.ejbDeployerType = ejbDeployerType;
    }

    @Override
    public Class getEjb3DeployerType() {
        return this.ejb3DeployerType;
    }

    @Override
    public void setEjb3DeployerType(Class ejb3DeployerType) {
        this.ejb3DeployerType = ejb3DeployerType;
    }

    @Override
    public Class getRarDeployerType() {
        return this.rarDeployerType;
    }

    @Override
    public void setRarDeployerType(Class rarDeployerType) {
        this.rarDeployerType = rarDeployerType;
    }

    @Override
    public Class getWarDeployerType() {
        return this.warDeployerType;
    }

    @Override
    public void setWarDeployerType(Class warDeployerType) {
        this.warDeployerType = warDeployerType;
    }

    public void setModuleMap(Map<String, SerializableTargetModuleID> moduleMap) {
        this.moduleMap = moduleMap;
    }

    @Override
    public File getUploadDir() {
        return this.uploadDir;
    }

    @Override
    public void setUploadDir(File uploadDir) {
        this.uploadDir = uploadDir;
    }

    @Override
    public boolean isDeleteOnUndeploy() {
        return this.deleteOnUndeploy;
    }

    @Override
    public void setDeleteOnUndeploy(boolean deleteOnUndeploy) {
        this.deleteOnUndeploy = deleteOnUndeploy;
    }

    @Override
    public boolean isFailOnCollision() {
        return this.failOnCollision;
    }

    @Override
    public void setFailOnCollision(boolean failOnCollision) {
        this.failOnCollision = failOnCollision;
    }

    @Override
    public Map getModuleMap() {
        return Collections.unmodifiableMap(this.moduleMap);
    }

    @Override
    public void deploy(SerializableTargetModuleID moduleID) throws Exception {
        File parentFile;
        String url = moduleID.getModuleID();
        URL deployURL = new URL(url);
        int contentLength = deployURL.openConnection().getContentLength();
        log.debug((Object)("Begin deploy, url: " + deployURL + ", contentLength: " + contentLength));
        File path = new File(deployURL.getFile());
        String archive = path.getName();
        File deployFile = new File(this.uploadDir, archive);
        if (this.failOnCollision && deployFile.exists()) {
            throw new IOException("deployURL(" + deployURL + ") collides with: " + deployFile.getPath());
        }
        if (deployFile.exists()) {
            Files.delete((File)deployFile);
        }
        if (!(parentFile = deployFile.getParentFile()).exists() && !parentFile.mkdirs()) {
            throw new IOException("Failed to create local path: " + parentFile);
        }
        InputStream is = moduleID.getContentIS();
        if (is == null) {
            is = deployURL.openStream();
        }
        BufferedInputStream bis = new BufferedInputStream(is);
        byte[] buffer = new byte[4096];
        FileOutputStream fos = new FileOutputStream(deployFile);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        int count = 0;
        while ((count = bis.read(buffer)) > 0) {
            bos.write(buffer, 0, count);
        }
        bis.close();
        bos.close();
        this.moduleMap.put(url, moduleID);
        this.deploy_phase2(url);
    }

    public void hack(SerializableTargetModuleID moduleID, DeploymentContext info, String method) {
        try {
            String onStr;
            ObjectName objectName;
            Set<ObjectName> mbeans;
            MBeanServer server = MBeanServerLocator.locateJBoss();
            String objNames = this.getComponentName(info);
            String contexts = null;
            if (objNames != null) {
                String token = ":war=";
                int i = objNames.indexOf(token);
                if (i == -1) {
                    return;
                }
                contexts = objNames.substring(i += token.length());
            }
            if ((mbeans = server.queryNames(objectName = new ObjectName(onStr = "*:j2eeType=WebModule,*,J2EEApplication=none,J2EEServer=none"), null)) != null && mbeans.size() > 0 && contexts != null) {
                for (ObjectName inst : mbeans) {
                    String token;
                    String name = inst.toString();
                    if (!name.matches(token = ".*" + contexts + ".*")) continue;
                    server.invoke(inst, method, new Object[0], new String[0]);
                }
            }
        }
        catch (Throwable e) {
            log.info((Object)("hack: failed" + e));
        }
    }

    @Override
    public void start(String url) throws Exception {
        SerializableTargetModuleID moduleID = this.moduleMap.get(url);
        if (moduleID == null) {
            throw new IOException("deployURL(" + url + ") has not been distributed");
        }
        if (moduleID.isRunning()) {
            log.error((Object)("start, url: " + url + " Already started"));
            return;
        }
        URL deployURL = new URL(url);
        File path = new File(deployURL.getFile());
        String archive = path.getName();
        File deployFile = new File(this.uploadDir, archive);
        VirtualFile root = VFS.getRoot((URI)deployFile.toURI());
        Deployment deployment = this.mainDeployer.getDeployment(DeploymentManagerService.getDeploymentName(root));
        if (deployment == null) {
            deployment = this.deploymentFactory.createVFSDeployment(root);
            this.mainDeployer.addDeployment(deployment);
            this.mainDeployer.process();
            moduleID.setRunning(true);
            moduleID.clearChildModuleIDs();
            DeploymentContext context = this.mainDeployer.getDeploymentContext(deployment.getName());
            this.fillChildrenTargetModuleID(moduleID, context);
        }
    }

    private String getComponentName(DeploymentContext context) {
        if (context == null) {
            return null;
        }
        DeploymentUnit u = context.getDeploymentUnit();
        ServiceMetaData data = (ServiceMetaData)u.getAttachment(ServiceMetaData.class);
        if (data == null) {
            return null;
        }
        ObjectName objectName = data.getObjectName();
        return objectName.toString();
    }

    public void deploy_phase2(String url) throws Exception {
        SerializableTargetModuleID moduleID = this.moduleMap.get(url);
        if (moduleID == null) {
            throw new IOException("deployURL(" + url + ") has not been distributed");
        }
        if (moduleID.isRunning()) {
            return;
        }
        URL deployURL = new URL(url);
        File path = new File(deployURL.getFile());
        String archive = path.getName();
        File deployFile = new File(this.uploadDir, archive);
        if (!deployFile.exists()) {
            throw new IOException("deployURL(" + url + ") has no local archive");
        }
        VirtualFile root = VFS.getRoot((URI)deployFile.toURI());
        VFSDeployment deployment = this.deploymentFactory.createVFSDeployment(root);
        this.mainDeployer.addDeployment((Deployment)deployment);
        DeploymentContext context = null;
        try {
            this.mainDeployer.process();
            context = this.mainDeployer.getDeploymentContext(deployment.getName());
            this.mainDeployer.checkComplete(new Deployment[]{deployment});
        }
        catch (Exception e) {
            this.hack(moduleID, context, "destroy");
            moduleID.clearChildModuleIDs();
            this.mainDeployer.removeDeployment(DeploymentManagerService.getDeploymentName(root));
            this.mainDeployer.process();
            if (this.deleteOnUndeploy) {
                Files.delete((File)deployFile);
            }
            this.moduleMap.remove(url);
            throw e;
        }
        moduleID.setRunning(true);
        moduleID.clearChildModuleIDs();
        this.fillChildrenTargetModuleID(moduleID, context);
    }

    @Override
    public void stop(String url) throws Exception {
        SerializableTargetModuleID moduleID = this.moduleMap.get(url);
        if (moduleID == null) {
            throw new IOException("deployURL(" + url + ") has not been distributed");
        }
        URL deployURL = new URL(url);
        File path = new File(deployURL.getFile());
        String archive = path.getName();
        File deployFile = new File(this.uploadDir, archive);
        if (!deployFile.exists()) {
            throw new IOException("deployURL(" + url + ") has no local archive");
        }
        VirtualFile root = VFS.getRoot((URI)deployFile.toURI());
        this.mainDeployer.removeDeployment(DeploymentManagerService.getDeploymentName(root));
        this.mainDeployer.process();
        moduleID.setRunning(false);
    }

    @Override
    public void undeploy(String url) throws Exception {
        URL deployURL;
        File path;
        String archive;
        File deployFile;
        SerializableTargetModuleID moduleID = this.moduleMap.get(url);
        if (moduleID == null) {
            return;
        }
        if (moduleID.isRunning()) {
            this.stop(url);
        }
        if (!(deployFile = new File(this.uploadDir, archive = (path = new File((deployURL = new URL(url)).getFile())).getName())).exists()) {
            throw new IOException("deployURL(" + url + ") has not been distributed");
        }
        if (this.deleteOnUndeploy) {
            Files.delete((File)deployFile);
        }
        this.moduleMap.remove(url);
    }

    @Override
    public SerializableTargetModuleID[] getAvailableModules(int moduleType) throws TargetException {
        ArrayList<SerializableTargetModuleID> matches = new ArrayList<SerializableTargetModuleID>();
        for (SerializableTargetModuleID module : this.moduleMap.values()) {
            if (module.getModuleType() != moduleType) continue;
            matches.add(module);
        }
        SerializableTargetModuleID[] ids = new SerializableTargetModuleID[matches.size()];
        matches.toArray(ids);
        return ids;
    }

    private void fillChildrenTargetModuleID(SerializableTargetModuleID moduleID, DeploymentContext info) {
        List children = info.getChildren();
        for (DeploymentContext ctx : children) {
            try {
                ModuleType type = this.getModuleType(ctx);
                if (type == null) continue;
                String module = ctx.getName();
                boolean isRunning = ctx.getState() == DeploymentState.DEPLOYED;
                SerializableTargetModuleID child = new SerializableTargetModuleID(moduleID, module, type.getValue(), isRunning);
                moduleID.addChildTargetModuleID(child);
                this.fillChildrenTargetModuleID(child, ctx);
            }
            catch (UnsupportedOperationException e) {
                if (!log.isTraceEnabled()) continue;
                log.trace((Object)"Ignoring", (Throwable)e);
            }
        }
    }

    private ModuleType getModuleType(DeploymentContext info) {
        ModuleType type = null;
        DeploymentUnit unit = info.getDeploymentUnit();
        if (unit.getAttachment(this.carDeployerType) != null) {
            type = ModuleType.CAR;
        } else if (unit.getAttachment(this.ejbDeployerType) != null || unit.getAttachment(this.ejb3DeployerType) != null) {
            type = ModuleType.EJB;
        } else if (unit.getAttachment(this.earDeployerType) != null) {
            type = ModuleType.EAR;
        } else if (unit.getAttachment(this.rarDeployerType) != null) {
            type = ModuleType.RAR;
        } else if (unit.getAttachment(this.warDeployerType) != null) {
            type = ModuleType.WAR;
        }
        return type;
    }
}

