/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ws;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import java.util.Set;
import javax.xml.ws.WebServiceRef;
import org.jboss.logging.Logger;
import org.jboss.metadata.annotation.creator.AbstractInjectionTargetProcessor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.creator.ws.WebServiceHandlerChainProcessor;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ServiceReferencesMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractWebServiceRefProcessor<E extends AnnotatedElement>
extends AbstractInjectionTargetProcessor<E> {
    private static Logger log = Logger.getLogger(AbstractWebServiceRefProcessor.class);
    private WebServiceHandlerChainProcessor<E> handlerChainProcessor;

    protected AbstractWebServiceRefProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
        this.handlerChainProcessor = new WebServiceHandlerChainProcessor(finder);
    }

    public void process(ServiceReferencesMetaData refs, E element) {
        WebServiceRef annotation = this.finder.getAnnotation(element, WebServiceRef.class);
        if (annotation == null) {
            return;
        }
        this.process(refs, element, annotation);
    }

    protected void process(ServiceReferencesMetaData refs, E element, WebServiceRef annotation) {
        boolean trace = log.isTraceEnabled();
        String type = annotation.type().getName();
        if (type.equals("java.lang.Object")) {
            type = this.getType(element);
        }
        if (trace) {
            log.trace((Object)("process: " + annotation + ", type=" + type));
        }
        ServiceReferenceMetaData ref = this.createServiceRef(annotation, element);
        this.addReference(refs, ref);
        if (trace) {
            log.trace((Object)("created service-ref: " + ref));
        }
        this.handlerChainProcessor.process(ref, element);
    }

    protected abstract String getName(E var1);

    protected abstract String getInjectionName(E var1);

    protected abstract String getType(E var1);

    protected abstract String getDeclaringClass(E var1);

    protected ServiceReferenceMetaData createServiceRef(WebServiceRef annotation, E element) {
        String injectionName;
        Set<ResourceInjectionTargetMetaData> injectionTargets;
        ServiceReferenceMetaData ref = new ServiceReferenceMetaData();
        String name = annotation.name();
        if (name.length() == 0) {
            name = this.getName(element);
        }
        ref.setServiceRefName(name);
        if (annotation.mappedName().length() > 0) {
            ref.setMappedName(annotation.mappedName());
        }
        ref.setAnnotatedElement((AnnotatedElement)element);
        if (annotation.wsdlLocation().length() > 0) {
            ref.setWsdlFile(annotation.wsdlLocation());
        }
        if (annotation.type() != Object.class) {
            ref.setServiceRefType(annotation.type().getName());
        } else {
            ref.setServiceRefType(this.getType(element));
        }
        if (annotation.value() != Object.class) {
            ref.setServiceInterface(annotation.value().getName());
        }
        if ((injectionTargets = ProcessorUtils.getInjectionTargets(injectionName = this.getInjectionName(element), element)) != null) {
            ref.setInjectionTargets(injectionTargets);
        }
        return ref;
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(WebServiceRef.class);
    }
}

