/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.regex.Pattern;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VirtualFileVisitor;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.context.jar.JarUtils;
import org.jboss.virtual.plugins.context.vfs.AssembledContext;
import org.jboss.virtual.plugins.context.vfs.AssembledDirectoryHandler;
import org.jboss.virtual.plugins.context.vfs.AssembledFileHandler;
import org.jboss.virtual.plugins.context.vfs.ByteArrayHandler;
import org.jboss.virtual.plugins.vfs.helpers.FilterVirtualFileVisitor;
import org.jboss.virtual.plugins.vfs.helpers.SuffixesExcludeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssembledDirectory
extends VirtualFile {
    private static final VirtualFileFilter noJars = new SuffixesExcludeFilter(JarUtils.getSuffixes());
    private AssembledDirectoryHandler directory;

    public AssembledDirectory(AssembledDirectoryHandler handler) {
        super(handler);
        this.directory = handler;
    }

    public static AssembledDirectory createAssembledDirectory(String name, String rootName) throws IOException, URISyntaxException {
        AssembledContext context = new AssembledContext(name, rootName);
        return context.getRoot().getVirtualFile();
    }

    public void addPath(VirtualFile root) throws IOException {
        this.addPath(root, noJars);
    }

    public void addPath(VirtualFile root, VirtualFileFilter recurseFilter) throws IOException {
        final VisitorAttributes va = new VisitorAttributes();
        va.setLeavesOnly(true);
        va.setRecurseFilter(recurseFilter);
        VirtualFileVisitor visitor = new VirtualFileVisitor(){

            public VisitorAttributes getAttributes() {
                return va;
            }

            public void visit(VirtualFile virtualFile) {
                AssembledDirectory.this.mkdirs(virtualFile.getPathName()).addChild(virtualFile);
            }
        };
        root.visit(visitor);
    }

    public void addClass(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null clazz");
        }
        this.addClass(clazz.getName(), clazz.getClassLoader());
    }

    public void addClass(String className) {
        this.addClass(className, Thread.currentThread().getContextClassLoader());
    }

    public void addClass(String className, ClassLoader loader) {
        if (className == null) {
            throw new IllegalArgumentException("Null className");
        }
        if (loader == null) {
            throw new IllegalArgumentException("Null loader");
        }
        String resource = className.replace('.', '/') + ".class";
        URL url = loader.getResource(resource);
        if (url == null) {
            throw new RuntimeException("Could not find resource: " + resource);
        }
        AssembledDirectory p = this.mkdirs(resource);
        p.addResource(resource, loader);
    }

    public AssembledDirectory mkdirs(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        String[] pkgs = path.split("/");
        AssembledDirectoryHandler dir = this.directory;
        for (int i = 0; i < pkgs.length - 1; ++i) {
            AssembledDirectoryHandler next = (AssembledDirectoryHandler)dir.findChild(pkgs[i]);
            if (next == null) {
                try {
                    next = new AssembledDirectoryHandler(dir.getVFSContext(), dir, pkgs[i]);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                dir.addChild(next);
            }
            dir = next;
        }
        return dir.getVirtualFile();
    }

    public void addResources(Class<?> baseResource, String[] includes, String[] excludes) {
        if (baseResource == null) {
            throw new IllegalArgumentException("Null base resource");
        }
        String resource = baseResource.getName().replace('.', '/') + ".class";
        this.addResources(resource, includes, excludes, baseResource.getClassLoader());
    }

    public void addResources(String baseResource, String[] includes, String[] excludes) {
        if (baseResource == null) {
            throw new IllegalArgumentException("Null base resource");
        }
        this.addResources(baseResource, includes, excludes, Thread.currentThread().getContextClassLoader());
    }

    public void addResources(String baseResource, final String[] includes, final String[] excludes, ClassLoader loader) {
        if (baseResource == null) {
            throw new IllegalArgumentException("Null baseResource");
        }
        if (loader == null) {
            throw new IllegalArgumentException("Null loader");
        }
        URL url = loader.getResource(baseResource);
        if (url == null) {
            throw new RuntimeException("Could not find baseResource: " + baseResource);
        }
        String urlString = url.toString();
        int idx = urlString.lastIndexOf(baseResource);
        urlString = urlString.substring(0, idx);
        try {
            url = new URL(urlString);
            VirtualFile parent = VFS.getRoot(url);
            VisitorAttributes va = new VisitorAttributes();
            va.setLeavesOnly(true);
            va.setRecurseFilter(noJars);
            VirtualFileFilter filter = new VirtualFileFilter(){

                public boolean accepts(VirtualFile file) {
                    boolean matched = false;
                    String path = file.getPathName();
                    for (String include : includes) {
                        if (!AssembledDirectory.antMatch(path, include)) continue;
                        matched = true;
                        break;
                    }
                    if (!matched) {
                        return false;
                    }
                    if (excludes != null) {
                        for (String exclude : excludes) {
                            if (!AssembledDirectory.antMatch(path, exclude)) continue;
                            return false;
                        }
                    }
                    return true;
                }
            };
            FilterVirtualFileVisitor visitor = new FilterVirtualFileVisitor(filter, va);
            parent.visit(visitor);
            List<VirtualFile> files = visitor.getMatched();
            for (VirtualFile vf : files) {
                this.mkdirs(vf.getPathName()).addChild(vf);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Pattern getPattern(String matcher) {
        if (matcher == null) {
            throw new IllegalArgumentException("Null matcher");
        }
        matcher = matcher.replace(".", "\\.");
        matcher = matcher.replace("*", ".*");
        matcher = matcher.replace("?", ".{1}");
        return Pattern.compile(matcher);
    }

    public static boolean antMatch(String path, String expression) {
        int p;
        if (path == null) {
            throw new IllegalArgumentException("Null path");
        }
        if (expression == null) {
            throw new IllegalArgumentException("Null expression");
        }
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (expression.endsWith("/")) {
            expression = expression + "**";
        }
        String[] paths = path.split("/");
        String[] expressions = expression.split("/");
        int x = 0;
        Pattern pattern = AssembledDirectory.getPattern(expressions[0]);
        for (p = 0; p < paths.length && x < expressions.length; ++p) {
            String element;
            if (expressions[x].equals("**")) {
                while (++x < expressions.length && expressions[x].equals("**")) {
                }
                if (x == expressions.length) {
                    return true;
                }
                pattern = AssembledDirectory.getPattern(expressions[x]);
            }
            if (pattern.matcher(element = paths[p]).matches()) {
                if (++x >= expressions.length) continue;
                pattern = AssembledDirectory.getPattern(expressions[x]);
                continue;
            }
            if (x > 0 && expressions[x - 1].equals("**")) continue;
            return false;
        }
        if (p < paths.length) {
            return false;
        }
        return x >= expressions.length;
    }

    public VirtualFile addChild(VirtualFile vf) {
        if (vf == null) {
            throw new IllegalArgumentException("Null virtual file");
        }
        return this.directory.addChild(vf.getHandler()).getVirtualFile();
    }

    public VirtualFile addChild(VirtualFile vf, String newName) {
        try {
            AssembledFileHandler handler = new AssembledFileHandler(this.directory.getVFSContext(), this.directory, newName, vf.getHandler());
            this.directory.addChild(handler);
            return handler.getVirtualFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public VirtualFile addResource(String resource) {
        return this.addResource(resource, Thread.currentThread().getContextClassLoader());
    }

    public VirtualFile addResource(String resource, String newName) {
        return this.addResource(resource, Thread.currentThread().getContextClassLoader(), newName);
    }

    public VirtualFile addResource(String resource, ClassLoader loader) {
        if (resource == null) {
            throw new IllegalArgumentException("Null resource");
        }
        if (loader == null) {
            throw new IllegalArgumentException("Null loader");
        }
        URL url = loader.getResource(resource);
        if (url == null) {
            throw new RuntimeException("Could not find resource: " + resource);
        }
        return this.addResource(url);
    }

    public VirtualFile addResource(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("Null url");
        }
        try {
            VirtualFile vf = VFS.getRoot(url);
            return this.addChild(vf);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public VirtualFile addResource(String resource, ClassLoader loader, String newName) {
        if (resource == null) {
            throw new IllegalArgumentException("Null resource");
        }
        if (loader == null) {
            throw new IllegalArgumentException("Null loader");
        }
        if (newName == null) {
            throw new IllegalArgumentException("Null newName");
        }
        URL url = loader.getResource(resource);
        if (url == null) {
            throw new RuntimeException("Could not find resource: " + resource);
        }
        try {
            VirtualFile vf = VFS.getRoot(url);
            return this.addChild(vf, newName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public VirtualFile addBytes(byte[] bytes, String name) {
        ByteArrayHandler handler;
        if (bytes == null) {
            throw new IllegalArgumentException("Null bytes");
        }
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        try {
            handler = new ByteArrayHandler(this.directory.getVFSContext(), this.directory, name, bytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.directory.addChild(handler);
        return handler.getVirtualFile();
    }

    public AssembledDirectory mkdir(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        try {
            AssembledDirectoryHandler handler = new AssembledDirectoryHandler(this.directory.getVFSContext(), this.directory, name);
            this.directory.addChild(handler);
            return new AssembledDirectory(handler);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

