/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.zip;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.virtual.plugins.context.AbstractContextFactory;
import org.jboss.virtual.plugins.context.zip.ZipEntryContext;
import org.jboss.virtual.spi.VFSContext;

public class ZipEntryContextFactory
extends AbstractContextFactory {
    private static ZipEntryContextFactory instance = new ZipEntryContextFactory();

    public ZipEntryContextFactory() {
        super("zip", "vfszip");
    }

    public VFSContext getVFS(URI rootURI) throws IOException {
        return this.getVFS(rootURI.toURL());
    }

    public VFSContext getVFS(URL rootURL) throws IOException {
        try {
            return new ZipEntryContext(rootURL);
        }
        catch (URISyntaxException ex) {
            MalformedURLException e = new MalformedURLException("Failed to convert URL to URI: " + rootURL);
            e.initCause(ex);
            throw e;
        }
    }

    public static ZipEntryContextFactory getInstance() {
        return instance;
    }
}

