/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.recovery;

import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.recovery.RecoveryManager;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.arjuna.recovery.Service;
import com.arjuna.ats.internal.arjuna.recovery.Listener;
import com.arjuna.ats.internal.arjuna.recovery.WorkerService;
import java.io.IOException;
import java.net.ServerSocket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class PeriodicRecovery
extends Thread {
    private static Vector _recoveryModules;
    private static int _backoffPeriod;
    private static int _recoveryPeriod;
    private static final int _defaultBackoffPeriod = 10;
    private static final int _defaultRecoveryPeriod = 120;
    private static final Object _stateLock;
    private static int _currentStatus;
    private static int _currentMode;
    private boolean _workerScanRequested;
    private static SimpleDateFormat _theTimestamper;
    private static ServerSocket _socket;
    private static final Object _socketLock;
    private static Listener _listener;
    private static WorkerService _workerService;

    public PeriodicRecovery(boolean threaded, boolean useListener) {
        block8: {
            this._workerScanRequested = false;
            this.initialise();
            PeriodicRecovery.loadModules();
            if (useListener) {
                try {
                    _workerService = new WorkerService(this);
                    _listener = new Listener(PeriodicRecovery.getServerSocket(), (Service)_workerService);
                    _listener.setDaemon(true);
                    if (tsLogger.arjLoggerI18N.isInfoEnabled()) {
                        tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_13", new Object[]{_socket.getInetAddress().getHostAddress(), _socket.getLocalPort()});
                    }
                }
                catch (Exception ex) {
                    if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block8;
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_9", new Object[]{ex});
                }
            }
        }
        if (threaded) {
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: starting background scanner thread");
            }
            this.start();
        }
        if (useListener) {
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: starting listener worker thread");
            }
            _listener.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean async) {
        Object object = _stateLock;
        synchronized (object) {
            if (this.getMode() != 2) {
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: Mode <== TERMINATED");
                }
                this.setMode(2);
                _stateLock.notifyAll();
            }
            if (!async) {
                while (this.getStatus() == 1) {
                    try {
                        if (tsLogger.arjLogger.isDebugEnabled()) {
                            tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: shutdown waiting for scan to end");
                        }
                        _stateLock.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: shutdown scan wait complete");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendScan(boolean async) {
        Object object = _stateLock;
        synchronized (object) {
            if (this.getMode() == 0) {
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: Mode <== SUSPENDED");
                }
                this.setMode(1);
                _stateLock.notifyAll();
            }
            if (!async) {
                while (this.getStatus() == 1) {
                    try {
                        if (tsLogger.arjLogger.isDebugEnabled()) {
                            tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: suspendScan waiting for scan to end");
                        }
                        _stateLock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!tsLogger.arjLogger.isDebugEnabled()) continue;
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: suspendScan scan wait compelete");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeScan() {
        Object object = _stateLock;
        synchronized (object) {
            if (this.getMode() == 1) {
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: Mode <== ENABLED");
                }
                this.setMode(0);
                _stateLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerSocket getServerSocket() throws IOException {
        Object object = _socketLock;
        synchronized (object) {
            if (_socket == null) {
                _socket = new ServerSocket(RecoveryManager.getRecoveryManagerPort(), 50, RecoveryManager.getRecoveryManagerHost());
            }
            return _socket;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean finished = false;
        do {
            boolean workToDo = false;
            Object object = _stateLock;
            synchronized (object) {
                if (this.getStatus() == 1) {
                    if (tsLogger.arjLogger.isDebugEnabled()) {
                        tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: background thread waiting on other scan");
                    }
                    this.doScanningWait();
                    if (this.getMode() == 0) {
                        if (tsLogger.arjLogger.isDebugEnabled()) {
                            tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: background thread backing off");
                        }
                        this.doPeriodicWait();
                        finished = this.getMode() == 2;
                    }
                } else {
                    switch (this.getMode()) {
                        case 0: {
                            if (tsLogger.arjLogger.isDebugEnabled()) {
                                tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: background thread Status <== SCANNING");
                            }
                            this.setStatus(1);
                            _stateLock.notifyAll();
                            workToDo = true;
                            break;
                        }
                        case 1: {
                            if (tsLogger.arjLogger.isDebugEnabled()) {
                                tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: background thread wait while SUSPENDED");
                            }
                            this.doSuspendedWait();
                            finished = this.getMode() == 2;
                            break;
                        }
                        case 2: {
                            finished = true;
                        }
                    }
                }
            }
            if (!workToDo) continue;
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: background thread scanning");
            }
            this.doWorkInternal();
            object = _stateLock;
            synchronized (object) {
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: background thread Status <== INACTIVE");
                }
                this.setStatus(0);
                _stateLock.notifyAll();
                this.notifyWorker();
                if (this.getMode() == 0) {
                    if (tsLogger.arjLogger.isDebugEnabled()) {
                        tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: background thread backing off");
                    }
                    this.doPeriodicWait();
                }
                finished = this.getMode() == 2;
            }
        } while (!finished);
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: background thread exiting");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doWork() {
        boolean workToDo = false;
        Object object = _stateLock;
        synchronized (object) {
            if (this.getMode() == 1) {
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: ad hoc thread wait while SUSPENDED");
                }
                this.doSuspendedWait();
            }
            if (this.getMode() == 2) {
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: ad hoc thread scan TERMINATED");
                }
            } else if (this.getStatus() == 1) {
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: ad hoc thread waiting on other scan");
                }
                this.doScanningWait();
            } else {
                this.setStatus(1);
                _stateLock.notifyAll();
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: ad hoc thread Status <== SCANNING");
                }
                workToDo = true;
            }
        }
        if (workToDo) {
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: ad hoc thread scanning");
            }
            this.doWorkInternal();
            object = _stateLock;
            synchronized (object) {
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: ad hoc thread Status <== INACTIVE");
                }
                this.setStatus(0);
                _stateLock.notifyAll();
                this.notifyWorker();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        Object object = _stateLock;
        synchronized (object) {
            this._workerScanRequested = true;
            if (this.getStatus() != 1) {
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: listener worker interrupts background thread");
                }
                this.interrupt();
            }
        }
    }

    public final void addModule(RecoveryModule module) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: adding module " + module.getClass().getName());
        }
        _recoveryModules.add(module);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeModule(RecoveryModule module, boolean waitOnScan) {
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: removing module " + module.getClass().getName());
        }
        _recoveryModules.remove(module);
        if (waitOnScan) {
            Object object = _stateLock;
            synchronized (object) {
                this.doScanningWait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Vector getModules() {
        Vector vector = _recoveryModules;
        synchronized (vector) {
            return new Vector(_recoveryModules);
        }
    }

    private int getStatus() {
        return _currentStatus;
    }

    private int getMode() {
        return _currentMode;
    }

    private void setStatus(int status) {
        _currentStatus = status;
    }

    private void setMode(int mode) {
        _currentMode = mode;
    }

    private void doBackoffWait() {
        try {
            _stateLock.wait(_backoffPeriod * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void doPeriodicWait() {
        try {
            _stateLock.wait(_recoveryPeriod * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void doSuspendedWait() {
        while (this.getMode() == 1) {
            try {
                _stateLock.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void doScanningWait() {
        while (this.getStatus() == 1) {
            try {
                _stateLock.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWorkInternal() {
        ClassLoader cl;
        Object m;
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("Periodic recovery - first pass <" + _theTimestamper.format(new Date()) + ">");
        }
        Enumeration modules = this.getModules().elements();
        while (modules.hasMoreElements()) {
            m = (RecoveryModule)modules.nextElement();
            cl = this.switchClassLoader((RecoveryModule)m);
            try {
                m.periodicWorkFirstPass();
            }
            finally {
                this.restoreClassLoader(cl);
            }
            if (!tsLogger.arjLogger.isDebugEnabled()) continue;
            tsLogger.arjLogger.debug(16L, 4L, 2048L, " ");
        }
        m = _stateLock;
        synchronized (m) {
            this.doBackoffWait();
            if (this.getMode() == 2) {
                if (tsLogger.arjLogger.isDebugEnabled()) {
                    tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: scan TERMINATED at phase 1");
                }
                return;
            }
        }
        if (tsLogger.arjLogger.isDebugEnabled()) {
            tsLogger.arjLogger.debug("Periodic recovery - second pass <" + _theTimestamper.format(new Date()) + ">");
        }
        modules = _recoveryModules.elements();
        while (modules.hasMoreElements()) {
            m = (RecoveryModule)modules.nextElement();
            cl = this.switchClassLoader((RecoveryModule)m);
            try {
                m.periodicWorkSecondPass();
            }
            finally {
                this.restoreClassLoader(cl);
            }
            if (!tsLogger.arjLogger.isDebugEnabled()) continue;
            tsLogger.arjLogger.debug(16L, 4L, 2048L, " ");
        }
    }

    private void notifyWorker() {
        if (this._workerScanRequested) {
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug(16L, 4L, 2048L, "PeriodicRecovery: scan thread signals listener worker");
            }
            if (_workerService != null) {
                _workerService.signalDone();
            }
            this._workerScanRequested = false;
        }
    }

    private ClassLoader switchClassLoader(RecoveryModule rm) {
        Thread currentThread = Thread.currentThread();
        ClassLoader cl = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(rm.getClass().getClassLoader());
        return cl;
    }

    private void restoreClassLoader(ClassLoader cl) {
        Thread currentThread = Thread.currentThread();
        currentThread.setContextClassLoader(cl);
    }

    private static void loadModules() {
        Properties properties = arjPropertyManager.propertyManager.getProperties();
        if (properties != null) {
            String attrName;
            Vector<String> moduleNames = new Vector<String>();
            Enumeration<Object> names = properties.propertyNames();
            while (names.hasMoreElements()) {
                int position;
                attrName = (String)names.nextElement();
                if (!attrName.startsWith("com.arjuna.ats.arjuna.recovery.recoveryExtension")) continue;
                for (position = 0; position < moduleNames.size() && attrName.compareTo((String)moduleNames.elementAt(position)) > 0; ++position) {
                }
                moduleNames.add(position, attrName);
            }
            names = moduleNames.elements();
            while (names.hasMoreElements()) {
                attrName = (String)names.nextElement();
                PeriodicRecovery.loadModule(properties.getProperty(attrName));
            }
        }
    }

    private static void loadModule(String className) {
        block12: {
            if (tsLogger.arjLogger.isDebugEnabled()) {
                tsLogger.arjLogger.debug(16L, 1L, 2048L, "Loading recovery module " + className);
            }
            if (className == null) {
                if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_1");
                }
                return;
            }
            try {
                Class<?> c;
                block11: {
                    c = Thread.currentThread().getContextClassLoader().loadClass(className);
                    try {
                        RecoveryModule m = (RecoveryModule)c.newInstance();
                        _recoveryModules.add(m);
                    }
                    catch (ClassCastException e) {
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_2", new Object[]{className});
                        }
                    }
                    catch (IllegalAccessException iae) {
                        if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                            tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_3", new Object[]{iae});
                        }
                    }
                    catch (InstantiationException ie) {
                        if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block11;
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_4", new Object[]{ie});
                    }
                }
                c = null;
            }
            catch (ClassNotFoundException cnfe) {
                if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block12;
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_5", new Object[]{className});
            }
        }
    }

    private void initialise() {
        _recoveryModules = new Vector();
        this.setStatus(0);
        this.setMode(0);
    }

    static {
        block9: {
            block8: {
                _recoveryModules = null;
                _backoffPeriod = 0;
                _recoveryPeriod = 0;
                _stateLock = new Object();
                _theTimestamper = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss");
                _socket = null;
                _socketLock = new Object();
                _listener = null;
                _workerService = null;
                _recoveryPeriod = 120;
                String recoveryPeriodString = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.recovery.periodicRecoveryPeriod");
                if (recoveryPeriodString != null) {
                    try {
                        Integer recoveryPeriodInteger = new Integer(recoveryPeriodString);
                        _recoveryPeriod = recoveryPeriodInteger;
                        if (tsLogger.arjLogger.isDebugEnabled()) {
                            tsLogger.arjLogger.debug(16L, 1L, 2048L, "com.arjuna.ats.arjuna.recovery.PeriodicRecovery: Recovery period set to " + _recoveryPeriod + " seconds");
                        }
                    }
                    catch (NumberFormatException e) {
                        if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block8;
                        tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_6", new Object[]{"com.arjuna.ats.arjuna.recovery.periodicRecoveryPeriod", recoveryPeriodString});
                    }
                }
            }
            _backoffPeriod = 10;
            String backoffPeriodString = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.recovery.recoveryBackoffPeriod");
            if (backoffPeriodString != null) {
                try {
                    Integer backoffPeriodInteger = new Integer(backoffPeriodString);
                    _backoffPeriod = backoffPeriodInteger;
                    if (tsLogger.arjLogger.isDebugEnabled()) {
                        tsLogger.arjLogger.debug(16L, 1L, 2048L, "PeriodicRecovery: Backoff period set to " + _backoffPeriod + " seconds");
                    }
                }
                catch (NumberFormatException e) {
                    if (!tsLogger.arjLoggerI18N.isWarnEnabled()) break block9;
                    tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.PeriodicRecovery_7", new Object[]{"com.arjuna.ats.arjuna.recovery.recoveryBackoffPeriod", backoffPeriodString});
                }
            }
        }
    }

    public class Mode {
        public static final int ENABLED = 0;
        public static final int SUSPENDED = 1;
        public static final int TERMINATED = 2;

        private Mode() {
        }
    }

    public class Status {
        public static final int INACTIVE = 0;
        public static final int SCANNING = 1;

        private Status() {
        }
    }
}

