/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.alert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AlertConditionCategory {
    AVAILABILITY("Resource Availability"),
    THRESHOLD("Measurement Threshold"),
    BASELINE("Measurement Baseline"),
    CHANGE("Measurement Value Change"),
    TRAIT("Measurement Trait"),
    CONTROL("Control Action"),
    ALERT("Alert Fired"),
    RESOURCE_CONFIG("Resource Configuration Property Value Change"),
    EVENT("Log Event");

    private static final AlertConditionCategory[] legacyOrder;
    private final String displayName;

    public static AlertConditionCategory make(int legacyIndex) {
        return legacyOrder[legacyIndex - 1];
    }

    private AlertConditionCategory(String displayName) {
        this.displayName = displayName;
    }

    public String getName() {
        return this.name();
    }

    public String toString() {
        return this.displayName;
    }

    static {
        legacyOrder = new AlertConditionCategory[]{THRESHOLD, BASELINE, CONTROL, CHANGE, ALERT, RESOURCE_CONFIG, EVENT};
    }
}

