/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.domain.measurement;

import java.io.Serializable;
import java.text.DecimalFormat;
import org.rhq.core.domain.measurement.MeasurementData;
import org.rhq.core.domain.measurement.MeasurementDataPK;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.measurement.NumericType;

public class MeasurementDataNumeric
extends MeasurementData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Double value;
    private transient NumericType rawNumericType;

    protected MeasurementDataNumeric() {
    }

    public MeasurementDataNumeric(MeasurementScheduleRequest request, Double value) {
        super(request);
        this.value = value;
        this.rawNumericType = request.getRawNumericType();
    }

    public MeasurementDataNumeric(long collectionTime, MeasurementScheduleRequest request, Double value) {
        super(collectionTime, request);
        this.value = value;
        this.rawNumericType = request.getRawNumericType();
    }

    @Deprecated
    public MeasurementDataNumeric(MeasurementDataPK md, Double value) {
        super(md);
        this.value = value;
    }

    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public boolean isPerMinuteCollection() {
        return this.rawNumericType != null;
    }

    public NumericType getRawNumericType() {
        return this.rawNumericType;
    }

    public String toString() {
        return "MeasurementDataNumeric[value=[" + new DecimalFormat("0.00").format(this.value) + "], " + super.toString() + "]";
    }
}

