/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.navtree;

import java.applet.Applet;
import java.awt.Component;
import java.net.URL;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import org.jboss.console.manager.interfaces.SimpleTreeNodeMenuEntry;
import org.jboss.console.manager.interfaces.TreeAction;
import org.jboss.console.manager.interfaces.impl.HttpLinkTreeAction;
import org.jboss.console.navtree.AdminTreeBrowser;
import org.jboss.console.navtree.AppletTreeAction;
import org.jboss.console.navtree.MainAppletStub;
import org.jboss.console.navtree.TreeContext;
import org.jboss.console.remote.AppletRemoteMBeanInvoker;
import org.jboss.console.remote.SimpleRemoteMBeanInvoker;

public class AppletBrowser
extends JApplet {
    AdminTreeBrowser treeBrowser = null;
    AppletAdminContext ctx = null;
    public static final String RIGHT_FRAME_NAME = "right";
    protected String sessionId = null;
    protected String pmJmxName = null;

    public void start() {
        try {
            this.ctx = new AppletAdminContext();
            this.initAppletParams();
            this.treeBrowser = new AdminTreeBrowser(this.ctx);
            this.initComponents();
            this.initRefreshThread();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void refreshTree(boolean force) {
        this.treeBrowser.refreshTree(force);
    }

    protected void initAppletParams() {
        this.sessionId = this.getParameter("SessionId");
        this.sessionId = this.sessionId != null ? "jsessionid=" + this.sessionId : "";
        this.pmJmxName = this.getParameter("PMJMXName");
        if (this.pmJmxName == null) {
            this.pmJmxName = "jboss.admin:service=PluginManager";
        }
    }

    protected void initComponents() {
        JTree tree = this.treeBrowser.getTree();
        JScrollPane scrollPane = new JScrollPane(tree);
        scrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.getContentPane().add((Component)scrollPane, "Center");
    }

    protected void initRefreshThread() {
        try {
            String strRefreshSec = this.getParameter("RefreshTime");
            if (strRefreshSec != null && !"".equals(strRefreshSec)) {
                final long refresh = Long.parseLong(strRefreshSec);
                Thread t = new Thread(new Runnable(){

                    public synchronized void run() {
                        long timeout = refresh * 1000L;
                        while (true) {
                            try {
                                while (true) {
                                    this.wait(timeout);
                                    AppletBrowser.this.treeBrowser.refreshTree(false);
                                }
                            }
                            catch (Exception exception) {
                                continue;
                            }
                            break;
                        }
                    }
                });
                t.start();
            }
        }
        catch (Exception displayed) {
            displayed.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        AppletBrowser applet = new AppletBrowser();
        applet.setStub(new MainAppletStub());
        JFrame frame = new JFrame("Administration Console");
        frame.getContentPane().add(applet);
        frame.setSize(600, 500);
        frame.setDefaultCloseOperation(3);
        applet.init();
        ((Applet)applet).start();
        frame.setVisible(true);
    }

    public class AppletAdminContext
    implements TreeContext {
        String webHost = null;
        String hostname = null;
        SimpleRemoteMBeanInvoker invoker = null;

        public AppletAdminContext() {
            URL root = AppletBrowser.this.getCodeBase();
            this.webHost = root.getProtocol() + ":";
            if (root.getAuthority() != null && root.getAuthority().length() > 0) {
                this.webHost = this.webHost + "//";
                this.webHost = this.webHost + root.getAuthority();
            }
            if (!this.webHost.endsWith("/")) {
                this.webHost = this.webHost + "/";
            }
            this.hostname = AppletBrowser.this.getCodeBase().getHost();
        }

        public synchronized SimpleRemoteMBeanInvoker getRemoteMBeanInvoker() {
            if (this.invoker == null) {
                System.out.println(AppletBrowser.this.getCodeBase().toString() + "Invoker");
                try {
                    this.invoker = new AppletRemoteMBeanInvoker(AppletBrowser.this.getCodeBase().toString() + "Invoker");
                }
                catch (Exception displayed) {
                    displayed.printStackTrace();
                }
            }
            return this.invoker;
        }

        public void doAdminTreeAction(TreeAction action) {
            if (action != null && action instanceof HttpLinkTreeAction) {
                HttpLinkTreeAction act = (HttpLinkTreeAction)action;
                this.openLink(act.getTarget(), act.getFrame());
            }
        }

        public void doPopupMenuAction(SimpleTreeNodeMenuEntry entry) {
            TreeAction ta = entry.getAction();
            if (ta instanceof HttpLinkTreeAction) {
                HttpLinkTreeAction act = (HttpLinkTreeAction)ta;
                this.openLink(act.getTarget(), act.getFrame());
            } else if (ta instanceof AppletTreeAction) {
                ((AppletTreeAction)ta).doAction(AppletBrowser.this.ctx, AppletBrowser.this);
            }
        }

        public Properties getJndiProperties() {
            Properties props = new Properties();
            props.setProperty("java.naming.factory.initial", "org.jnp.interfaces.NamingContextFactory");
            props.setProperty("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
            props.setProperty("java.naming.provider.url", this.hostname);
            return props;
        }

        public String getServiceJmxName() {
            return AppletBrowser.this.pmJmxName;
        }

        public void openLink(String target, String frame) {
            try {
                if (target == null) {
                    return;
                }
                System.out.println(target);
                if (frame == null) {
                    AppletBrowser.this.getAppletContext().showDocument(new URL(this.localizeUrl(target)), AppletBrowser.RIGHT_FRAME_NAME);
                } else {
                    AppletBrowser.this.getAppletContext().showDocument(new URL(this.localizeUrl(target)), frame);
                }
            }
            catch (Exception tobad) {
                tobad.printStackTrace();
            }
        }

        public String localizeUrl(String sourceUrl) {
            String target = sourceUrl;
            if (target == null) {
                return null;
            }
            if (!target.toLowerCase().startsWith("http")) {
                if (target.startsWith("/")) {
                    target = target.substring(1);
                }
                target = (target = this.webHost + target).indexOf("?") >= 0 ? target + "&" + AppletBrowser.this.sessionId : target + ";" + AppletBrowser.this.sessionId;
            }
            return target;
        }
    }
}

