/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.pluginapi.util.FileUtils;
import org.rhq.core.system.ProcessInfo;
import org.rhq.plugins.jbossas5.ApplicationServerComponent;
import org.rhq.plugins.jbossas5.connection.LocalProfileServiceConnectionProvider;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.rhq.plugins.jbossas5.helper.JBossInstallationInfo;
import org.rhq.plugins.jbossas5.helper.JBossInstanceInfo;
import org.rhq.plugins.jbossas5.util.JnpConfig;
import org.rhq.plugins.jbossas5.util.ManagedComponentUtils;
import org.rhq.plugins.jbossas5.util.PluginDescriptorGenerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationServerDiscoveryComponent
implements ResourceDiscoveryComponent {
    private static final String DEFAULT_RESOURCE_DESCRIPTION = "JBoss Application Server";
    private static final String JBMANCON_DEBUG_SYSPROP = "jbmancon.debug";
    private static final String CHANGE_ME = "***CHANGE_ME***";
    private static final String JBOSS_SERVICE_XML = "conf" + File.separator + "jboss-service.xml";
    private static final String JBOSS_NAMING_SERVICE_XML = "deploy" + File.separator + "naming-service.xml";
    private static final String ANY_ADDRESS = "0.0.0.0";
    private static final String LOCALHOST = "127.0.0.1";
    private static final String JAVA_HOME_ENV_VAR = "JAVA_HOME";
    private static final ComparableVersion MINIMUM_VERSION = new ComparableVersion("5.1.0.CR1");
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext discoveryContext) {
        this.log.trace((Object)("Discovering " + discoveryContext.getResourceType().getName() + " Resources..."));
        HashSet<DiscoveredResourceDetails> resources = new HashSet<DiscoveredResourceDetails>();
        List manuallyAddedJBossAsPluginConfigs = discoveryContext.getPluginConfigurations();
        if (!manuallyAddedJBossAsPluginConfigs.isEmpty()) {
            Configuration pluginConfig = (Configuration)manuallyAddedJBossAsPluginConfigs.get(0);
            DiscoveredResourceDetails manuallyAddedJBossAS = this.createDetailsForManuallyAddedJBossAS(discoveryContext, pluginConfig);
            resources.add(manuallyAddedJBossAS);
        } else {
            DiscoveredResourceDetails inProcessJBossAS = this.discoverInProcessJBossAS(discoveryContext);
            if (inProcessJBossAS != null) {
                resources.add(inProcessJBossAS);
            } else {
                resources.addAll(this.discoverExternalJBossAsProcesses(discoveryContext));
            }
        }
        this.log.trace((Object)("Discovered " + resources.size() + " " + discoveryContext.getResourceType().getName() + " Resources."));
        return resources;
    }

    private Set<DiscoveredResourceDetails> discoverExternalJBossAsProcesses(ResourceDiscoveryContext discoveryContext) {
        HashSet<DiscoveredResourceDetails> resources = new HashSet<DiscoveredResourceDetails>();
        List autoDiscoveryResults = discoveryContext.getAutoDiscoveredProcesses();
        for (ProcessScanResult autoDiscoveryResult : autoDiscoveryResults) {
            File configDir;
            File installHome;
            JBossInstallationInfo installInfo;
            JBossInstanceInfo cmdLine;
            ProcessInfo processInfo;
            block9: {
                processInfo = autoDiscoveryResult.getProcessInfo();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Discovered JBossAS process: " + processInfo));
                }
                try {
                    cmdLine = new JBossInstanceInfo(processInfo);
                }
                catch (Exception e) {
                    this.log.error((Object)("Failed to process JBossAS command line: " + Arrays.asList(processInfo.getCommandLine())), (Throwable)e);
                    continue;
                }
                installInfo = cmdLine.getInstallInfo();
                ComparableVersion version = new ComparableVersion(installInfo.getVersion());
                if (version.compareTo((Object)MINIMUM_VERSION) < 0) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("JBAS version " + version + " is not supported by this plugin (minimum version is " + MINIMUM_VERSION + ") - skipping..."));
                    continue;
                }
                installHome = new File(cmdLine.getSystemProperties().getProperty("jboss.home.dir"));
                configDir = new File(cmdLine.getSystemProperties().getProperty("jboss.server.home.dir"));
                try {
                    if (!configDir.getCanonicalFile().isDirectory()) {
                        this.log.warn((Object)("Skipping discovery for process " + processInfo + ", because JBAS configuration dir '" + configDir + "' does not exist or is not a directory."));
                    }
                    break block9;
                }
                catch (IOException e) {
                    this.log.error((Object)("Skipping discovery for process " + processInfo + ", because JBAS configuration dir '" + configDir + "' could not be canonicalized."), (Throwable)e);
                }
                continue;
            }
            Configuration pluginConfiguration = discoveryContext.getDefaultPluginConfiguration();
            String jnpURL = ApplicationServerDiscoveryComponent.getJnpURL(cmdLine, installHome, configDir);
            pluginConfiguration.put((Property)new PropertySimple("namingURL", (Object)jnpURL));
            pluginConfiguration.put((Property)new PropertySimple("homeDir", (Object)installHome.getAbsolutePath()));
            pluginConfiguration.put((Property)new PropertySimple("serverHomeDir", (Object)configDir));
            pluginConfiguration.put((Property)new PropertySimple("serverName", (Object)cmdLine.getSystemProperties().getProperty("jboss.server.name")));
            pluginConfiguration.put((Property)new PropertySimple("bindAddress", (Object)cmdLine.getSystemProperties().getProperty("jboss.bind.address")));
            String javaHome = processInfo.getEnvironmentVariable(JAVA_HOME_ENV_VAR);
            if (javaHome == null && this.log.isDebugEnabled()) {
                this.log.debug((Object)"JAVA_HOME environment variable not set in JBossAS process - defaulting javaHomeconnection property to the plugin container JRE dir.");
                javaHome = System.getenv(JAVA_HOME_ENV_VAR);
            }
            pluginConfiguration.put((Property)new PropertySimple("javaHome", (Object)javaHome));
            this.initLogEventSourcesConfigProp(configDir, pluginConfiguration);
            DiscoveredResourceDetails resourceDetails = this.createResourceDetails(discoveryContext, pluginConfiguration, processInfo, installInfo);
            resources.add(resourceDetails);
        }
        return resources;
    }

    private DiscoveredResourceDetails createDetailsForManuallyAddedJBossAS(ResourceDiscoveryContext discoveryContext, Configuration pluginConfig) {
        JBossInstallationInfo installInfo;
        ProcessInfo processInfo = null;
        String jbossHomeDir = pluginConfig.getSimple("homeDir").getStringValue();
        try {
            installInfo = new JBossInstallationInfo(new File(jbossHomeDir));
        }
        catch (IOException e) {
            throw new InvalidPluginConfigurationException((Throwable)e);
        }
        DiscoveredResourceDetails resourceDetails = this.createResourceDetails(discoveryContext, pluginConfig, processInfo, installInfo);
        return resourceDetails;
    }

    @Nullable
    private DiscoveredResourceDetails discoverInProcessJBossAS(ResourceDiscoveryContext discoveryContext) {
        JBossInstallationInfo installInfo;
        ProfileServiceConnection connection;
        LocalProfileServiceConnectionProvider connectionProvider = new LocalProfileServiceConnectionProvider();
        try {
            connection = connectionProvider.connect();
        }
        catch (Exception e) {
            this.log.debug((Object)("Unable to connect to in-process ProfileService: " + e));
            return null;
        }
        ManagementView managementView = connection.getManagementView();
        ManagedComponent serverConfigComponent = ManagedComponentUtils.getSingletonManagedComponent(managementView, new ComponentType("MCBean", "ServerConfig"));
        String serverName = (String)((Object)ManagedComponentUtils.getSimplePropertyValue(serverConfigComponent, "serverName"));
        String resourceKey = (String)((Object)ManagedComponentUtils.getSimplePropertyValue(serverConfigComponent, "serverHomeDir"));
        String homeDir = (String)((Object)ManagedComponentUtils.getSimplePropertyValue(serverConfigComponent, "homeDir"));
        try {
            installInfo = new JBossInstallationInfo(new File(homeDir));
        }
        catch (IOException e) {
            throw new InvalidPluginConfigurationException((Throwable)e);
        }
        String resourceName = "JBoss ";
        resourceName = resourceName + (installInfo.isEap() ? "EAP " : "AS ");
        resourceName = resourceName + installInfo.getMajorVersion();
        resourceName = resourceName + " (" + serverName + ")";
        String version = (String)((Object)ManagedComponentUtils.getSimplePropertyValue(serverConfigComponent, "specificationVersion"));
        Configuration pluginConfig = discoveryContext.getDefaultPluginConfiguration();
        pluginConfig.put((Property)new PropertySimple("serverName", (Object)serverName));
        pluginConfig.put((Property)new PropertySimple("homeDir", (Object)homeDir));
        boolean debug = Boolean.getBoolean(JBMANCON_DEBUG_SYSPROP);
        if (debug) {
            this.generatePluginDescriptor(discoveryContext, connection);
        }
        return new DiscoveredResourceDetails(discoveryContext.getResourceType(), resourceKey, resourceName, version, DEFAULT_RESOURCE_DESCRIPTION, pluginConfig, null);
    }

    private DiscoveredResourceDetails createResourceDetails(ResourceDiscoveryContext discoveryContext, Configuration pluginConfiguration, @Nullable ProcessInfo processInfo, JBossInstallationInfo installInfo) {
        boolean isRhqServer;
        String port;
        String serverHomeDir = pluginConfiguration.getSimple("serverHomeDir").getStringValue();
        File absoluteConfigPath = ApplicationServerComponent.resolvePathRelativeToHomeDir(pluginConfiguration, serverHomeDir);
        String key = FileUtils.getCanonicalPath((String)absoluteConfigPath.getPath());
        String bindAddress = pluginConfiguration.getSimple("bindAddress").getStringValue();
        String namingUrl = pluginConfiguration.getSimple("namingURL").getStringValue();
        String namingPort = null;
        int colonIndex = namingUrl.lastIndexOf(58);
        if (colonIndex != -1 && colonIndex != namingUrl.length() - 1 && !(port = namingUrl.substring(colonIndex + 1)).equals(CHANGE_ME)) {
            namingPort = port;
        }
        String configName = absoluteConfigPath.getName();
        String baseName = discoveryContext.getSystemInformation().getHostname();
        String description = installInfo.getProductType().DESCRIPTION;
        File deployDir = new File(absoluteConfigPath, "deploy");
        File rhqInstallerWar = new File(deployDir, "rhq-installer.war");
        File rhqInstallerWarUndeployed = new File(deployDir, "rhq-installer.war.rej");
        boolean bl = isRhqServer = rhqInstallerWar.exists() || rhqInstallerWarUndeployed.exists();
        if (isRhqServer) {
            baseName = baseName + " RHQ Server, ";
            description = description + " hosting the RHQ Server";
            this.configureEventSourceForServerLogFile(pluginConfiguration);
        }
        String name = this.formatServerName(baseName, bindAddress, namingPort, configName, installInfo);
        return new DiscoveredResourceDetails(discoveryContext.getResourceType(), key, name, installInfo.getVersion(), description, pluginConfiguration, processInfo);
    }

    private String formatServerName(String baseName, String bindingAddress, String jnpPort, String configName, JBossInstallationInfo installInfo) {
        baseName = baseName + " " + installInfo.getProductType().NAME + " " + installInfo.getVersion() + " " + configName;
        String details = null;
        if (bindingAddress != null && jnpPort != null && !jnpPort.equals(CHANGE_ME)) {
            details = bindingAddress + ":" + jnpPort;
        } else if (bindingAddress == null && jnpPort != null && !jnpPort.equals(CHANGE_ME)) {
            details = jnpPort;
        } else if (bindingAddress != null) {
            details = bindingAddress;
        }
        return baseName + (details != null ? " (" + details + ")" : "");
    }

    private void configureEventSourceForServerLogFile(Configuration pluginConfiguration) {
        File rhqLogFile = ApplicationServerComponent.resolvePathRelativeToHomeDir(pluginConfiguration, "../logs/rhq-server-log4j.log");
        if (rhqLogFile.exists() && !rhqLogFile.isDirectory()) {
            try {
                PropertyMap serverLogEventSource = new PropertyMap("serverLog");
                serverLogEventSource.put((Property)new PropertySimple("logFilePath", (Object)rhqLogFile.getCanonicalPath()));
                serverLogEventSource.put((Property)new PropertySimple("enabled", (Object)Boolean.FALSE));
                serverLogEventSource.put((Property)new PropertySimple("minimumSeverity", (Object)"info"));
                PropertyList logEventSources = pluginConfiguration.getList("logEventSources");
                logEventSources.add((Property)serverLogEventSource);
            }
            catch (IOException e) {
                this.log.warn((Object)"Unable to setup RHQ Server log file monitoring.", (Throwable)e);
            }
        }
    }

    private static String getJnpURL(JBossInstanceInfo cmdLine, File installHome, File configDir) {
        JnpConfig jnpConfig;
        String jnpAddress;
        String path = cmdLine.getSystemProperties().getProperty("jboss.server.name") + "/data/jnp-service.url";
        File urlStore = new File(path);
        if (urlStore.exists() && urlStore.canRead()) {
            try {
                BufferedReader br = new BufferedReader(new FileReader(urlStore));
                String jnpUrl = br.readLine();
                if (jnpUrl != null) {
                    return jnpUrl;
                }
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        String string = jnpAddress = (jnpConfig = ApplicationServerDiscoveryComponent.getJnpConfig(installHome, configDir, cmdLine.getSystemProperties())).getJnpAddress() != null ? jnpConfig.getJnpAddress() : CHANGE_ME;
        if (jnpAddress.equals(ANY_ADDRESS)) {
            jnpAddress = LOCALHOST;
        }
        String jnpPort = jnpConfig.getJnpPort() != null ? String.valueOf(jnpConfig.getJnpPort()) : CHANGE_ME;
        return "jnp://" + jnpAddress + ":" + jnpPort;
    }

    private static JnpConfig getJnpConfig(File installHome, File configDir, Properties props) {
        File namingServiceFile;
        File serviceXML = new File(configDir, JBOSS_SERVICE_XML);
        JnpConfig config = JnpConfig.getConfig(installHome, serviceXML, props);
        if ((config == null || config.getJnpPort() == null) && (namingServiceFile = new File(configDir, JBOSS_NAMING_SERVICE_XML)).exists()) {
            config = JnpConfig.getConfig(installHome, namingServiceFile, props);
        }
        return config;
    }

    private void initLogEventSourcesConfigProp(File configDir, Configuration pluginConfig) {
        File logDir = new File(configDir, "log");
        File serverLogFile = new File(logDir, "server.log");
        if (serverLogFile.exists() && !serverLogFile.isDirectory()) {
            PropertyMap serverLogEventSource = new PropertyMap("serverLog");
            serverLogEventSource.put((Property)new PropertySimple("logFilePath", (Object)serverLogFile));
            serverLogEventSource.put((Property)new PropertySimple("enabled", (Object)Boolean.FALSE));
            PropertyList logEventSources = pluginConfig.getList("logEventSources");
            logEventSources.add((Property)serverLogEventSource);
        }
    }

    private void generatePluginDescriptor(ResourceDiscoveryContext discoveryContext, ProfileServiceConnection connection) {
        this.log.info((Object)"Generating RHQ plugin descriptor...");
        try {
            ManagementView managementView = connection.getManagementView();
            File tempDir = discoveryContext.getParentResourceContext().getTemporaryDirectory();
            PluginDescriptorGenerator.generatePluginDescriptor(managementView, tempDir);
        }
        catch (Exception e) {
            this.log.error((Object)"Failed to generate RHQ plugin descriptor.", (Throwable)e);
        }
    }
}

