/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.plugin;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.Nullable;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.clientapi.agent.metadata.PluginDependencyGraph;
import org.rhq.core.clientapi.agent.metadata.PluginMetadataManager;
import org.rhq.core.clientapi.descriptor.AgentPluginDescriptorUtil;
import org.rhq.core.clientapi.descriptor.plugin.PluginDescriptor;
import org.rhq.core.pc.ContainerService;
import org.rhq.core.pc.PluginContainerConfiguration;
import org.rhq.core.pc.plugin.PluginClassLoader;
import org.rhq.core.pc.plugin.PluginDescriptorLoader;
import org.rhq.core.pc.plugin.PluginEnvironment;
import org.rhq.core.pc.plugin.PluginFinder;
import org.rhq.core.pluginapi.plugin.PluginContext;
import org.rhq.core.pluginapi.plugin.PluginLifecycleListener;
import org.rhq.core.system.SystemInfo;
import org.rhq.core.system.SystemInfoFactory;
import org.rhq.core.util.exception.ThrowableUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginManager
implements ContainerService {
    private static final Log log = LogFactory.getLog(PluginManager.class);
    private Map<String, PluginEnvironment> loadedPluginEnvironments;
    private List<String> loadedPlugins;
    private Map<String, PluginLifecycleListener> pluginLifecycleListenerCache;
    private PluginMetadataManager metadataManager;
    private PluginContainerConfiguration configuration;

    @Override
    public void initialize() {
        block11: {
            this.loadedPluginEnvironments = new HashMap<String, PluginEnvironment>();
            this.loadedPlugins = new ArrayList<String>();
            this.pluginLifecycleListenerCache = new HashMap<String, PluginLifecycleListener>();
            this.metadataManager = new PluginMetadataManager();
            PluginFinder finder = this.configuration.getPluginFinder();
            File tmpDir = this.configuration.getTemporaryDirectory();
            try {
                if (finder != null) {
                    ArrayList<PluginDependencyGraph.PluginDependency> dependencies;
                    Collection<URL> pluginUrls = finder.findPlugins();
                    HashMap<String, URL> pluginNamesUrls = new HashMap<String, URL>();
                    PluginDependencyGraph graph = new PluginDependencyGraph();
                    for (URL url : pluginUrls) {
                        PluginDescriptor descriptor;
                        log.debug((Object)("Plugin found at: " + url));
                        try {
                            descriptor = AgentPluginDescriptorUtil.loadPluginDescriptorFromUrl((URL)url);
                        }
                        catch (Throwable t) {
                            log.error((Object)("Plugin at [" + url + "] could not be loaded and will therefore not be deployed."), t);
                            continue;
                        }
                        String pluginName = descriptor.getName();
                        dependencies = new ArrayList<PluginDependencyGraph.PluginDependency>();
                        for (PluginDescriptor.Depends dependency : descriptor.getDepends()) {
                            dependencies.add(new PluginDependencyGraph.PluginDependency(dependency.getPlugin(), dependency.isUseClasses()));
                        }
                        graph.addPlugin(pluginName, dependencies);
                        pluginNamesUrls.put(pluginName, url);
                    }
                    List deploymentOrder = graph.getDeploymentOrder();
                    for (String nextPlugin : deploymentOrder) {
                        URL pluginUrl = (URL)pluginNamesUrls.get(nextPlugin);
                        dependencies = graph.getPluginDependencies(nextPlugin);
                        try {
                            if (dependencies.size() == 0) {
                                log.debug((Object)("Loading independent plugin [" + nextPlugin + "] from URL: " + pluginUrl));
                                this.loadPlugin(pluginUrl, null);
                                continue;
                            }
                            log.debug((Object)("Loading dependent plugin [" + nextPlugin + "] from URL [" + pluginUrl + "] that has the following dependencies: " + dependencies));
                            String lastDependency = graph.getUseClassesDependency(nextPlugin);
                            PluginEnvironment lastDepEnvironment = this.loadedPluginEnvironments.get(lastDependency);
                            String pluginJarName = new File(pluginUrl.getPath()).getName();
                            ClassLoader classloader = lastDepEnvironment.getPluginClassLoader();
                            this.loadPlugin(pluginUrl, PluginClassLoader.create(pluginJarName, pluginUrl, true, classloader, tmpDir));
                        }
                        catch (Throwable t) {
                            log.error((Object)("Plugin [" + nextPlugin + "] at [" + pluginUrl + "] could not be loaded and will therefore not be deployed."), t);
                        }
                    }
                    break block11;
                }
                log.info((Object)"Loading the null plugin which uses non-isolated classloader");
                this.loadPlugin(null, null);
            }
            catch (Exception e) {
                this.shutdown();
                log.error((Object)"Error initializing plugin container", (Throwable)e);
                throw new RuntimeException("Cannot initialize the plugin container", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        Collections.reverse(this.loadedPlugins);
        for (String pluginName : this.loadedPlugins) {
            PluginLifecycleListener listener = this.pluginLifecycleListenerCache.get(pluginName);
            if (listener == null) continue;
            try {
                ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.loadedPluginEnvironments.get(pluginName).getPluginClassLoader());
                try {
                    listener.shutdown();
                }
                finally {
                    Thread.currentThread().setContextClassLoader(originalCL);
                }
            }
            catch (Throwable t) {
                log.warn((Object)("Failed to get lifecycle listener to shutdown [" + pluginName + "]. Cause: " + ThrowableUtil.getAllMessages((Throwable)t)));
            }
        }
        for (PluginEnvironment pluginEnvironment : this.loadedPluginEnvironments.values()) {
            pluginEnvironment.destroy();
        }
        this.loadedPluginEnvironments.clear();
        this.loadedPluginEnvironments = null;
        this.loadedPlugins.clear();
        this.loadedPlugins = null;
        this.pluginLifecycleListenerCache.clear();
        this.pluginLifecycleListenerCache = null;
        this.metadataManager = null;
    }

    @Override
    public void setConfiguration(PluginContainerConfiguration configuration) {
        this.configuration = configuration;
    }

    public Collection<PluginEnvironment> getPlugins() {
        return this.loadedPluginEnvironments.values();
    }

    @Nullable
    public PluginEnvironment getPlugin(String name) {
        return this.loadedPluginEnvironments.get(name);
    }

    public PluginMetadataManager getMetadataManager() {
        return this.metadataManager;
    }

    private void loadPlugin(URL pluginUrl, ClassLoader classLoader) throws PluginContainerException {
        log.debug((Object)("Loading plugin from: " + pluginUrl));
        PluginDescriptorLoader pluginDescriptorLoader = new PluginDescriptorLoader(pluginUrl, classLoader, null, true, this.configuration.getTemporaryDirectory());
        PluginDescriptor pluginDescriptor = pluginDescriptorLoader.loadPluginDescriptor();
        PluginEnvironment pluginEnvironment = new PluginEnvironment(pluginDescriptor.getName(), pluginDescriptorLoader);
        String pluginName = pluginEnvironment.getPluginName();
        PluginLifecycleListener overseer = this.getPluginLifecycleListener(pluginName, pluginEnvironment, pluginDescriptor);
        if (overseer != null) {
            PluginContext context = this.createPluginContext(pluginName);
            ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(pluginEnvironment.getPluginClassLoader());
            try {
                overseer.initialize(context);
            }
            catch (Throwable t) {
                throw new PluginContainerException("Plugin Lifecycle Listener failed to initialize plugin", t);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCL);
            }
            this.pluginLifecycleListenerCache.put(pluginName, overseer);
        }
        this.loadedPluginEnvironments.put(pluginName, pluginEnvironment);
        this.metadataManager.loadPlugin(pluginDescriptor);
        this.loadedPlugins.add(pluginName);
    }

    private PluginLifecycleListener getPluginLifecycleListener(String pluginName, PluginEnvironment pluginEnvironment, PluginDescriptor pluginDescriptor) throws PluginContainerException {
        String className;
        PluginLifecycleListener instance = this.pluginLifecycleListenerCache.get(pluginName);
        if (instance == null && (className = this.getPluginLifecycleListenerClass(pluginDescriptor)) != null) {
            log.debug((Object)("Creating plugin lifecycle listener [" + className + "] for plugin [" + pluginName + "]"));
            instance = (PluginLifecycleListener)this.instantiateClass(pluginEnvironment, className);
            log.debug((Object)("Created plugin lifecycle listener [" + className + "] for plugin [" + pluginName + "]"));
        }
        return instance;
    }

    private String getPluginLifecycleListenerClass(PluginDescriptor pluginDescriptor) {
        String className = pluginDescriptor.getPluginLifecycleListener();
        if (className != null) {
            String pkg = pluginDescriptor.getPackage();
            if (className.indexOf(46) == -1 && pkg != null) {
                className = pkg + '.' + className;
            }
        }
        return className;
    }

    private PluginContext createPluginContext(String pluginName) {
        SystemInfo sysInfo = SystemInfoFactory.createSystemInfo();
        File dataDir = new File(this.configuration.getDataDirectory(), pluginName);
        File tmpDir = this.configuration.getTemporaryDirectory();
        String pcName = this.configuration.getContainerName();
        PluginContext context = new PluginContext(pluginName, sysInfo, tmpDir, dataDir, pcName);
        return context;
    }

    private Object instantiateClass(PluginEnvironment environment, String className) throws PluginContainerException {
        ClassLoader loader = environment.getPluginClassLoader();
        log.debug((Object)("Loading class: " + className));
        try {
            Class<?> clazz = Class.forName(className, true, loader);
            log.debug((Object)("Loaded class: " + clazz));
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new PluginContainerException("Could not instantiate plugin class [" + className + "] from plugin environment [" + environment + "]", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new PluginContainerException("Could not access plugin class " + className + "] from plugin environment [" + environment + "]", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new PluginContainerException("Could not find plugin class " + className + "] from plugin environment [" + environment + "]", (Throwable)e);
        }
        catch (NullPointerException npe) {
            throw new PluginContainerException("Plugin class was 'null' in plugin environment [" + environment + "]", (Throwable)npe);
        }
    }

    private void getDependentUrls(String pluginName, Map<String, URL> pluginNamesUrls, PluginDependencyGraph graph, Set<URL> allUrls) {
        List deps = graph.getPluginDependencies(pluginName);
        for (String dep : deps) {
            this.getDependentUrls(dep, pluginNamesUrls, graph, allUrls);
            allUrls.add(pluginNamesUrls.get(dep));
        }
    }
}

