/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.management.ObjectName;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkManager;
import org.jboss.deployment.DeploymentException;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.ObjectModelFactorySimpleSubDeployerSupport;
import org.jboss.resource.deployment.JBossRAObjectModelFactory;
import org.jboss.resource.deployment.RARDeployerMBean;
import org.jboss.resource.deployment.RARDeployment;
import org.jboss.resource.deployment.ResourceAdapterObjectModelFactory;
import org.jboss.resource.metadata.ConnectorMetaData;
import org.jboss.resource.metadata.JBossRAMetaData;
import org.jboss.resource.metadata.RARDeploymentMetaData;
import org.jboss.xb.binding.ObjectModelFactory;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;

public class RARDeployer
extends ObjectModelFactorySimpleSubDeployerSupport
implements RARDeployerMBean {
    private static final String JBOSS_RA_XML = "META-INF/jboss-ra.xml";
    protected ObjectName workManagerName;
    protected WorkManager workManager;
    protected XATerminator xaTerminator;
    protected ObjectName xaTerminatorName;

    public RARDeployer() {
        this.setEnhancedSuffixes(new String[]{"250:.rar"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseMetaData(DeploymentInfo di, URL url) throws DeploymentException {
        super.parseMetaData(di, url);
        InputStream is = di.localCl.getResourceAsStream(JBOSS_RA_XML);
        RARDeploymentMetaData rdmd = new RARDeploymentMetaData();
        rdmd.setConnectorMetaData((ConnectorMetaData)di.metaData);
        di.metaData = rdmd;
        try {
            if (is != null) {
                Unmarshaller unmarshaller = UnmarshallerFactory.newInstance().newUnmarshaller();
                ObjectModelFactory factory = this.getExtendedObjectModelFactory();
                JBossRAMetaData ramd = (JBossRAMetaData)unmarshaller.unmarshal(is, factory, (Object)null);
                rdmd.setRaXmlMetaData(ramd);
            }
        }
        catch (Throwable t) {
            DeploymentException.rethrowAsDeploymentException((String)("Error parsing meta data " + url), (Throwable)t);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public String getExtension() {
        return ".rar";
    }

    public String getMetaDataURL() {
        return "META-INF/ra.xml";
    }

    public String getObjectName(DeploymentInfo di) throws DeploymentException {
        String name = di.shortName;
        di = di.parent;
        while (di != null) {
            name = di.shortName + "#" + name;
            di = di.parent;
        }
        return "jboss.jca:service=RARDeployment,name='" + name + "'";
    }

    public String getDeploymentClass() {
        return RARDeployment.class.getName();
    }

    public ObjectModelFactory getObjectModelFactory() {
        return new ResourceAdapterObjectModelFactory();
    }

    @Override
    public ObjectName getWorkManagerName() {
        return this.workManagerName;
    }

    @Override
    public void setWorkManagerName(ObjectName workManagerName) {
        this.workManagerName = workManagerName;
    }

    @Override
    public ObjectName getXATerminatorName() {
        return this.xaTerminatorName;
    }

    @Override
    public void setXATerminatorName(ObjectName xaTerminatorName) {
        this.xaTerminatorName = xaTerminatorName;
    }

    protected void startService() throws Exception {
        this.workManager = (WorkManager)this.server.getAttribute(this.workManagerName, "Instance");
        this.xaTerminator = (XATerminator)this.server.getAttribute(this.xaTerminatorName, "XATerminator");
        super.startService();
    }

    private ObjectModelFactory getExtendedObjectModelFactory() {
        return new JBossRAObjectModelFactory();
    }
}

