/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session;

import java.util.Map;
import java.util.WeakHashMap;
import org.apache.catalina.Manager;

public class SessionInvalidationTracker {
    private static final ThreadLocal<Map<Manager, String>> invalidatedSessions = new ThreadLocal();
    private static final ThreadLocal<Boolean> suspended = new ThreadLocal();

    public static void suspend() {
        suspended.set(Boolean.TRUE);
    }

    public static void resume() {
        suspended.set(null);
    }

    public static void sessionInvalidated(String id, Manager manager) {
        if (Boolean.TRUE != suspended.get()) {
            Map<Manager, String> map = invalidatedSessions.get();
            if (map == null) {
                map = new WeakHashMap<Manager, String>(2);
                invalidatedSessions.set(map);
            }
            map.put(manager, id);
        }
    }

    public static void clearInvalidatedSession(String id, Manager manager) {
        Map<Manager, String> map = invalidatedSessions.get();
        if (map != null) {
            map.remove(manager);
        }
    }

    public static boolean isSessionInvalidated(String id, Manager manager) {
        boolean result = false;
        Map<Manager, String> map = invalidatedSessions.get();
        if (map != null) {
            result = id.equals(map.get(manager));
        }
        return result;
    }
}

