/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.clientapi.server.configuration;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;

public class ConfigurationUpdateResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int configurationUpdateId;
    private Configuration configuration;
    private ConfigurationUpdateStatus status;
    private String errorMessage;

    public ConfigurationUpdateResponse(int configurationUpdateId, Configuration configuration, ConfigurationUpdateStatus status, String errorMessage) {
        this.configurationUpdateId = configurationUpdateId;
        this.configuration = configuration;
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public ConfigurationUpdateResponse(int configurationUpdateId, Configuration configuration, Throwable t) {
        this.configurationUpdateId = configurationUpdateId;
        this.configuration = configuration;
        this.setErrorMessageFromThrowable(t);
    }

    public int getConfigurationUpdateId() {
        return this.configurationUpdateId;
    }

    public void setConfigurationUpdateId(int configurationUpdateId) {
        this.configurationUpdateId = configurationUpdateId;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public ConfigurationUpdateStatus getStatus() {
        return this.status;
    }

    public void setStatus(ConfigurationUpdateStatus status) {
        this.status = status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorMessage != null) {
            this.setStatus(ConfigurationUpdateStatus.FAILURE);
        }
    }

    public void setErrorMessageFromThrowable(Throwable t) {
        if (t != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            t.printStackTrace(new PrintStream(baos));
            this.setErrorMessage(baos.toString());
        } else {
            this.setErrorMessage(null);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "configurationUpdateId=" + this.configurationUpdateId + ", " + "ConfigurationUpdateStatus=" + this.status + ", " + "configuration=" + this.configuration + "]";
    }
}

