/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.web.tomcat.service.session.distributedcache.impl.jbc;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.web.tomcat.service.session.distributedcache.impl.jbc.AbstractJBossCacheService;
import org.jboss.web.tomcat.service.session.distributedcache.spi.ClusteringNotSupportedException;
import org.jboss.web.tomcat.service.session.distributedcache.spi.LocalDistributableSessionManager;
import org.jboss.web.tomcat.service.session.distributedcache.spi.OutgoingAttributeGranularitySessionData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeBasedJBossCacheService
extends AbstractJBossCacheService<OutgoingAttributeGranularitySessionData> {
    public AttributeBasedJBossCacheService(LocalDistributableSessionManager localManager) throws ClusteringNotSupportedException {
        super(localManager);
    }

    public AttributeBasedJBossCacheService(LocalDistributableSessionManager localManager, Cache<Object, Object> cache) {
        super(localManager, cache);
    }

    public boolean getSupportsAttributeOperations() {
        return true;
    }

    public Object getAttribute(String realId, String key) {
        Fqn<String> fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        return this.getUnMarshalledValue(this.cacheWrapper_.get(fqn, key));
    }

    public void putAttribute(String realId, String key, Object value) {
        Fqn<String> fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        this.cacheWrapper_.put(fqn, key, this.getMarshalledValue(value));
    }

    public void putAttribute(String realId, Map<String, Object> map) {
        HashMap<Object, Object> marshalled = new HashMap<Object, Object>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            marshalled.put(entry.getKey(), this.getMarshalledValue(entry.getValue()));
        }
        Fqn<String> fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        this.cacheWrapper_.put(fqn, marshalled);
    }

    public Object removeAttribute(String realId, String key) {
        Fqn<String> fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("Remove attribute from distributed store. Fqn: " + fqn + " key: " + key));
        }
        return this.getUnMarshalledValue(this.cacheWrapper_.remove(fqn, key));
    }

    public void removeAttributeLocal(String realId, String key) {
        Fqn<String> fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        if (this.log_.isTraceEnabled()) {
            this.log_.trace((Object)("Remove attribute from distributed store. Fqn: " + fqn + " key: " + key));
        }
        this.cacheWrapper_.removeLocal(fqn, key);
    }

    public Set<String> getAttributeKeys(String realId) {
        Set keys = null;
        Fqn<String> fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        try {
            Node node = this.getCache().getRoot().getChild(fqn);
            if (node != null) {
                keys = node.getKeys();
                keys.removeAll(INTERNAL_KEYS);
            }
        }
        catch (CacheException e) {
            this.log_.error((Object)("getAttributeKeys(): Exception getting keys for session " + realId), (Throwable)e);
        }
        return keys;
    }

    public Map<String, Object> getAttributes(String realId) {
        if (realId == null || realId.length() == 0) {
            Map empty = Collections.EMPTY_MAP;
            return empty;
        }
        Fqn<String> fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, realId);
        Node node = this.getCache().getRoot().getChild(fqn);
        Map rawData = node.getData();
        return this.getSessionAttributes(realId, rawData);
    }

    @Override
    protected Map<String, Object> getSessionAttributes(String realId, Map<Object, Object> distributedCacheData) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        for (Map.Entry<Object, Object> entry : distributedCacheData.entrySet()) {
            if (!(entry.getKey() instanceof String)) continue;
            attrs.put((String)entry.getKey(), this.getUnMarshalledValue(entry.getValue()));
        }
        return attrs;
    }

    @Override
    protected void storeSessionAttributes(Map<Object, Object> dataMap, OutgoingAttributeGranularitySessionData sessionData) {
        Set removed;
        Fqn<String> fqn = null;
        Map map = sessionData.getModifiedSessionAttributes();
        if (map != null) {
            HashMap<Object, Object> marshalled = new HashMap<Object, Object>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                marshalled.put(entry.getKey(), this.getMarshalledValue(entry.getValue()));
            }
            fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, sessionData.getRealId());
            this.cacheWrapper_.put(fqn, marshalled);
        }
        if ((removed = sessionData.getRemovedSessionAttributes()) != null) {
            if (fqn == null) {
                fqn = AttributeBasedJBossCacheService.getSessionFqn(this.combinedPath_, sessionData.getRealId());
            }
            for (String key : removed) {
                this.cacheWrapper_.remove(fqn, key);
            }
        }
    }
}

