/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.spi.management;

import java.util.Map;
import org.jboss.dependency.spi.ControllerState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextStateMapper<T extends Enum<?>> {
    private Map<String, T> mappings;
    private T installState;
    private T uninstallState;
    private T unknown;
    private T error;

    public ContextStateMapper(Map<String, T> mappings, T installState, T uninstallState, T error, T unknown) {
        this.mappings = mappings;
        this.installState = installState;
        this.uninstallState = uninstallState;
        this.error = error;
        this.unknown = unknown;
    }

    public T getErrorState() {
        return this.error;
    }

    public T map(ControllerState currentState, ControllerState toState) {
        if (toState == null || currentState.equals((Object)toState)) {
            return this.getMapping(currentState);
        }
        if (ControllerState.ERROR.equals((Object)currentState)) {
            return this.error;
        }
        if (ControllerState.INSTALLED.equals((Object)toState)) {
            return this.installState;
        }
        if (ControllerState.NOT_INSTALLED.equals((Object)toState)) {
            return this.uninstallState;
        }
        return this.getMapping(currentState);
    }

    protected T getMapping(ControllerState controllerState) {
        Object state = this.unknown;
        if (controllerState != null) {
            state = (Enum)this.mappings.get(controllerState.getStateString());
        }
        return state;
    }
}

