/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util;

import java.text.NumberFormat;
import java.text.ParseException;

public final class NumberUtil {
    public static final Number NaN = Double.NaN;

    private NumberUtil() {
    }

    public static Number stringAsNumber(String input) {
        return NumberUtil._parse(input, NumberFormat.getNumberInstance());
    }

    public static String numberAsString(double input) {
        return NumberUtil._format(input, NumberFormat.getNumberInstance());
    }

    public static Number stringAsPercentage(String input) {
        return NumberUtil._parse(input, NumberFormat.getPercentInstance());
    }

    public static String percentageAsString(double input) {
        return NumberUtil._format(input, NumberFormat.getPercentInstance());
    }

    private static Number _parse(String input, NumberFormat fmt) {
        if (null != input && input.trim().length() > 0) {
            try {
                return fmt.parse(input);
            }
            catch (ParseException e) {
                return NaN;
            }
        }
        return NaN;
    }

    private static String _format(double input, NumberFormat fmt) {
        if (NaN.doubleValue() != input) {
            return fmt.format(input);
        }
        return null;
    }
}

